/*
 * Decompiled with CFR 0.152.
 */
package me.andy.ecomobs.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.ecomobs.EcoMobs;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MessageFormatter {
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?:&#([0-9a-fA-F]{6}))|(?:&([0-9a-fk-orA-FK-OR]))|(\\{(.*?)\\})|(<action:(\\w+),([^>]*?)>)|([^&{<]+)");

    private static String ensureUrlScheme(String url) {
        if (url == null) {
            return "";
        }
        String trimmedUrl = url.trim();
        if (trimmedUrl.matches("(?i)^(https?|ftp)://.*")) {
            return trimmedUrl;
        }
        return "http://" + trimmedUrl;
    }

    public static List<class_2561> formatLines(List<String> rawLines, @Nullable class_3222 player, @Nullable MinecraftServer server) {
        ArrayList<class_2561> formattedTexts = new ArrayList<class_2561>();
        if (rawLines == null) {
            return formattedTexts;
        }
        for (String rawLine : rawLines) {
            formattedTexts.add((class_2561)MessageFormatter.parseSingleLine(rawLine, player, server, false));
        }
        return formattedTexts;
    }

    private static class_5250 commitAndGetSegment(class_5250 baseComponent, StringBuilder pendingPlainText, class_2583 currentStyle) {
        if (pendingPlainText.length() > 0) {
            String segmentText = pendingPlainText.toString();
            class_5250 segment = class_2561.method_43470((String)segmentText).method_10862(currentStyle);
            baseComponent.method_10852((class_2561)segment);
            pendingPlainText.setLength(0);
            if (!segmentText.trim().isEmpty()) {
                return segment;
            }
        }
        return null;
    }

    public static class_5250 parseSingleLine(String rawLine, @Nullable class_3222 player, @Nullable MinecraftServer server, boolean isParsingForHoverText) {
        class_5250 baseComponent = class_2561.method_43470((String)"");
        if (rawLine == null || rawLine.isEmpty()) {
            return baseComponent;
        }
        Matcher matcher = TOKENIZER_PATTERN.matcher(rawLine);
        class_2583 currentStyle = class_2583.field_24360;
        class_5250 activeInteractiveTarget = null;
        StringBuilder pendingPlainText = new StringBuilder();
        while (matcher.find()) {
            boolean isActionToken;
            String hexColor = matcher.group(1);
            String legacyFormat = matcher.group(2);
            String hoverContent = matcher.group(4);
            String actionType = matcher.group(6);
            String actionValue = matcher.group(7);
            String plainText = matcher.group(8);
            boolean isStyleToken = hexColor != null || legacyFormat != null;
            boolean bl = isActionToken = hoverContent != null || actionType != null && actionValue != null;
            if (isStyleToken || isActionToken) {
                class_5250 committedSegment = MessageFormatter.commitAndGetSegment(baseComponent, pendingPlainText, currentStyle);
                if (isActionToken) {
                    if (committedSegment != null) {
                        activeInteractiveTarget = committedSegment;
                    }
                } else {
                    activeInteractiveTarget = null;
                }
            }
            if (hexColor != null) {
                try {
                    currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hexColor)).getOrThrow());
                }
                catch (Exception e) {
                    EcoMobs.LOGGER.warn("Invalid hex color code: {}", (Object)hexColor, (Object)e);
                }
                continue;
            }
            if (legacyFormat != null) {
                char code = legacyFormat.toLowerCase().charAt(0);
                if (code == 'r') {
                    currentStyle = class_2583.field_24360;
                    continue;
                }
                class_124 mcFormatting = class_124.method_544((char)code);
                if (mcFormatting == null) continue;
                currentStyle = MessageFormatter.applyMinecraftFormatting(currentStyle, mcFormatting);
                continue;
            }
            if (hoverContent != null) {
                if (isParsingForHoverText || activeInteractiveTarget == null) continue;
                class_5250 parsedHover = MessageFormatter.parseSingleLine(hoverContent, player, server, true);
                activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)parsedHover)));
                continue;
            }
            if (actionType != null && actionValue != null) {
                class_2558 ce;
                if (isParsingForHoverText || activeInteractiveTarget == null) continue;
                String finalActionValue = actionValue.trim();
                if (finalActionValue.contains("%player%") && player != null) {
                    finalActionValue = finalActionValue.replace("%player%", player.method_5477().getString());
                }
                if ((ce = MessageFormatter.createClickEvent(actionType, finalActionValue)) == null) continue;
                activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10958(ce));
                continue;
            }
            if (plainText == null) continue;
            pendingPlainText.append(plainText);
        }
        MessageFormatter.commitAndGetSegment(baseComponent, pendingPlainText, currentStyle);
        return baseComponent;
    }

    private static class_2558 createClickEvent(String actionType, String value) {
        String lowerActionType = actionType.toLowerCase().trim();
        try {
            return switch (lowerActionType) {
                case "run_command" -> new class_2558.class_10609(value);
                case "suggest_command" -> new class_2558.class_10610(value);
                case "open_url" -> new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(value)));
                case "copy_to_clipboard" -> new class_2558.class_10606(value);
                default -> null;
            };
        }
        catch (URISyntaxException e) {
            EcoMobs.LOGGER.warn("Error creating ClickEvent for URL '{}': {}", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    private static class_2583 applyMinecraftFormatting(class_2583 style, class_124 formatting) {
        if (formatting.method_543()) {
            return style.method_10977(formatting);
        }
        return switch (formatting) {
            case class_124.field_1051 -> style.method_36141(Boolean.valueOf(true));
            case class_124.field_1067 -> style.method_10982(Boolean.valueOf(true));
            case class_124.field_1055 -> style.method_36140(Boolean.valueOf(true));
            case class_124.field_1073 -> style.method_30938(Boolean.valueOf(true));
            case class_124.field_1056 -> style.method_10978(Boolean.valueOf(true));
            default -> style;
        };
    }
}

