/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client;

import com.google.common.collect.Queues;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mcsrranked.client.anticheat.AntiCheatManager;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.tracking.PersonalPlayerTracker;
import com.mcsrranked.client.config.RankedGameRules;
import com.mcsrranked.client.gui.screen.RankedMainScreen;
import com.mcsrranked.client.gui.screen.match.MatchPrivateRoomScreen;
import com.mcsrranked.client.gui.widget.MatchChatWidget;
import com.mcsrranked.client.gui.widget.RankUpAnimationWidget;
import com.mcsrranked.client.info.BannerInfo;
import com.mcsrranked.client.info.RunTimer;
import com.mcsrranked.client.info.match.EventMode;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.MatchArgument;
import com.mcsrranked.client.info.match.online.MatchOption;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.OnlineQueue;
import com.mcsrranked.client.info.match.online.gamemode.GameMode;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerConnections;
import com.mcsrranked.client.info.player.PlayerCountry;
import com.mcsrranked.client.info.player.PlayerPermission;
import com.mcsrranked.client.info.race.WeeklyRace;
import com.mcsrranked.client.interaction.AutoRequestManager;
import com.mcsrranked.client.interaction.PlayerMuteManager;
import com.mcsrranked.client.utils.CrashReportUtils;
import com.mcsrranked.client.utils.SSLFixer;
import com.mcsrranked.client.utils.UpdateChecker;
import com.mcsrranked.client.world.entity.PiglinBruteEntity;
import com.mcsrranked.client.world.entity.PiglinBruteRenderer;
import com.mcsrranked.client.world.loot.RankedModifiedLootCondition;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Security;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5132;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MCSRRankedClient
implements ClientModInitializer,
PreLaunchEntrypoint {
    public static final String MOD_ID = "mcsrranked";
    public static final Logger LOGGER;
    public static final String SERVER_URL;
    public static final String REPLAY_CDN_URL;
    public static final ModContainer MOD_CONTAINER;
    public static final Path GLOBAL_PATH;
    public static final File TEMP_REPLAY_FILE;
    public static final Path REPLAY_CACHE_PATH;
    public static final ExecutorService THREAD_EXECUTOR;
    public static final Gson GSON;
    private static OnlineMatch ONLINE_MATCH;
    private static OnlineQueue ONLINE_QUEUE;
    private static WeeklyRace SEED_RACE;
    public static ReplayProcessor CURRENT_REPLAY;
    private static PersonalPlayerTracker CURRENT_TRACKER;
    public static Deque<class_3545<Integer, OnlinePlayer>> RECENT_MATCHES;
    public static OnlinePlayer LOCAL_PLAYER;
    public static String LOCAL_REPLAY_SIGNED_KEY;
    public static PlayerConnections PLAYER_CONNECTIONS;
    public static MatchArgument MATCH_ARGUMENT;
    public static EventMode CURRENT_EVENT;
    public static int REFRESH_CACHED;
    public static BannerInfo BANNER_INFO;
    public static PlayerPermission PLAYER_PERMISSION;
    public static MatchOption LAST_MATCH_OPTION;
    public static boolean PRIVATE_CHAT_MODE;
    public static String LAST_CUSTOM_BACKGROUND_URL;
    private static boolean IS_MOD_INITIALIZED;
    private static final AntiCheatManager antiCheatManager;

    public static Optional<OnlineMatch> getOnlineMatch() {
        return Optional.ofNullable(ONLINE_MATCH);
    }

    public static void setOnlineMatch(@Nullable OnlineMatch onlineMatch) {
        ONLINE_MATCH = onlineMatch;
    }

    public static Optional<OnlineQueue> getCurrentQueue() {
        return Optional.ofNullable(ONLINE_QUEUE);
    }

    public static void setCurrentQueue(@Nullable MatchType matchType) {
        if (matchType == null) {
            ONLINE_QUEUE = null;
        } else if (ONLINE_QUEUE == null) {
            ONLINE_QUEUE = new OnlineQueue(matchType);
        }
    }

    public static Optional<WeeklyRace> getCurrentRace() {
        return Optional.ofNullable(SEED_RACE);
    }

    public static void setCurrentRace(WeeklyRace race) {
        SEED_RACE = race;
    }

    public static Optional<RunTimer> getCurrentTimer() {
        if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus().isPlaying()).orElse(false).booleanValue()) {
            return Optional.of(MCSRRankedClient.getOnlineMatch().get().getRunTimer());
        }
        if (MCSRRankedClient.getCurrentRace().map(WeeklyRace::isPlaying).orElse(false).booleanValue()) {
            return Optional.of(MCSRRankedClient.getCurrentRace().get().getRunTimer());
        }
        return Optional.empty();
    }

    public static Optional<PersonalPlayerTracker> getCurrentReplayTracker() {
        return Optional.ofNullable(CURRENT_TRACKER);
    }

    public static void setCurrentReplayTracker(PersonalPlayerTracker tracker) {
        CURRENT_TRACKER = tracker;
    }

    public static Optional<ReplayProcessor> getReplayProcessor() {
        if (MCSRRankedClient.getOnlineMatch().map(matchInfo -> matchInfo.getStatus().isPlaying()).orElse(false).booleanValue()) {
            return Optional.ofNullable(MCSRRankedClient.getOnlineMatch().get().getReplay().getReplayProcessor());
        }
        if (MCSRRankedClient.getCurrentRace().map(WeeklyRace::isPlaying).orElse(false).booleanValue()) {
            return Optional.ofNullable(MCSRRankedClient.getCurrentRace().get().getReplayProcessor());
        }
        return Optional.ofNullable(CURRENT_REPLAY);
    }

    public void onInitializeClient() {
        GLOBAL_PATH.toFile().mkdir();
        PlayerMuteManager.load();
        UpdateChecker.check();
        MCSRRankedClient.getAntiCheatManager().ifPresent(AntiCheatManager::preClient);
        LOGGER.info("System Java Runtime Build: {}", (Object)System.getProperty("java.runtime.version"));
        MCSRRankedClient.initCompletion();
        RankedGameRules.init();
        RankedModifiedLootCondition.builder(true).build();
        CrashReportUtils.init();
        EntityRendererRegistry.INSTANCE.register(PiglinBruteEntity.TYPE, (manager, context) -> new PiglinBruteRenderer(manager));
        FabricDefaultAttributeRegistry.register(PiglinBruteEntity.TYPE, (class_5132.class_5133)PiglinBruteEntity.register());
        class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)RankUpAnimationWidget.RANK_UP_SOUND.method_14833(), (Object)RankUpAnimationWidget.RANK_UP_SOUND);
    }

    public static void onInitializeMod() {
        if (IS_MOD_INITIALIZED) {
            return;
        }
        PlayerCountry.of("us");
        IS_MOD_INITIALIZED = true;
    }

    public void onPreLaunch() {
        try {
            Security.setProperty("networkaddress.cache.ttl", "60");
            Field profiling = EventFactory.class.getDeclaredField("profilingEnabled");
            profiling.setAccessible(true);
            profiling.setBoolean(null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MCSRRankedClient.getAntiCheatManager().ifPresent(AntiCheatManager::preLaunch);
        OnlineMatch.init();
    }

    public static void runningSchedule() {
        AutoRequestManager.load();
    }

    public static Optional<AntiCheatManager> getAntiCheatManager() {
        return Optional.ofNullable(antiCheatManager);
    }

    public static String getServerUrl(String prefix) {
        return MCSRRankedClient.getServerUrl(prefix, true);
    }

    public static String getServerUrl(String prefix, boolean https) {
        return prefix + (https ? (SERVER_URL.startsWith("localhost") || SERVER_URL.contains("redlimerl") ? "" : "s") : "") + "://" + SERVER_URL;
    }

    public static void leavePrivateRoom() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof MatchPrivateRoomScreen) {
            class_310.method_1551().method_1507((class_437)RankedMainScreen.create());
        }
    }

    public static void resetOnlinePlay() {
        MCSRRankedClient.setOnlineMatch(null);
        MatchChatWidget.clearChat();
    }

    public static void exitReplay() {
        MCSRRankedClient.getCurrentRace().ifPresent(race -> {
            race.setRunning(false);
            race.setPracticing(false);
        });
        MCSRRankedClient.setCurrentReplayTracker(null);
        MCSRRankedClient.getReplayProcessor().ifPresent(processor -> processor.setActive(false));
        ReplayManager.REPLAY_LOAD_THREAD = null;
        CURRENT_REPLAY = null;
    }

    public static void initCompletion() {
        InGameTimer.onComplete(timer -> {
            if (MCSRRankedClient.getCurrentRace().map(WeeklyRace::isRunning).orElse(false).booleanValue()) {
                MCSRRankedClient.getCurrentRace().get().onComplete();
            }
            if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus() == MatchStatus.RUNNING).orElse(false).booleanValue()) {
                MCSRRankedClient.getOnlineMatch().get().onComplete();
            }
        });
    }

    static {
        AntiCheatManager antiCheatManager1;
        LOGGER = LogManager.getLogger((String)"MCSR-Ranked");
        SERVER_URL = System.getenv("bypass-dev-server") == null && FabricLoader.getInstance().isDevelopmentEnvironment() ? "localhost:17432" : "mcsrranked.com";
        REPLAY_CDN_URL = System.getenv("bypass-dev-server") == null && FabricLoader.getInstance().isDevelopmentEnvironment() ? "http://" + SERVER_URL + "/replay/" : "https://d3mfy0kz8mefbn.cloudfront.net/";
        THREAD_EXECUTOR = Executors.newFixedThreadPool(2);
        GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().registerTypeAdapterFactory(GameMode.GSON_ADAPTER).create();
        ONLINE_MATCH = null;
        ONLINE_QUEUE = null;
        SEED_RACE = null;
        CURRENT_REPLAY = null;
        CURRENT_TRACKER = null;
        RECENT_MATCHES = Queues.newArrayDeque();
        LOCAL_PLAYER = null;
        LOCAL_REPLAY_SIGNED_KEY = null;
        PLAYER_CONNECTIONS = null;
        MATCH_ARGUMENT = null;
        CURRENT_EVENT = null;
        REFRESH_CACHED = 0;
        BANNER_INFO = null;
        PLAYER_PERMISSION = null;
        LAST_MATCH_OPTION = null;
        PRIVATE_CHAT_MODE = false;
        LAST_CUSTOM_BACKGROUND_URL = null;
        IS_MOD_INITIALIZED = false;
        try {
            SSLFixer.fixer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            antiCheatManager1 = new AntiCheatManager();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load mod whitelist data. [{}]", (Object)e.getMessage());
            antiCheatManager1 = null;
        }
        antiCheatManager = antiCheatManager1;
        Optional container = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (!container.isPresent()) {
            throw new RuntimeException("Mod container has not found.");
        }
        MOD_CONTAINER = (ModContainer)container.get();
        File globalPath = new File(System.getProperty("user.home").replace("\\", "/"), MOD_ID);
        GLOBAL_PATH = Files.isReadable(globalPath.toPath()) && Files.isWritable(globalPath.toPath()) ? globalPath.toPath() : FabricLoader.getInstance().getGameDir().resolve(MOD_ID);
        TEMP_REPLAY_FILE = GLOBAL_PATH.resolve("replay_temp.rpd").toFile();
        TEMP_REPLAY_FILE.deleteOnExit();
        REPLAY_CACHE_PATH = GLOBAL_PATH.resolve("replay-cached");
        REPLAY_CACHE_PATH.toFile().mkdir();
    }
}

