/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.file.verifiers;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcsrranked.client.utils.ClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class FileVerifier<E> {
    private final HashSet<VerifiableFile> allowedFiles = new HashSet();

    public FileVerifier(String apiEndpoint) throws IOException, IllegalStateException {
        for (JsonElement e : Optional.ofNullable(ClientUtils.getApiResponse(apiEndpoint)).orElseThrow(IOException::new).getAsJsonArray()) {
            this.allowedFiles.add(VerifiableFile.fromJson(e));
        }
    }

    protected HashSet<VerifiableFile> getAllowedFiles() {
        return this.allowedFiles;
    }

    public Stream<IllegalFile> filterStream(Stream<E> input) {
        return input.map(file -> this.compareFiles(file, this.allowedFiles).map(reason -> new IllegalFile(file, (RejectionReason)((Object)((Object)reason)))).orElse(null));
    }

    public abstract void preLaunch();

    public abstract void preMixin();

    public abstract void preClient();

    public static Optional<String> digestFileStream(InputStream inputStream, String algorithm) throws IOException {
        Optional<String> optional;
        block9: {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            InputStream is = inputStream;
            try {
                int read;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                optional = Optional.ofNullable(Base64.getEncoder().encodeToString(digest.digest()));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    public abstract Optional<RejectionReason> compareFiles(E var1, Set<VerifiableFile> var2);

    public abstract Optional<String> fileToHash(E var1, String var2);

    public static class VerifiableFile {
        public final String name;
        public final List<Hash> hashes;

        public VerifiableFile(String name, String hash) {
            this(name, hash, null);
        }

        public VerifiableFile(String name, String hash, @Nullable String version) {
            this(name, new Hash(hash, version));
        }

        public VerifiableFile(String name, Hash ... hashes) {
            this.name = name;
            this.hashes = Lists.newArrayList((Object[])hashes);
        }

        public Optional<Hash> getVersionHash(String version) {
            for (Hash hash : this.hashes) {
                if (!Objects.equals(hash.version, version)) continue;
                return Optional.of(hash);
            }
            return Optional.empty();
        }

        public String getFirstHash() {
            return this.hashes.get((int)0).value;
        }

        public String toString() {
            return this.name;
        }

        public static VerifiableFile fromJson(JsonElement element) {
            JsonObject object = element.getAsJsonObject();
            String name = object.get("name").getAsString();
            if (object.has("hash_values")) {
                ArrayList hashes = Lists.newArrayList();
                for (JsonElement jsonElement : object.getAsJsonArray("hash_values")) {
                    JsonObject hashObject = jsonElement.getAsJsonObject();
                    hashes.add(new Hash(hashObject.get("hash").getAsString(), hashObject.get("version").getAsString()));
                }
                return new VerifiableFile(name, hashes.toArray(new Hash[0]));
            }
            return new VerifiableFile(name, object.get("hash").getAsString());
        }

        public static class Hash {
            public final String value;
            @Nullable
            public final String version;
            public final String algorithm;

            public Hash(String value, @Nullable String version) {
                this(value, version, "SHA-256");
            }

            public Hash(String value, @Nullable String version, String algorithm) {
                this.value = value;
                this.version = version;
                this.algorithm = algorithm;
            }
        }
    }

    public class IllegalFile {
        public E file;
        public RejectionReason rejectionReason;

        public IllegalFile(E file, RejectionReason rejectionReason) {
            this.file = file;
            this.rejectionReason = rejectionReason;
        }

        public RejectionReason getRejectionReason() {
            return this.rejectionReason;
        }
    }

    public static enum RejectionReason {
        ID{

            @Override
            public String getRejectionMessage(String fileName, String type) {
                return "The " + type + " \"" + fileName + "\" is not whitelisted!";
            }

            @Override
            public String getRejectionTitle(String type) {
                return "These " + type + "s are not whitelisted! You should delete these from Minecraft.";
            }
        }
        ,
        VERSION{

            @Override
            public String getRejectionMessage(String fileName, String type) {
                return "A different version of the " + type + " \"" + fileName + "\" is whitelisted! Make sure to update your " + type + "!";
            }

            @Override
            public String getRejectionTitle(String type) {
                return "These " + type + "s are whitelisted but different version! Make sure to update these!";
            }
        }
        ,
        HASH{

            @Override
            public String getRejectionMessage(String fileName, String type) {
                return "The " + type + " \"" + fileName + "\" is whitelisted and you seem to be using the correct version but the files do not match. Try downloading the " + type + " file again!";
            }

            @Override
            public String getRejectionTitle(String type) {
                return "These " + type + "s are whitelisted and you seem to be using the correct version but the files do not match. Try downloading these files again!";
            }
        };


        public abstract String getRejectionMessage(String var1, String var2);

        public abstract String getRejectionTitle(String var1);
    }
}

