/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.mixin.replay;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.AfterWorldTick;
import com.mcsrranked.client.gui.screen.match.replay.LiveReplayTimeOffsetScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1132;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MixinMinecraftClient
implements AfterWorldTick {
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Final
    public class_327 field_1772;
    @Unique
    private List<Runnable> runnableList = Lists.newCopyOnWriteArrayList();

    @Shadow
    @Nullable
    public abstract class_1132 method_1576();

    @Shadow
    public abstract void method_1507(@Nullable class_437 var1);

    @Shadow
    public abstract class_1041 method_22683();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onClientTick(CallbackInfo ci) {
        if (this.method_1576() != null && this.field_1687 != null) {
            MCSRRankedClient.getCurrentReplayTracker().ifPresent(tracker -> {
                if (tracker.isActive()) {
                    tracker.tickTracker();
                    if (MCSRRankedClient.getCurrentRace().map(race -> race.isPlaying() && race.getReplayProcessor() != null).orElse(false).booleanValue()) {
                        MCSRRankedClient.getCurrentRace().get().getReplayProcessor().setActive(true);
                    }
                }
                tracker.increaseTick();
            });
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/GameRenderer;render(FJZ)V")})
    public void onRenderBeforeWorld(boolean tick, CallbackInfo ci) {
        MCSRRankedClient.getReplayProcessor().ifPresent(processor -> processor.getActiveTrackers().forEach(tracker -> tracker.getEntityManager().getAllTrackers().forEach(ReplayEntityTracker::onRender)));
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/toast/ToastManager;draw(Lnet/minecraft/client/util/math/MatrixStack;)V", shift=At.Shift.AFTER)})
    public void onRender(boolean tick, CallbackInfo ci) {
        if (MCSRRankedClient.getReplayProcessor().map(ReplayProcessor::isLoading).orElse(false).booleanValue()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)this.method_22683().method_4486() / 2.0f), (float)(this.method_22683().method_4502() - 68), (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_5250 text = new class_2588("projectelo.text.loading_replay").method_27693("...");
            class_4587 matrixStack = new class_4587();
            int loadingWidth = this.field_1772.method_27525((class_5348)text);
            float loadingOffset = (float)(-loadingWidth) / 2.0f;
            int n = (int)(loadingOffset - 3.0f);
            int n2 = (int)(loadingOffset + (float)loadingWidth + 3.0f);
            Objects.requireNonNull(this.field_1772);
            class_329.method_25294((class_4587)matrixStack, (int)n, (int)-6, (int)n2, (int)(-2 + 9), (int)-2013265920);
            this.field_1772.method_27528(new class_4587(), (class_5348)text, loadingOffset, -4.0f, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
    }

    @Inject(method={"openPauseMenu"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;isIntegratedServerRunning()Z")}, cancellable=true)
    public void onOpenPauseMenu(boolean pause, CallbackInfo ci) {
        if (MCSRRankedClient.getReplayProcessor().map(ReplayProcessor::shouldStopTick).orElse(false).booleanValue() && !MCSRRankedClient.getOnlineMatch().map(matchInfo -> matchInfo.getStatus().isPlaying()).orElse(false).booleanValue()) {
            this.method_1507(new LiveReplayTimeOffsetScreen(MCSRRankedClient.getReplayProcessor().get()));
            ci.cancel();
        }
    }

    @Override
    public void ranked$addRunnableAfterWorldTick(Runnable runnable) {
        this.runnableList.add(runnable);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;tickEntities()V", shift=At.Shift.AFTER)})
    public void afterTickEntities(CallbackInfo ci) {
        for (Runnable runnable : this.runnableList) {
            runnable.run();
        }
        this.runnableList.clear();
    }
}

