/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay;

import com.google.common.collect.Lists;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeDragonSpawnable;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.WorldEntityAddable;
import com.mcsrranked.client.utils.ClientUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1527;
import net.minecraft.class_2881;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3417;
import net.minecraft.class_5281;
import net.minecraft.server.MinecraftServer;

public class ReplayDragonFight {
    public static final float WING_MULTIPLIER = 0.025f;
    private class_1510 dragonEntity = null;
    private final OpponentPlayerTracker tracker;
    private final ConcurrentHashMap<Integer, Integer> dragonHealthTimeline = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> crystalDestroyTimeline = new ConcurrentHashMap();
    private boolean hasInit = false;

    public ReplayDragonFight(OpponentPlayerTracker tracker) {
        this.tracker = tracker;
    }

    public void refresh(int tick, MinecraftServer server) {
        if (this.tracker.isGhostMode()) {
            if (this.dragonEntity != null && !this.dragonEntity.field_5988) {
                this.dragonEntity.field_5988 = true;
            }
            for (class_3218 world : server.method_3738()) {
                class_2881 endFight = world.method_29198();
                if (endFight == null) continue;
                List spikes = class_3310.method_14506((class_5281)world);
                for (class_3310.class_3181 spike : spikes) {
                    if (!world.method_8393(spike.method_13966() >> 4, spike.method_13967() >> 4)) continue;
                    List crystals = world.method_18467(class_1511.class, spike.method_13968());
                    crystals.forEach(class_1297::method_5650);
                }
            }
            this.hasInit = true;
            return;
        }
        this.hasInit = false;
        Optional<Integer> lastTickTimeline = this.dragonHealthTimeline.keySet().stream().filter(i -> i <= tick).max(Comparator.naturalOrder());
        int targetHealth = lastTickTimeline.map(this.dragonHealthTimeline::get).orElse(200);
        ArrayList destroyCrystals = Lists.newArrayList();
        this.crystalDestroyTimeline.keySet().stream().filter(i -> i <= tick).forEach(key -> destroyCrystals.add(this.crystalDestroyTimeline.get(key)));
        for (class_3218 world : server.method_3738()) {
            class_2881 endFight = world.method_29198();
            if (endFight == null) continue;
            List spikes = class_3310.method_14506((class_5281)world);
            for (class_3310.class_3181 spike : spikes) {
                if (world.method_8393(spike.method_13966() >> 4, spike.method_13967() >> 4)) continue;
                return;
            }
            for (int i2 = 0; i2 < spikes.size(); ++i2) {
                class_3310.class_3181 spike;
                spike = (class_3310.class_3181)spikes.get(i2);
                List crystals = world.method_18467(class_1511.class, spike.method_13968());
                if (destroyCrystals.contains(i2)) {
                    crystals.forEach(class_1297::method_5650);
                    continue;
                }
                if (!crystals.isEmpty()) continue;
                class_1511 endCrystalEntity = (class_1511)class_1299.field_6110.method_5883(world.method_8410());
                assert (endCrystalEntity != null);
                endCrystalEntity.method_5808((double)spike.method_13966() + 0.5, (double)(spike.method_13964() + 1), (double)spike.method_13967() + 0.5, new Random().nextFloat() * 360.0f, 0.0f);
                ((WorldEntityAddable)world).ranked$spawnEntityInReplay((class_1297)endCrystalEntity);
            }
            endFight.method_12524();
            if (this.getDragon().map(dragonEntity -> dragonEntity.field_7031 > 0).orElse(false).booleanValue()) {
                this.dragonEntity.method_5650();
                this.dragonEntity = null;
                endFight.method_12522();
                this.dragonEntity = ((TimeDragonSpawnable)endFight).replay$createDummyDragon();
            }
            if (targetHealth >= 0 && !this.getDragon().isPresent()) {
                endFight.method_12522();
                this.dragonEntity = ((TimeDragonSpawnable)endFight).replay$createDummyDragon();
            }
            if (this.dragonEntity != null) {
                this.dragonEntity.method_6831().method_6863(targetHealth <= 0 ? class_1527.field_7068 : class_1527.field_7069);
            }
            this.hasInit = true;
        }
        this.getDragon().ifPresent(dragon -> dragon.method_6033(targetHealth >= 0 ? (float)Math.max(1, targetHealth) : 0.0f));
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void tick(int tick, MinecraftServer server) {
        this.getDragon().ifPresent(dragon -> {
            if (dragon.method_6831().method_6864().method_6849() == class_1527.field_7068) {
                dragon.field_7024 = null;
            }
        });
        if (this.getDragon().isPresent() && this.getDragon().get().field_5988) {
            this.dragonEntity = null;
            return;
        }
        if (this.dragonHealthTimeline.containsKey(tick)) {
            int health = this.dragonHealthTimeline.get(tick);
            this.getDragon().ifPresent(dragon -> {
                if (health == 0) {
                    dragon.method_6831().method_6863(class_1527.field_7068);
                    dragon.method_5643(class_1282.field_5869, 1.0f);
                    dragon.method_6033(0.0141f);
                } else if (health < 0) {
                    dragon.method_6033(0.0f);
                    dragon.method_5643(class_1282.field_5869, 2.1474836E9f);
                    this.dragonEntity = null;
                } else {
                    dragon.method_5643(class_1282.field_5869, 1.0f);
                    dragon.method_6033((float)health);
                }
                if (!dragon.field_6002.method_8608()) {
                    dragon.field_6002.method_8421((class_1297)dragon, (byte)2);
                    ClientUtils.playSound(class_3417.field_15086, dragon.method_5634(), (class_1297)dragon, 5.0f, (dragon.method_6051().nextFloat() - dragon.method_6051().nextFloat()) * 0.2f + 1.0f);
                }
            });
        }
        if (this.crystalDestroyTimeline.containsKey(tick)) {
            block0: for (class_3218 world : server.method_3738()) {
                if (world.method_29198() == null) continue;
                int crystalIndex = this.crystalDestroyTimeline.get(tick);
                List spikes = class_3310.method_14506((class_5281)world);
                for (int i = 0; i < spikes.size(); ++i) {
                    if (i != crystalIndex) continue;
                    class_3310.class_3181 spike = (class_3310.class_3181)spikes.get(i);
                    world.method_18467(class_1511.class, spike.method_13968()).forEach(class_1297::method_5650);
                    continue block0;
                }
            }
        }
    }

    public void onUpdateHealth(int tick, int health) {
        this.dragonHealthTimeline.put(tick, health);
    }

    public void onDestroyCrystal(int tick, int index) {
        this.crystalDestroyTimeline.put(tick, index);
    }

    public Optional<class_1510> getDragon() {
        if (this.dragonEntity == null || this.dragonEntity.method_6032() == 0.0f || this.dragonEntity.field_5988) {
            return Optional.empty();
        }
        return Optional.of(this.dragonEntity);
    }

    public void clear() {
        if (this.dragonEntity != null) {
            this.dragonEntity.method_5650();
            this.dragonEntity = null;
        }
        this.crystalDestroyTimeline.clear();
        this.dragonHealthTimeline.clear();
    }
}

