/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.utils.ClientUtils;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_638;

public class ReplayEntityTracker<T extends class_1297> {
    private final OpponentPlayerTracker tracker;
    private final int id;
    private final T target;
    private WorldTypes dimension;
    private class_243 spawnPos = class_243.field_1353;
    private float spawnYaw;
    private float spawnPitch;
    private class_243 pos = class_243.field_1353;
    private float yaw;
    private float pitch;
    private boolean visible = false;
    private boolean attacked = false;
    private boolean damaged = false;
    private boolean deathNextTick = false;
    private boolean shouldAlive = true;
    private boolean firstPos = false;
    private boolean shouldFollowPos = true;
    private boolean shouldRespawn = true;
    private int inanimate = 0;

    public ReplayEntityTracker(OpponentPlayerTracker tracker, int id, T target, WorldTypes dimension) {
        this.tracker = tracker;
        this.id = id;
        this.target = target;
        ((class_1297)this.target).field_6002 = null;
        this.dimension = dimension;
        this.target.method_5684(true);
        if (this.target instanceof class_1308) {
            ((class_1308)this.target).method_5977(true);
        }
    }

    public void attacked() {
        this.attacked = true;
    }

    public void damaged() {
        this.damaged = true;
    }

    public boolean isDead() {
        return !this.shouldAlive;
    }

    public void death() {
        if (this.isDead()) {
            return;
        }
        this.deathNextTick = true;
    }

    public void setVisible(boolean visible) {
        if (!this.visible && visible) {
            ((class_1297)this.getTarget()).field_6038 = this.getPos().method_10216();
            ((class_1297)this.getTarget()).field_5971 = this.getPos().method_10214();
            ((class_1297)this.getTarget()).field_5989 = this.getPos().method_10215();
        }
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public WorldTypes getDimension() {
        return this.dimension;
    }

    public void setDimension(WorldTypes dimension) {
        this.dimension = dimension;
    }

    public class_243 getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(double x, double y, double z, float yaw, float pitch) {
        this.spawnPos = new class_243(x, y, z);
        this.spawnYaw = yaw;
        this.spawnPitch = pitch;
        this.firstPos = false;
        this.shouldAlive = true;
        this.setPos(x, y, z, yaw, pitch);
    }

    public void setPos(double x, double y, double z, float yaw, float pitch) {
        this.pos = new class_243(x, y, z);
        this.yaw = yaw;
        this.pitch = pitch;
        this.setVisible(true);
    }

    public void inanimateNextTick() {
        this.inanimate = 5;
        this.target.method_22862(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215());
    }

    public T getTarget() {
        return this.target;
    }

    public int getId() {
        return this.id;
    }

    public void backToSpawn() {
        this.pos = new class_243(this.spawnPos.method_10216(), this.spawnPos.method_10214(), this.spawnPos.method_10215());
        this.yaw = this.spawnYaw;
        this.pitch = this.spawnPitch;
    }

    public class_243 getPos() {
        return this.pos;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void disableFollowPos() {
        this.shouldFollowPos = false;
    }

    public void disableRespawn() {
        this.shouldRespawn = false;
    }

    private void rollbackEntity() {
        ((class_1297)this.target).field_5988 = false;
        if (this.target instanceof class_1309) {
            ((class_1309)this.target).method_6033(((class_1309)this.target).method_6063());
            ((class_1309)this.target).field_6213 = 0;
        }
    }

    void tick(class_638 world) {
        boolean isInWorld;
        boolean bl = isInWorld = world.method_8469(this.getId()) != null;
        if (WorldTypes.fromDimension(world.method_8597()) != this.dimension || !this.isVisible() || !this.tracker.isActive() || this.tracker.isGhostMode() && !(this.getTarget() instanceof ReplayPlayerEntity)) {
            if (isInWorld) {
                if (this.target instanceof ReplayPlayerEntity) {
                    ((ReplayPlayerEntity)((Object)this.target)).removeBoat();
                }
                world.method_2945(this.id);
            }
            ((class_1297)this.target).field_6002 = null;
            return;
        }
        if (((class_1297)this.target).field_5988 && !this.shouldRespawn) {
            return;
        }
        if (this.shouldAlive) {
            if (((class_1297)this.target).field_6002 == null || !isInWorld) {
                this.rollbackEntity();
                ((class_1297)this.target).field_6002 = world;
                ((class_1297)this.target).field_6012 = 0;
                if (this.target instanceof ReplayPlayerEntity) {
                    ((ReplayPlayerEntity)((Object)this.target)).ridingUpdate();
                }
                this.target.method_5759(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch, 3, false);
                this.target.method_5808(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch);
                world.method_2942(this.id, this.target);
            } else if (!this.firstPos || this.shouldFollowPos) {
                this.rollbackEntity();
                if (world.method_8469(this.id) == null) {
                    world.method_2942(this.id, this.target);
                }
                if (this.target instanceof ReplayPlayerEntity) {
                    ((ReplayPlayerEntity)((Object)this.target)).ridingUpdate();
                }
                if (this.target.method_5707(new class_243(this.pos.method_10216(), this.target.method_23318(), this.pos.method_10215())) > Math.pow(12.0, 2.0) || this.inanimate > 0) {
                    this.target.method_5759(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch, 3, false);
                    this.target.method_5808(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch);
                    this.target.method_5847(this.yaw);
                    if (this.inanimate > 0) {
                        --this.inanimate;
                    }
                } else {
                    this.target.method_5759(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch, 3, false);
                    this.target.method_5683(this.yaw, 3);
                }
            }
        }
        this.firstPos = true;
        if (this.attacked) {
            if (this.target instanceof class_1309) {
                ((class_1309)this.target).method_6104(((class_1309)this.target).method_6058());
            }
            this.attacked = false;
        }
        if (this.damaged) {
            if (this.target instanceof class_1309) {
                ClientUtils.playSound(((class_1309)this.target).method_6011(class_1282.field_5869), this.target.method_5634(), this.target, 0.8f + new Random().nextFloat() * 0.5f);
            }
            this.target.method_5879();
            this.damaged = false;
        }
        if (this.deathNextTick) {
            if (this.target instanceof class_1309) {
                if (!(this.target instanceof ReplayPlayerEntity) || !((ReplayPlayerEntity)((Object)this.target)).isGhostMode()) {
                    ClientUtils.playSound(((class_1309)this.target).method_6002(), this.target.method_5634(), this.target, 1.0f);
                }
                ((class_1309)this.target).method_6033(0.0f);
            } else {
                this.target.method_5650();
            }
            this.deathNextTick = false;
            this.shouldAlive = false;
        }
    }

    public void onRender() {
        if (this.inanimate > 0) {
            this.target.method_5808(this.pos.method_10216(), this.pos.method_10214(), this.pos.method_10215(), this.yaw, this.pitch);
            this.target.method_5847(this.yaw);
        }
    }
}

