/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.render;

import com.google.common.collect.Lists;
import com.mcsrranked.client.anticheat.mixin.render.PlayerEntityModelAccessor;
import com.mcsrranked.client.anticheat.replay.Replay;
import com.mcsrranked.client.anticheat.replay.ReplayEntityManager;
import com.mcsrranked.client.anticheat.replay.render.CustomRenderPhase;
import com.mcsrranked.client.anticheat.replay.render.GoldenBootsFeatureRenderer;
import com.mcsrranked.client.anticheat.replay.render.ReplayBoatEntity;
import com.mcsrranked.client.anticheat.replay.tracking.cinematic.CinematicCamera;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.AfterWorldTick;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.utils.TextureUtils;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.minecraft.class_922;
import net.minecraft.class_970;
import net.minecraft.class_976;
import net.minecraft.class_979;
import net.minecraft.class_989;
import org.jetbrains.annotations.Nullable;

public class ReplayPlayerEntity
extends class_1309 {
    public static final HashMap<UUID, UUID> replayPlayerEntitySkins = new HashMap();
    private final ReplayBoatEntity replayPlayerBoat = new ReplayBoatEntity(Replay.REPLAY_BOAT_ENTITY_TYPE, null);
    private DisplayType displayType = DisplayType.NORMAL;
    private boolean ghostMode = false;
    private boolean pause = false;
    public class_1799 mainHandStack = class_1799.field_8037;
    public class_1799 offHandStack = class_1799.field_8037;
    public class_1799 headStack = class_1799.field_8037;
    public class_1799 chestStack = class_1799.field_8037;
    public class_1799 legsStack = class_1799.field_8037;
    public class_1799 feetStack = class_1799.field_8037;
    private boolean isOnRender = false;
    private boolean boatActivate = false;
    private class_243 boatPos = class_243.field_1353;
    boolean invisible = false;

    public ReplayPlayerEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    public Iterable<class_1799> method_5661() {
        return new ArrayList<class_1799>();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot.equals((Object)class_1304.field_6173)) {
            return this.mainHandStack;
        }
        if (slot.equals((Object)class_1304.field_6171)) {
            return this.offHandStack;
        }
        if (slot.equals((Object)class_1304.field_6169)) {
            return this.headStack;
        }
        if (slot.equals((Object)class_1304.field_6174)) {
            return this.chestStack;
        }
        if (slot.equals((Object)class_1304.field_6172)) {
            return this.legsStack;
        }
        if (slot.equals((Object)class_1304.field_6166)) {
            return this.feetStack;
        }
        return class_1799.field_8037;
    }

    public void clearInventory() {
        for (class_1304 value : class_1304.values()) {
            this.method_5673(value, class_1799.field_8037);
        }
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (slot.equals((Object)class_1304.field_6173)) {
            this.mainHandStack = stack;
        }
        if (slot.equals((Object)class_1304.field_6171)) {
            this.offHandStack = stack;
        }
        if (slot.equals((Object)class_1304.field_6169)) {
            this.headStack = stack;
        }
        if (slot.equals((Object)class_1304.field_6174)) {
            this.chestStack = stack;
        }
        if (slot.equals((Object)class_1304.field_6172)) {
            this.legsStack = stack;
        }
        if (slot.equals((Object)class_1304.field_6166)) {
            this.feetStack = stack;
        }
    }

    public void method_18382() {
        if (this.field_6002 != null) {
            super.method_18382();
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_6094() {
        return true;
    }

    public boolean method_5851() {
        int glowDistance = (Integer)SpeedRunOption.getOption(RankedOptions.REPLAY_GLOW_DISTANCE);
        if (glowDistance > 0 && !this.method_5767() && this.field_6002.field_9236 && class_310.method_1551().field_1719 != null && !this.isGhostMode()) {
            class_4184 gameCamera = class_310.method_1551().field_1773.method_19418();
            CinematicCamera camera = (CinematicCamera)gameCamera;
            return !camera.ranked$isCinematicActivated() && !this.method_24515().method_19769((class_2374)gameCamera.method_19326(), (double)glowDistance);
        }
        return false;
    }

    public boolean method_5765() {
        return super.method_5765() || this.isOnRender && this.boatActivate;
    }

    public void setBoatActivate(boolean boatActivate, class_243 pos) {
        this.boatActivate = boatActivate;
        this.boatPos = pos;
    }

    public void method_5773() {
        this.field_5960 = true;
        this.method_18799(class_243.field_1353);
        this.ridingUpdate();
        super.method_5773();
        this.method_6119();
    }

    public void ridingUpdate() {
        if (!(this.field_6002 instanceof class_638)) {
            return;
        }
        if (this.replayPlayerBoat.field_6002 != this.field_6002) {
            if (!this.boatActivate) {
                return;
            }
            this.replayPlayerBoat.field_5988 = false;
            this.replayPlayerBoat.field_6002 = this.field_6002;
            this.replayPlayerBoat.setTargetPlayer(this);
            if (this.replayPlayerBoat.method_5628() >= 0) {
                this.replayPlayerBoat.method_5838(ReplayEntityManager.ID_GENERATOR.decrementAndGet());
            }
            if (this.field_6002.method_8469(this.replayPlayerBoat.method_5628()) == null) {
                ((AfterWorldTick)class_310.method_1551()).ranked$addRunnableAfterWorldTick(() -> {
                    if (this.replayPlayerBoat.field_6002 != null) {
                        ((class_638)this.field_6002).method_2942(this.replayPlayerBoat.method_5628(), (class_1297)this.replayPlayerBoat);
                    }
                });
                return;
            }
        }
        if (!this.method_5765() && this.boatActivate) {
            this.replayPlayerBoat.method_5648(false);
            this.replayPlayerBoat.method_5808(this.boatPos.method_10216(), this.boatPos.method_10214(), this.boatPos.method_10215(), this.method_5791(), 0.0f);
            this.method_5873((class_1297)this.replayPlayerBoat, true);
        } else if (this.method_5765() && !this.boatActivate) {
            this.method_5848();
            this.replayPlayerBoat.method_5648(true);
        } else if (this.boatActivate) {
            this.replayPlayerBoat.method_5759(this.boatPos.method_10216(), this.boatPos.method_10214(), this.boatPos.method_10215(), this.replayPlayerBoat.getDirection(this.boatPos), 0.0f, 3, true);
        } else if (!this.replayPlayerBoat.method_5767()) {
            this.replayPlayerBoat.method_5648(true);
        }
    }

    public void method_18799(class_243 velocity) {
    }

    public boolean method_5767() {
        return this.invisible;
    }

    public void method_5648(boolean invisible) {
        this.invisible = invisible;
    }

    public boolean method_5756(class_1657 player) {
        return false;
    }

    public boolean method_5757() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public void setTargetSkinUuid(UUID uuid) {
        replayPlayerEntitySkins.put(this.field_6021, uuid);
    }

    public void removeBoat() {
        if (this.replayPlayerBoat.field_6002 != null) {
            ((class_638)this.replayPlayerBoat.field_6002).method_2945(this.replayPlayerBoat.method_5628());
            this.replayPlayerBoat.field_6002 = null;
        }
    }

    public void setGhostMode(boolean ghostMode) {
        this.ghostMode = ghostMode;
        DisplayType displayType = this.displayType = ghostMode ? DisplayType.TRANSLUCENT : DisplayType.NORMAL;
        if (this.field_6002 != null) {
            this.method_5848();
        }
    }

    public boolean isGhostMode() {
        return this.ghostMode;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public boolean method_5715() {
        return this.method_18376() == class_4050.field_18081;
    }

    public class_3414 method_6011(class_1282 source) {
        if (source == class_1282.field_5854) {
            return class_3417.field_14623;
        }
        if (source == class_1282.field_5859) {
            return class_3417.field_15205;
        }
        if (source == class_1282.field_16992) {
            return class_3417.field_17614;
        }
        return class_3417.field_15115;
    }

    public class_3414 method_6002() {
        return class_3417.field_14904;
    }

    public boolean method_5863() {
        return false;
    }

    public static enum DisplayType {
        GHOST,
        TRANSLUCENT,
        NORMAL;

    }

    public static class Renderer
    extends class_922<ReplayPlayerEntity, Model> {
        private final GoldenBootsFeatureRenderer<ReplayPlayerEntity, Model, class_572<ReplayPlayerEntity>> goldenBootsFeature;
        private boolean slim = false;
        private boolean throughWall = false;

        public Renderer(class_898 dispatcher) {
            super(dispatcher, (class_583)new Model(false), 0.0f);
            this.method_4046((class_3887)new class_989((class_3883)this));
            this.method_4046((class_3887)new class_970<ReplayPlayerEntity, Model, class_572<ReplayPlayerEntity>>((class_3883)this, new class_572(0.5f), new class_572(1.0f)){

                public void method_23192(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_1738 armorItem, boolean bl, class_572<ReplayPlayerEntity> bipedEntityModel, boolean bl2, float f, float g, float h, @Nullable String string) {
                    class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumerProvider, (class_1921)(throughWall ? CustomRenderPhase.getRenderLayerThroughWall(this.method_4174(armorItem, bl2, string), false) : CustomRenderPhase.getRenderLayer(this.method_4174(armorItem, bl2, string), false, null)), (boolean)false, (boolean)bl);
                    bipedEntityModel.method_2828(matrixStack, vertexConsumer, i, class_4608.field_21444, f, g, h, 1.0f);
                }
            });
            this.method_4046((class_3887)new class_976((class_3883)this));
            this.method_4046((class_3887)new class_979((class_3883)this));
            this.goldenBootsFeature = new GoldenBootsFeatureRenderer(this);
        }

        protected void setupTransforms(ReplayPlayerEntity replayPlayerEntity, class_4587 matrixStack, float f, float g, float h) {
            float i = replayPlayerEntity.method_6024(h);
            if (replayPlayerEntity.method_6128()) {
                super.method_4058((class_1309)replayPlayerEntity, matrixStack, f, g, h);
                float j = (float)replayPlayerEntity.method_6003() + h;
                float k = class_3532.method_15363((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
                if (!replayPlayerEntity.method_6123()) {
                    matrixStack.method_22907(class_1160.field_20703.method_23214(k * (-90.0f - replayPlayerEntity.field_5965)));
                }
                class_243 vec3d = replayPlayerEntity.method_5828(h);
                class_243 vec3d2 = replayPlayerEntity.method_18798();
                double d = class_1297.method_17996((class_243)vec3d2);
                double e = class_1297.method_17996((class_243)vec3d);
                if (d > 0.0 && e > 0.0) {
                    double l = (vec3d2.field_1352 * vec3d.field_1352 + vec3d2.field_1350 * vec3d.field_1350) / (Math.sqrt(d) * Math.sqrt(e));
                    double m = vec3d2.field_1352 * vec3d.field_1350 - vec3d2.field_1350 * vec3d.field_1352;
                    matrixStack.method_22907(class_1160.field_20705.method_23626((float)(Math.signum(m) * Math.acos(l))));
                }
            } else if (i > 0.0f) {
                super.method_4058((class_1309)replayPlayerEntity, matrixStack, f, g, h);
                float j = replayPlayerEntity.method_5799() ? -90.0f - replayPlayerEntity.field_5965 : -90.0f;
                float k = class_3532.method_16439((float)i, (float)0.0f, (float)j);
                matrixStack.method_22907(class_1160.field_20703.method_23214(k));
                if (replayPlayerEntity.method_20232()) {
                    matrixStack.method_22904(0.0, -1.0, (double)0.3f);
                }
            } else {
                super.method_4058((class_1309)replayPlayerEntity, matrixStack, f, g, h);
            }
        }

        public class_2960 getTexture(ReplayPlayerEntity entity) {
            if (replayPlayerEntitySkins.containsKey(entity.field_6021)) {
                String uuidString = replayPlayerEntitySkins.get(entity.field_6021).toString();
                class_2960 skin = TextureUtils.getPlayerSkin(uuidString);
                this.slim = TextureUtils.isPlayerSlim(uuidString);
                return skin;
            }
            return class_1068.method_4649();
        }

        @Nullable
        protected class_1921 getRenderLayer(ReplayPlayerEntity entity, boolean showBody, boolean translucent, boolean bl) {
            class_2960 texture = this.getTexture(entity);
            if (this.throughWall) {
                return CustomRenderPhase.getRenderLayerThroughWall(texture, entity.field_6235 > 0);
            }
            return CustomRenderPhase.getRenderLayer(texture, entity.field_6235 > 0, ((Model)this.method_4038()).getDisplayType());
        }

        public void render(ReplayPlayerEntity replayEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
            class_3965 rayTrace;
            replayEntity.isOnRender = true;
            ArrayList featuresBackup = Lists.newArrayList((Iterable)this.field_4738);
            if (((Model)this.method_4038()).getDisplayType() != DisplayType.NORMAL) {
                this.field_4738.clear();
            }
            if (((Model)this.method_4038()).getDisplayType() == DisplayType.GHOST) {
                this.method_4046(this.goldenBootsFeature);
            }
            this.throughWall = false;
            if (replayEntity.isGhostMode()) {
                this.throughWall = true;
            } else if (!replayEntity.method_5767() && class_310.method_1551().field_1719 != null && replayEntity.field_6002 != null && (rayTrace = replayEntity.field_6002.method_17742(new class_3959(class_310.method_1551().field_1773.method_19418().method_19326(), replayEntity.method_19538(), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)replayEntity))).method_17783() != class_239.class_240.field_1333) {
                this.throughWall = true;
            }
            if (((PlayerEntityModelAccessor)this.method_4038()).isThinArms() != this.slim) {
                this.field_4737 = new Model(this.slim);
            }
            ((Model)this.method_4038()).field_3400 = replayEntity.method_5715();
            ((Model)this.method_4038()).field_3449 = replayEntity.method_5765();
            class_1657 player = replayEntity.field_6002.method_18460((class_1297)replayEntity, (double)((Integer)SpeedRunOption.getOption(RankedOptions.GHOST_INVISIBLE_DISTANCE)).intValue());
            if (!replayEntity.isGhostMode()) {
                ((Model)this.method_4038()).setDisplayType(DisplayType.NORMAL);
            } else if (player != null && !player.method_7325()) {
                ((Model)this.method_4038()).setDisplayType(DisplayType.GHOST);
            } else {
                ((Model)this.method_4038()).setDisplayType(DisplayType.TRANSLUCENT);
            }
            replayEntity.displayType = ((Model)this.method_4038()).getDisplayType();
            super.method_4054((class_1309)replayEntity, f, g, matrixStack, vertexConsumerProvider, i);
            if (((Model)this.method_4038()).getDisplayType() == DisplayType.NORMAL && replayEntity.pause) {
                matrixStack.method_22903();
                matrixStack.method_22904(0.0, (double)(-((replayEntity.method_17682() + 0.5f) / 2.0f)) + 0.42, 0.0);
                matrixStack.method_22905(1.5f, 1.5f, 1.5f);
                this.method_3926((class_1297)replayEntity, (class_2561)new class_2585("(\u23f8)").method_27692(class_124.field_1054), matrixStack, vertexConsumerProvider, i);
                matrixStack.method_22909();
            }
            if (((Model)this.method_4038()).getDisplayType() != DisplayType.NORMAL) {
                this.field_4738.clear();
                this.field_4738.addAll(featuresBackup);
            }
            replayEntity.isOnRender = false;
        }

        protected boolean hasLabel(ReplayPlayerEntity livingEntity) {
            return livingEntity.method_5807();
        }
    }

    public static class Model
    extends class_591<ReplayPlayerEntity> {
        private DisplayType displayType = DisplayType.NORMAL;

        public Model(boolean slim) {
            super(0.0f, slim);
        }

        public DisplayType getDisplayType() {
            return this.displayType;
        }

        public void setDisplayType(DisplayType displayType) {
            this.displayType = displayType;
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            float newAlpha = alpha;
            if (alpha == 1.0f && this.getDisplayType() != DisplayType.NORMAL) {
                newAlpha = this.getDisplayType() == DisplayType.GHOST ? 0.0f : ((Float)SpeedRunOption.getOption(RankedOptions.GHOST_OPACITY)).floatValue();
            }
            super.method_2828(matrices, vertices, light, overlay, red, green, blue, newAlpha);
        }
    }
}

