/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.render;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_4050;

public class ReplayPlayerState {
    private WorldTypes worldType;
    private class_243 pos;
    private float pitch;
    private float yaw;
    private class_4050 pose;
    private boolean death;
    private boolean visible;
    private boolean ridingBoat;
    private boolean inanimate;
    private boolean pause;

    public ReplayPlayerState() {
        this(WorldTypes.OVERWORLD, class_243.field_1353, 0.0f, 0.0f, class_4050.field_18076, false, false, false, false, false);
    }

    public ReplayPlayerState(WorldTypes worldType, class_243 pos, float pitch, float yaw, class_4050 pose, boolean death, boolean visible, boolean ridingBoat, boolean inanimate, boolean pause) {
        this.worldType = worldType;
        this.pos = pos;
        this.pitch = pitch;
        this.yaw = yaw;
        this.pose = pose;
        this.death = death;
        this.visible = visible;
        this.ridingBoat = ridingBoat;
        this.inanimate = inanimate;
        this.pause = pause;
    }

    public ReplayPlayerState duplicate() {
        return new ReplayPlayerState(this.worldType, this.pos.method_1031(0.0, 0.0, 0.0), this.pitch, this.yaw, this.pose, this.death, this.visible, this.ridingBoat, false, this.pause);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplayPlayerState)) {
            return false;
        }
        ReplayPlayerState that = (ReplayPlayerState)o;
        return Float.compare(this.pitch, that.pitch) == 0 && Float.compare(this.yaw, that.yaw) == 0 && this.ridingBoat == that.ridingBoat && this.death == that.death && this.visible == that.visible && this.worldType == that.worldType && Objects.equals(this.pos, that.pos) && this.pose == that.pose && this.pause == that.pause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.worldType, this.pos, Float.valueOf(this.pitch), Float.valueOf(this.yaw), this.pose, this.death, this.pause});
    }

    public WorldTypes getWorldType() {
        return this.worldType;
    }

    public void setWorldType(WorldTypes worldType) {
        if (worldType != this.worldType) {
            this.ridingBoat = false;
            this.inanimate = true;
        }
        this.worldType = worldType;
        this.visible = true;
        this.death = false;
    }

    public void setInanimate() {
        this.inanimate = true;
    }

    public class_243 getPos() {
        return this.pos;
    }

    public void setPos(class_243 pos) {
        this.pos = pos;
    }

    public class_4050 getPose() {
        return this.pose;
    }

    public void setPose(class_4050 pose) {
        this.pose = pose;
    }

    public boolean isDeath() {
        return this.death;
    }

    public void setDeath(boolean death) {
        this.ridingBoat = false;
        this.death = death;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.ridingBoat = false;
        this.visible = visible;
    }

    public boolean isRidingBoat() {
        return this.ridingBoat;
    }

    public void setRidingBoat(boolean ridingBoat) {
        this.ridingBoat = ridingBoat;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public void apply(ReplayEntityTracker<ReplayPlayerEntity> entityTracker) {
        if (entityTracker.getSpawnPos() == class_243.field_1353 || entityTracker.isDead() && !this.isDeath()) {
            entityTracker.setSpawnPos(this.getPos().method_10216(), this.getPos().method_10214(), this.getPos().method_10215(), this.getYaw(), this.getPitch());
        }
        entityTracker.setDimension(this.getWorldType());
        entityTracker.setPos(this.getPos().method_10216(), this.getPos().method_10214(), this.getPos().method_10215(), this.getYaw(), this.getPitch());
        entityTracker.setVisible(this.isVisible());
        entityTracker.getTarget().setBoatActivate(this.isRidingBoat(), this.getPos().method_1031(0.0, 0.48, 0.0));
        entityTracker.getTarget().method_18380(this.getPose());
        entityTracker.getTarget().setPause(this.isPause());
        if (this.isDeath()) {
            entityTracker.death();
        }
        if (this.inanimate) {
            entityTracker.inanimateNextTick();
        }
    }
}

