/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.ReplayDragonFight;
import com.mcsrranked.client.anticheat.replay.ReplayEntityManager;
import com.mcsrranked.client.anticheat.replay.render.BlockBreakingStack;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.ReplayPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.TimeLinePackage;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.TimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.Identifier;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchSplitTime;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.vanillafix.RenderTaskQueue;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class OpponentPlayerTracker {
    private final SortedMap<TimeLineType, Pair<DebugPair, DebugPair>> debugTime = new TreeMap<TimeLineType, Pair<DebugPair, DebugPair>>(Comparator.comparing(Enum::ordinal));
    private long systemTime = System.currentTimeMillis();
    private final UUID uuid;
    private final ReplayEntityManager replayEntityManager;
    private final CopyOnWriteArrayList<Integer> worldResetTicks = new CopyOnWriteArrayList();
    public final Map<WorldPosIIdentifier, class_2680> blockStateCache = new HashMap<WorldPosIIdentifier, class_2680>();
    private final Map<Integer, Map<Byte, ArrayList<TimeLine<?>>>> timeLines = new ConcurrentHashMap();
    private final Map<Byte, Map<Identifier, Map<Integer, ArrayList<TimeLine<?>>>>> rollbackTimeLineMap = new ConcurrentHashMap();
    public final Map<WorldPosIIdentifier, UpdateState> updateBlockStateMap = new LinkedHashMap<WorldPosIIdentifier, UpdateState>();
    public final Map<Integer, Map<Byte, class_1799>> playerInventoryCache = new ConcurrentHashMap<Integer, Map<Byte, class_1799>>();
    public final TreeMap<Integer, MatchSplitTime> splitTimeTreeMap = new TreeMap();
    public final Map<Integer, WorldTypes> playerDimensionCache = new LinkedHashMap<Integer, WorldTypes>();
    public final Map<Integer, Boolean> deathTickMap = new ConcurrentHashMap<Integer, Boolean>();
    private final ReplayDragonFight dragonFight;
    private int currentTicks = -1;
    private int lastTickCount = -1;
    private int lastResetTick = 0;
    private boolean active = false;
    private boolean ghostMode = false;
    private boolean followDimension = true;
    private boolean displayNameTag = false;
    private boolean ghostOnly = false;
    private final File cacheFile;
    private boolean cached = false;

    public OpponentPlayerTracker(UUID uuid, String nickname) {
        this.uuid = uuid;
        this.replayEntityManager = new ReplayEntityManager(this, this.uuid, nickname);
        this.dragonFight = new ReplayDragonFight(this);
        this.cacheFile = MCSRRankedClient.REPLAY_CACHE_PATH.resolve(uuid.toString() + ".prd").toFile();
        this.cacheFile.deleteOnExit();
        if (this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
        this.playerDimensionCache.put(0, WorldTypes.OVERWORLD);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getCurrentTicks() {
        return this.currentTicks;
    }

    public int getLastTicks() {
        return this.lastTickCount;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setFollowDimension(boolean followDimension) {
        this.followDimension = followDimension;
    }

    public boolean isFollowDimension() {
        return this.followDimension;
    }

    public boolean shouldDisplayNameTag() {
        return this.displayNameTag;
    }

    public void setDisplayNameTag(boolean displayNameTag) {
        this.displayNameTag = displayNameTag;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        if (this.cached == cached) {
            return;
        }
        this.cached = cached;
        if (this.isCached()) {
            try {
                if (!this.cacheFile.exists()) {
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(this.cacheFile.toPath(), new OpenOption[0])));
                while (reader.ready()) {
                    String line = reader.readLine();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(line));
                    byteBuffer.position(16);
                    Map<Integer, Map<Byte, ArrayList<TimeLine<?>>>> timelines = this.convertTimeLines(byteBuffer);
                    TreeMap timelineInitializer = new TreeMap();
                    for (Map.Entry<Integer, Map<Byte, ArrayList<TimeLine<?>>>> entry : timelines.entrySet()) {
                        this.addTimeLine(entry.getKey(), entry.getValue(), timelineInitializer);
                    }
                    for (Map.Entry<Integer, Map<Byte, ArrayList<TimeLine<Object>>>> entry : timelineInitializer.entrySet()) {
                        this.updateTimelineNoneCache(entry.getKey(), (List)((Object)entry.getValue()));
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.clear();
        }
    }

    public void reset() {
        this.currentTicks = -1;
        this.lastResetTick = 0;
        this.clear();
    }

    public void clear() {
        this.replayEntityManager.clear();
        this.worldResetTicks.clear();
        this.blockStateCache.clear();
        this.timeLines.clear();
        this.rollbackTimeLineMap.clear();
        this.updateBlockStateMap.clear();
        this.playerInventoryCache.clear();
    }

    public void addResetWorldTimeline(int tick) {
        this.worldResetTicks.add(tick);
    }

    public int getLastResetTickFrom(int tick) {
        return this.worldResetTicks.stream().filter(t -> t <= tick).max(Comparator.naturalOrder()).orElse(0);
    }

    public ReplayEntityManager getEntityManager() {
        return this.replayEntityManager;
    }

    public ReplayPlayerTracker getReplayPlayerTracker() {
        return this.getEntityManager().getPlayerTracker();
    }

    public void onUpdateMatchTimeline(MatchTimeline matchTimeline) {
        @Nullable MatchSplit split = MatchSplit.fromTimeline(matchTimeline);
        if (split != null) {
            this.splitTimeTreeMap.put(matchTimeline.getTick(), new MatchSplitTime(split, matchTimeline.getTime()));
        }
        if (matchTimeline.getType().startsWith("projectelo.timeline.death")) {
            this.deathTickMap.put(matchTimeline.getTick(), matchTimeline.getType().equals("projectelo.timeline.death"));
        }
    }

    public MatchSplitTime getMatchSplitData(int tick) {
        Integer key = this.splitTimeTreeMap.floorKey(tick);
        return key == null ? new MatchSplitTime(MatchSplit.STARTED, 0L) : this.splitTimeTreeMap.get(key);
    }

    public boolean updateBlockState(MinecraftServer server, WorldPosIIdentifier identifier, class_2680 state) {
        return this.updateBlockState(server, identifier, state, 3, true);
    }

    public boolean updateBlockState(MinecraftServer server, WorldPosIIdentifier identifier, class_2680 state, boolean update) {
        return this.updateBlockState(server, identifier, state, 3, update);
    }

    public boolean updateBlockState(MinecraftServer server, WorldPosIIdentifier identifier, class_2680 state, int flags, boolean update) {
        class_3218 world = identifier.getWorld().toWorld(server);
        class_2338 blockPos = new class_2338(identifier.getPos());
        this.updateBlockStateMap.remove(identifier);
        if (world.method_22340(new class_2338(identifier.getPos()))) {
            class_2680 blockState;
            class_2680 class_26802 = blockState = state.method_26204() == class_2246.field_10499 ? world.method_8316(blockPos).method_15759() : state;
            if (state.method_26204() == class_2246.field_10316) {
                flags = 0;
            }
            if (update) {
                this.blockStateCache.putIfAbsent(identifier, world.method_8320(blockPos));
            }
            world.method_8652(blockPos, blockState, flags);
            return true;
        }
        this.updateBlockStateMap.put(identifier, new UpdateState(state, flags, update));
        return false;
    }

    public void tickBlockStateUpdate(MinecraftServer server) {
        LinkedHashSet<Map.Entry<WorldPosIIdentifier, UpdateState>> entries = new LinkedHashSet<Map.Entry<WorldPosIIdentifier, UpdateState>>(this.updateBlockStateMap.entrySet());
        for (Map.Entry entry : entries) {
            class_2338 blockPos;
            class_3218 world = ((WorldPosIIdentifier)entry.getKey()).getWorld().toWorld(server);
            if (!world.method_22340(blockPos = new class_2338(((WorldPosIIdentifier)entry.getKey()).getPos()))) continue;
            class_2680 blockState = ((UpdateState)entry.getValue()).blockState.method_26204() == class_2246.field_10499 ? world.method_8316(blockPos).method_15759() : ((UpdateState)entry.getValue()).blockState;
            int flags = ((UpdateState)entry.getValue()).flags;
            if (blockState.method_26204() == class_2246.field_10316) {
                flags = 0;
            }
            this.updateBlockStateMap.remove(entry.getKey());
            if (((UpdateState)entry.getValue()).update) {
                this.blockStateCache.putIfAbsent((WorldPosIIdentifier)entry.getKey(), world.method_8320(blockPos));
            }
            world.method_8652(blockPos, blockState, flags);
        }
    }

    public ReplayDragonFight getDragonFight() {
        return this.dragonFight;
    }

    private void printDebug() {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        for (Map.Entry<TimeLineType, Pair<DebugPair, DebugPair>> debugEntry : this.debugTime.entrySet()) {
            if (((DebugPair)debugEntry.getValue().getFirst()).count > 0) {
                MCSRRankedClient.LOGGER.info("[{} - tick] count: {} | taken: {} | average: {}", (Object)debugEntry.getKey().name(), (Object)((DebugPair)debugEntry.getValue().getFirst()).count, (Object)((DebugPair)debugEntry.getValue().getFirst()).total, (Object)((double)((DebugPair)debugEntry.getValue().getFirst()).total / ((double)((DebugPair)debugEntry.getValue().getFirst()).count * 1.0)));
            }
            if (((DebugPair)debugEntry.getValue().getSecond()).count <= 0) continue;
            MCSRRankedClient.LOGGER.info("[{} - back] count: {} | taken: {} | average: {}", (Object)debugEntry.getKey().name(), (Object)((DebugPair)debugEntry.getValue().getSecond()).count, (Object)((DebugPair)debugEntry.getValue().getSecond()).total, (Object)((double)((DebugPair)debugEntry.getValue().getSecond()).total / ((double)((DebugPair)debugEntry.getValue().getSecond()).count * 1.0)));
        }
        this.debugTime.clear();
    }

    private void captureDebug() {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        this.systemTime = System.currentTimeMillis();
    }

    private void putDebug(TimeLineType type, boolean ticking) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        this.debugTime.putIfAbsent(type, (Pair<DebugPair, DebugPair>)new Pair((Object)new DebugPair(), (Object)new DebugPair()));
        DebugPair pair = ticking ? (DebugPair)((Pair)this.debugTime.get((Object)type)).getFirst() : (DebugPair)((Pair)this.debugTime.get((Object)type)).getSecond();
        ++pair.count;
        pair.total += System.currentTimeMillis() - this.systemTime;
    }

    public void moveToTick(int tick, MinecraftServer server) {
        ((RenderTaskQueue)class_310.method_1551()).ranked$addRenderTask(() -> ((BlockBreakingStack)class_310.method_1551().field_1769).ranked$clearAllBreakingInfo());
        int ct = this.getCurrentTicks();
        this.debugTime.clear();
        class_243 beforePos = this.getReplayPlayerTracker().getEntityTracker().getPos();
        if (ct < tick) {
            for (int i = ct; i < tick; ++i) {
                this.tickTracker(server, false, true);
            }
        } else if (ct > tick) {
            this.rollbackUntilTick(tick - 1, server);
            if (tick > 0) {
                this.tickTracker(server, false, false);
            }
        }
        class_243 afterPos = this.getReplayPlayerTracker().getEntityTracker().getPos();
        this.checkResetRollback(server);
        this.getDragonFight().refresh(tick, server);
        this.getEntityManager().followPlayer(afterPos.method_1022(beforePos) > 200.0);
        this.printDebug();
    }

    private Optional<ArrayList<TimeLine<?>>> findLatestTimeLine(List<Map<Integer, ArrayList<TimeLine<?>>>> timeLines, int tick, int resetOffset) {
        ArrayList timeLineArrayList = new ArrayList();
        for (int i = tick - 1; i >= 0; --i) {
            for (Map<Integer, ArrayList<TimeLine<?>>> timeLineMap : timeLines) {
                if (resetOffset > i || timeLineMap == null || !timeLineMap.containsKey(i)) continue;
                timeLineArrayList.addAll(timeLineMap.get(i));
                return Optional.of(timeLineArrayList);
            }
        }
        return Optional.empty();
    }

    public void rollbackAllActions(MinecraftServer server) {
        this.rollbackUntilTick(0, server);
    }

    public void setGhostMode(boolean ghostMode) {
        this.ghostMode = ghostMode;
        this.getReplayPlayerTracker().getEntityTracker().getTarget().setGhostMode(ghostMode);
    }

    public void enableGhostOnly() {
        this.ghostOnly = true;
    }

    public boolean isGhostOnly() {
        return this.ghostOnly;
    }

    public boolean isGhostMode() {
        return this.ghostMode;
    }

    public void receiveOpponentTimeLine(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer remainingBuffer = byteBuffer.duplicate();
        Map<Integer, Map<Byte, ArrayList<TimeLine<?>>>> timelines = this.convertTimeLines(byteBuffer);
        TreeMap timelineInitializer = new TreeMap();
        if (this.isCached()) {
            for (Map.Entry<Integer, Map<Byte, ArrayList<TimeLine<?>>>> entry : timelines.entrySet()) {
                this.addTimeLine(entry.getKey(), entry.getValue(), timelineInitializer);
            }
        } else {
            for (Map.Entry<Integer, Map<Byte, ArrayList<TimeLine<?>>>> entry : timelines.entrySet()) {
                int tick = entry.getKey();
                timelineInitializer.putIfAbsent(tick, new ArrayList());
                for (ArrayList<TimeLine<?>> value : entry.getValue().values()) {
                    timelineInitializer.get(tick).addAll(value);
                }
                this.lastTickCount = Math.max(tick, this.lastTickCount);
            }
        }
        for (Map.Entry<Integer, Map<Byte, ArrayList<TimeLine<Object>>>> entry : timelineInitializer.entrySet()) {
            this.updateTimelineNoneCache(entry.getKey(), (List)((Object)entry.getValue()));
        }
        FileUtils.writeStringToFile((File)this.cacheFile, (String)(Base64.getEncoder().encodeToString(remainingBuffer.array()) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
    }

    public Map<Integer, Map<Byte, ArrayList<TimeLine<?>>>> convertTimeLines(ByteBuffer buffer) {
        ArrayList<TimeLinePackage> timeLineList = new ArrayList<TimeLinePackage>();
        while (buffer.hasRemaining()) {
            timeLineList.add(TimeLinePackage.fromBytes(this, buffer));
        }
        return timeLineList.stream().collect(Collectors.groupingBy(TimeLinePackage::getTick, Collectors.groupingBy(TimeLinePackage::getType, Collectors.mapping(TimeLinePackage::getTimeLine, Collectors.toCollection(ArrayList::new)))));
    }

    private void addTimeLine(int tick, Map<Byte, ArrayList<TimeLine<?>>> playerTimeLine, TreeMap<Integer, List<TimeLine<?>>> timelineInitializer) {
        this.timeLines.putIfAbsent(tick, new TreeMap(Comparator.comparing(s -> TimeLineType.values()[s].getPriority())));
        timelineInitializer.putIfAbsent(tick, new ArrayList());
        for (Map.Entry<Byte, ArrayList<TimeLine<?>>> entry : playerTimeLine.entrySet()) {
            Byte type = entry.getKey();
            ArrayList<TimeLine<?>> playerTimelines = entry.getValue();
            this.timeLines.get(tick).putIfAbsent(type, new ArrayList());
            this.timeLines.get(tick).get(type).addAll(playerTimelines);
            this.rollbackTimeLineMap.putIfAbsent(type, new HashMap());
            for (TimeLine<?> timeLine : playerTimelines) {
                this.rollbackTimeLineMap.get(type).putIfAbsent((Identifier)timeLine.getIdentifier(), new HashMap());
                this.rollbackTimeLineMap.get(type).get(timeLine.getIdentifier()).putIfAbsent(tick, new ArrayList());
                this.rollbackTimeLineMap.get(type).get(timeLine.getIdentifier()).get(tick).add(timeLine);
                timeLine.onInit(this, tick);
                timelineInitializer.get(tick).add(timeLine);
            }
        }
        this.lastTickCount = Math.max(tick, this.lastTickCount);
    }

    private void updateTimelineNoneCache(int tick, List<TimeLine<?>> timelines) {
        ReplayPlayerState playerState = null;
        for (TimeLine<?> timeLine : timelines) {
            if (timeLine.isPlayerMovementTimeline()) {
                if (playerState == null) {
                    playerState = this.getReplayPlayerTracker().getStateTree(tick);
                }
                timeLine.onPlayerStateUpdate(playerState);
            }
            timeLine.onInit(this, tick);
        }
    }

    public Optional<Map<Byte, ArrayList<TimeLine<?>>>> getTimeLines(int tick) {
        return Optional.ofNullable(this.timeLines.get(tick));
    }

    public void tickTracker(MinecraftServer server, boolean live, boolean silence) {
        this.tickTracker(server, live, silence, 5);
    }

    public void tickTracker(MinecraftServer server, boolean live, boolean silence, int depth) {
        if (this.currentTicks > this.lastTickCount || depth <= 0 || !this.isActive()) {
            return;
        }
        this.checkResetRollback(server);
        if (!this.isGhostMode()) {
            this.getTimeLines(this.currentTicks).ifPresent(integerArrayListMap -> integerArrayListMap.forEach((integer, playerTimeLines) -> playerTimeLines.forEach(timeLine -> {
                this.captureDebug();
                timeLine.runTimeLine(this, server, silence);
                this.putDebug(timeLine.getType(), true);
            })));
            if (!this.getDragonFight().hasInit()) {
                this.getDragonFight().refresh(0, server);
            } else {
                this.getDragonFight().tick(this.currentTicks, server);
            }
        }
        this.getReplayPlayerTracker().tick(this.currentTicks);
        ++this.currentTicks;
        if (live && this.lastTickCount - this.currentTicks >= 200) {
            this.tickTracker(server, true, silence, --depth);
        }
    }

    public void checkResetRollback(MinecraftServer server) {
        if (this.lastResetTick != this.getLastResetTickFrom(this.getCurrentTicks())) {
            ArrayList types = Lists.newArrayList(this.rollbackTimeLineMap.keySet());
            types.sort((s1, s2) -> {
                int priority2;
                int priority1 = TimeLineType.values()[s1].getPriority();
                if (priority1 == (priority2 = TimeLineType.values()[s2].getPriority())) {
                    return s1 - s2;
                }
                return priority1 - priority2;
            });
            int resetOffset = this.getLastResetTickFrom(this.getCurrentTicks());
            for (Byte type : types) {
                Map<Identifier, Map<Integer, ArrayList<TimeLine<?>>>> timelineMap = this.rollbackTimeLineMap.get(type);
                timelineMap.forEach((identifier, integerArrayListMap) -> {
                    this.captureDebug();
                    TimeLineType.values()[type].getTimeLineFactory().defaultExecute(this, server, identifier);
                    this.putDebug(TimeLineType.values()[type], false);
                });
            }
            this.lastResetTick = resetOffset;
        }
    }

    public void rollbackUntilTick(int tick, MinecraftServer server) {
        int resetOffset = this.getLastResetTickFrom(tick);
        if (!this.isGhostMode()) {
            ArrayList types = Lists.newArrayList(this.rollbackTimeLineMap.keySet());
            types.sort((s1, s2) -> {
                int priority2;
                int priority1 = TimeLineType.values()[s1].getPriority();
                if (priority1 == (priority2 = TimeLineType.values()[s2].getPriority())) {
                    return s1 - s2;
                }
                return priority1 - priority2;
            });
            for (Byte type : types) {
                Map<Identifier, Map<Integer, ArrayList<TimeLine<?>>>> timelineMap = this.rollbackTimeLineMap.get(type);
                timelineMap.forEach((identifier, integerArrayListMap) -> {
                    if (tick >= 1) {
                        List<Map<Integer, ArrayList<TimeLine<?>>>> stateModifyingTimeLines = Arrays.stream(TimeLineType.values()[type].getTimeLineFactory().getInvertedTypes()).filter(timeLineType -> this.rollbackTimeLineMap.containsKey((byte)timeLineType.ordinal())).map(timeLineType -> this.rollbackTimeLineMap.get((byte)timeLineType.ordinal()).get(identifier)).collect(Collectors.toList());
                        Optional<ArrayList<TimeLine<?>>> optional = this.findLatestTimeLine(stateModifyingTimeLines, tick, resetOffset);
                        optional.ifPresent(latestTimeLines -> latestTimeLines.forEach(timeLine -> {
                            this.captureDebug();
                            timeLine.runTimeLine(this, server, true);
                            this.putDebug(timeLine.getType(), false);
                        }));
                        if (!optional.isPresent() || optional.get().isEmpty()) {
                            this.captureDebug();
                            TimeLineType.values()[type].getTimeLineFactory().defaultExecute(this, server, identifier);
                            this.putDebug(TimeLineType.values()[type], false);
                        }
                    } else {
                        this.captureDebug();
                        TimeLineType.values()[type].getTimeLineFactory().defaultExecute(this, server, identifier);
                        this.putDebug(TimeLineType.values()[type], false);
                    }
                });
            }
        }
        this.lastResetTick = resetOffset;
        this.currentTicks = tick;
    }

    public static class UpdateState {
        private final class_2680 blockState;
        private final int flags;
        private final boolean update;

        private UpdateState(class_2680 blockState, int flags, boolean update) {
            this.blockState = blockState;
            this.flags = flags;
            this.update = update;
        }
    }

    private static class DebugPair {
        int count = 0;
        long total = 0L;

        private DebugPair() {
        }
    }
}

