/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.tracking.TimeLinePackage;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.TimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player.PlayerRemoveTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.socket.SocketInstance;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.commons.io.FileUtils;
import org.xerial.snappy.Snappy;

public class PersonalPlayerTracker {
    private static final File localFile;
    private int range = 0;
    private long lastUploadTime = 0L;
    private long timeLineIndex = 0L;
    private int currentTicks = 0;
    private boolean stopTracking = false;
    private boolean fastBatch = false;
    private boolean optimized = false;
    private ActiveType activeType = ActiveType.NONE;
    private final CopyOnWriteArrayList<CopyOnWriteArrayList<TimeLinePackage>> batchedTimeLines = new CopyOnWriteArrayList();
    private final AtomicInteger timelineSize = new AtomicInteger();

    public PersonalPlayerTracker() {
        this.reset();
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public void setFastBatch(boolean fastBatch) {
        this.fastBatch = fastBatch;
    }

    public void setActiveType(ActiveType activeType) {
        MCSRRankedClient.setCurrentReplayTracker(activeType != ActiveType.NONE ? this : null);
        this.activeType = activeType;
    }

    public ActiveType getActiveType() {
        return this.activeType;
    }

    public boolean isActive() {
        return (Boolean)this.getActiveType().activeSupplier.get() != false && this.getRange() > 0 && !this.stopTracking;
    }

    public void stopTracking() {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            this.addTimeLine(PlayerRemoveTimeLine.PlayerRemoveTimeLineFactory.INSTANCE.getBuilder().setDeath(false).setWorld(WorldTypes.fromDimension(world.method_8597())).build());
        }
        this.uploadTimeLineBatch(true);
        this.stopTracking = true;
    }

    public void resumeTracking() {
        this.stopTracking = false;
    }

    public void increaseTick() {
        ++this.currentTicks;
    }

    public void tickTracker() {
        if (System.currentTimeMillis() - this.lastUploadTime > (long)(this.fastBatch ? 1000 : 5000) || this.timelineSize.get() >= 40000) {
            this.uploadTimeLineBatch(false);
            this.lastUploadTime = System.currentTimeMillis();
        }
    }

    public synchronized void uploadTimeLineBatch(boolean ignoreActive) {
        if (!ignoreActive && !this.isActive()) {
            return;
        }
        ++this.timeLineIndex;
        CopyOnWriteArrayList<TimeLinePackage> timeLine = this.batchedTimeLines.get((int)((this.timeLineIndex - 1L) % 2L));
        if (timeLine.isEmpty()) {
            timeLine.add(new TimeLinePackage((byte)TimeLineType.EMPTY.ordinal(), TimeLineType.EMPTY.getTimeLineFactory().getBuilder().build(), this.currentTicks));
        }
        this.batchedTimeLines.set((int)((this.timeLineIndex - 1L) % 2L), new CopyOnWriteArrayList());
        this.timelineSize.set(0);
        this.uploadTimeLines(timeLine);
    }

    public void uploadTimeLines(List<TimeLinePackage> timeLine) {
        List buffers = timeLine.stream().map(TimeLinePackage::toBytes).map(buffer -> (ByteBuffer)buffer.rewind()).collect(Collectors.toList());
        ByteBuffer buffer2 = ByteBuffer.allocate(16 + buffers.stream().mapToInt(Buffer::remaining).sum());
        buffer2.putLong(class_310.method_1551().method_1548().method_1677().getId().getMostSignificantBits());
        buffer2.putLong(class_310.method_1551().method_1548().method_1677().getId().getLeastSignificantBits());
        for (ByteBuffer byteBuffer : buffers) {
            buffer2.put(byteBuffer);
        }
        try {
            byte[] replayData = Snappy.compress(buffer2.array());
            MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
                if (MCSRRankedClient.getOnlineMatch().map(OnlineMatch::isGameplayInteractable).orElse(false).booleanValue()) {
                    SocketInstance.getInstance().emit("p$replay", new Object[]{replayData});
                } else {
                    ByteBuffer localBuffer = ByteBuffer.allocate(4 + replayData.length);
                    localBuffer.putInt(replayData.length);
                    localBuffer.put(replayData);
                    try {
                        FileUtils.writeByteArrayToFile((File)localFile, (byte[])localBuffer.array(), (boolean)true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e) {
            MCSRRankedClient.LOGGER.error("Failed to compress replay data", (Throwable)e);
        }
    }

    private void addTimeLine(byte type, TimeLine<?> data) {
        TimeLinePackage timelinePackage = new TimeLinePackage(type, data, this.currentTicks);
        this.timelineSize.addAndGet(timelinePackage.toBytes().array().length);
        if (this.isActive()) {
            this.batchedTimeLines.get((int)(this.timeLineIndex % 2L)).add(timelinePackage);
        }
    }

    public void addTimeLine(TimeLine<?> timeline) {
        if (this.isOptimized()) {
            if (timeline.isPlayerMovementTimeline()) {
                this.addTimeLine((byte)timeline.getType().ordinal(), timeline);
            }
        } else {
            this.addTimeLine((byte)timeline.getType().ordinal(), timeline);
        }
    }

    public void reset() {
        this.stopTracking = false;
        this.lastUploadTime = 0L;
        this.timeLineIndex = 0L;
        this.currentTicks = 0;
        this.batchedTimeLines.add(new CopyOnWriteArrayList());
        this.batchedTimeLines.add(new CopyOnWriteArrayList());
        try {
            FileUtils.writeStringToFile((File)localFile, (String)"", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copySettings(PersonalPlayerTracker oldTracker) {
        this.setRange(oldTracker.getRange());
        this.setActiveType(oldTracker.getActiveType());
        this.setOptimized(oldTracker.isOptimized());
        this.fastBatch = oldTracker.fastBatch;
    }

    public File getLocalFile() {
        return localFile;
    }

    static {
        try {
            localFile = File.createTempFile("temp_", ".rpd");
            localFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ActiveType {
        NONE(() -> false),
        MATCH(() -> !MCSRRankedClient.LOCAL_PLAYER.isSpectator() && MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus() == MatchStatus.RUNNING && !match.shouldBlockBehaviors()).orElse(false) != false),
        RACE(() -> MCSRRankedClient.getCurrentRace().map(race -> race.isRunning() && InGameTimer.getInstance().isStarted() && !InGameTimer.getInstance().isCompleted()).orElse(false));

        private final Supplier<Boolean> activeSupplier;

        private ActiveType(Supplier<Boolean> activeSupplier) {
            this.activeSupplier = activeSupplier;
        }
    }
}

