/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types;

import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.WorldTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.Identifier;
import java.nio.ByteBuffer;
import net.minecraft.class_3532;

public abstract class RotationTimeLine<T extends Identifier>
extends WorldTimeLine<T> {
    private final short yaw;
    private final short pitch;

    public RotationTimeLine(TimeLineType type, WorldTypes world, short yaw, short pitch) {
        super(type, world);
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public RotationTimeLine(TimeLineType type, WorldTypes world, float yaw, float pitch) {
        this(type, world, RotationTimeLine.convertRotation(yaw), RotationTimeLine.convertRotation(pitch));
    }

    public static short convertRotation(float value) {
        return (short)(class_3532.method_15393((float)value) / 0.01f);
    }

    public static float convertValue(short rotation) {
        return class_3532.method_15393((float)((float)rotation * 0.01f));
    }

    public float getYaw() {
        return RotationTimeLine.convertValue(this.yaw);
    }

    public float getPitch() {
        return RotationTimeLine.convertValue(this.pitch);
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.capacity() + 4).put(superBuffer).putShort(this.yaw).putShort(this.pitch);
    }
}

