/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BlockBreakTimeLine
extends PositionITimeLine<WorldPosIIdentifier> {
    protected BlockBreakTimeLine(WorldTypes world, long position) {
        super(TimeLineType.BLOCK_BREAK, world, position);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_3218 serverWorld = this.getWorld().toWorld(server);
        if (serverWorld.method_22340(this.getBlockPos())) {
            tracker.blockStateCache.putIfAbsent(this.getIdentifier(), serverWorld.method_8320(this.getBlockPos()));
            ReplayEntityTracker<ReplayPlayerEntity> playerTracker = tracker.getReplayPlayerTracker().getEntityTracker();
            if (!silence && playerTracker.isVisible()) {
                serverWorld.method_22352(this.getBlockPos(), false);
                playerTracker.getTarget().method_6104(playerTracker.getTarget().method_6058());
                for (class_3222 serverPlayerEntity : this.getWorld().toWorld(server).method_18456()) {
                    serverPlayerEntity.field_13987.method_14364((class_2596)new class_2620(serverPlayerEntity.method_5628(), this.getBlockPos(), -1));
                }
            } else {
                serverWorld.method_8650(this.getBlockPos(), false);
            }
        } else {
            tracker.updateBlockState(server, this.getIdentifier(), class_2246.field_10499.method_9564());
        }
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class BlockBreakTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;

        public BlockBreakTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public BlockBreakTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public BlockBreakTimeLine build() {
            return new BlockBreakTimeLine(this.world, this.position);
        }
    }

    public static class BlockBreakTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final BlockBreakTimeLineFactory INSTANCE = new BlockBreakTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_UPDATE_V1, TimeLineType.BLOCK_UPDATE_V2, TimeLineType.BLOCK_BREAK, TimeLineType.BLOCK_REMOVE};
        }

        @Override
        public BlockBreakTimeLineBuilder getBuilder() {
            return new BlockBreakTimeLineBuilder();
        }

        public BlockBreakTimeLine getFromBytes(ByteBuffer buffer) {
            return new BlockBreakTimeLine(WorldTypes.values()[buffer.get()], buffer.getLong());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
            if (tracker.blockStateCache.containsKey(param)) {
                tracker.updateBlockState(server, param, tracker.blockStateCache.get(param), false);
            }
        }
    }
}

