/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_4770;
import net.minecraft.class_4969;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class BlockUpdateTimeLineV1
extends PositionITimeLine<WorldPosIIdentifier> {
    private final int rawBlock;
    private final class_2680 block;
    private final EventType eventType;
    private final byte stateValue;
    private final byte dataValue;

    protected BlockUpdateTimeLineV1(WorldTypes world, long position, int block, byte eventData) {
        super(TimeLineType.BLOCK_UPDATE_V1, world, position);
        this.rawBlock = block;
        this.block = class_2248.method_9531((int)block);
        this.eventType = EventType.values()[eventData % 2];
        this.stateValue = (byte)(eventData / 2);
        this.dataValue = eventData;
    }

    public class_2680 getBlock() {
        return this.block;
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_3218 world = this.getWorld().toWorld(server);
        class_2680 blockState = Optional.ofNullable(BlockUpdateTimeLineV1.getUpdateType(this.getEventType(), this.getBlock(), null, null)).map(updateEvent -> ((UpdateEvent)updateEvent).setter.update(this.getStateValue(), this.getBlock())).orElse(this.getBlock());
        boolean result = tracker.updateBlockState(server, this.getIdentifier(), blockState);
        if (result) {
            ReplayEntityTracker<ReplayPlayerEntity> playerTracker = tracker.getReplayPlayerTracker().getEntityTracker();
            if (!silence && playerTracker.isVisible()) {
                if (this.getEventType() == EventType.PLACE) {
                    playerTracker.getTarget().method_6104(playerTracker.getTarget().method_6058());
                    class_2498 blockSoundGroup = blockState.method_26231();
                    world.method_8396(null, this.getBlockPos(), blockState.method_26231().method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
                }
                for (class_3222 serverPlayerEntity : world.method_18456()) {
                    serverPlayerEntity.field_13987.method_14364((class_2596)new class_2620(serverPlayerEntity.method_5628(), this.getBlockPos(), -1));
                }
            }
        }
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 5).put(superBuffer).putInt(this.rawBlock).put(this.getDataValue());
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public byte getStateValue() {
        return this.stateValue;
    }

    public byte getDataValue() {
        return this.dataValue;
    }

    @Deprecated
    public static UpdateEvent getUpdateType(EventType eventType, class_2680 state, @Nullable class_2338 blockPos, @Nullable class_1309 entity) {
        Supplier<Boolean> shouldUpdate = () -> entity == null && blockPos == null || entity != null && blockPos != null && entity.method_24515().method_19771((class_2382)blockPos, 32.0);
        if (state.method_26204() == class_2246.field_10124 && eventType == EventType.UPDATE) {
            return UpdateEvent.AIR;
        }
        if (state.method_26204() instanceof class_4770 && eventType == EventType.UPDATE) {
            return UpdateEvent.FIRE;
        }
        if (state.method_26204() == class_2246.field_10027 && eventType == EventType.UPDATE) {
            return UpdateEvent.END_PORTAL;
        }
        if (state.method_26204() == class_2246.field_10398 && eventType == EventType.UPDATE) {
            return UpdateEvent.END_PORTAL_FRAME;
        }
        if (state.method_26204() == class_2246.field_23152 && eventType == EventType.UPDATE) {
            return UpdateEvent.RESPAWN_ANCHOR_UPDATE;
        }
        if (state.method_26204() instanceof class_2244) {
            return UpdateEvent.BED_UPDATE;
        }
        if (state.method_26204() instanceof class_2323 && shouldUpdate.get().booleanValue()) {
            return UpdateEvent.DOOR_UPDATE;
        }
        if (state.method_26204() instanceof class_2404 && eventType == EventType.PLACE) {
            return UpdateEvent.FLUID;
        }
        if (state.method_26204() == class_2246.field_10540 && eventType == EventType.PLACE) {
            return UpdateEvent.OBSIDIAN;
        }
        if (state.method_26204() == class_2246.field_10540 && eventType == EventType.UPDATE && shouldUpdate.get().booleanValue()) {
            return UpdateEvent.OBSIDIAN;
        }
        return null;
    }

    @Deprecated
    public static enum EventType {
        PLACE,
        UPDATE;

    }

    @Deprecated
    public static enum UpdateEvent {
        FIRE(state -> (byte)0, (value, state) -> state.method_26204() == class_2246.field_10316 ? state : class_2246.field_10036.method_9564()),
        BED_UPDATE(state -> (byte)(((class_2742)state.method_11654((class_2769)class_2244.field_9967)).ordinal() + ((class_2350)state.method_11654((class_2769)class_2244.field_11177)).method_10161() * 2), (value, state) -> (class_2680)((class_2680)class_2246.field_10120.method_9564().method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.values()[value % 2])).method_11657((class_2769)class_2244.field_11177, (Comparable)class_2350.method_10139((int)(value / 2)))),
        DOOR_UPDATE(state -> (byte)(((class_2350)state.method_11654((class_2769)class_2323.field_10938)).method_10161() + ((class_2750)state.method_11654((class_2769)class_2323.field_10941)).ordinal() * 4 + ((class_2756)state.method_11654((class_2769)class_2323.field_10946)).ordinal() * 8 + ((Boolean)state.method_11654((class_2769)class_2323.field_10945) != false ? 0 : 16)), (value, state) -> {
            int intValue = value.byteValue();
            class_2680 result = state == null ? class_2246.field_10149.method_9564() : state;
            result = (class_2680)result.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(intValue >= 16));
            if (intValue >= 16) {
                intValue -= 16;
            }
            result = (class_2680)result.method_11657((class_2769)class_2323.field_10946, (Comparable)(intValue >= 8 ? class_2756.field_12607 : class_2756.field_12609));
            if (intValue >= 8) {
                intValue -= 8;
            }
            result = (class_2680)result.method_11657((class_2769)class_2323.field_10941, (Comparable)(intValue >= 4 ? class_2750.field_12586 : class_2750.field_12588));
            if (intValue >= 4) {
                intValue -= 4;
            }
            return (class_2680)result.method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.method_10139((int)intValue));
        }),
        END_PORTAL_FRAME(state -> (byte)((Boolean)state.method_11654((class_2769)class_2333.field_10958) != false ? 1 : 0), (value, state) -> (class_2680)class_2246.field_10398.method_9564().method_11657((class_2769)class_2333.field_10958, (Comparable)Boolean.valueOf(value != 0))),
        END_PORTAL(state -> (byte)0, (value, state) -> class_2246.field_10027.method_9564()),
        RESPAWN_ANCHOR_UPDATE(state -> ((Integer)state.method_11654((class_2769)class_4969.field_23153)).byteValue(), (value, state) -> (class_2680)class_2246.field_23152.method_9564().method_11657((class_2769)class_4969.field_23153, (Comparable)Integer.valueOf(value.intValue()))),
        AIR(state -> (byte)0, (value, state) -> class_2246.field_10124.method_9564()),
        OBSIDIAN(state -> (byte)0, (value, state) -> class_2246.field_10540.method_9564()),
        FLUID(state -> (byte)(state.method_26204() != class_2246.field_10382 ? 1 : 0), (value, state) -> value == 0 ? class_3612.field_15910.method_15785().method_15759() : class_3612.field_15908.method_15785().method_15759());

        private final Function<class_2680, Byte> getter;
        private final StateUpdater setter;

        private UpdateEvent(Function<class_2680, Byte> getter, StateUpdater setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public byte getByte(EventType eventType, class_2680 blockState) {
            return (byte)(this.getter.apply(blockState) * 2 + eventType.ordinal());
        }

        private static interface StateUpdater {
            public class_2680 update(Byte var1, class_2680 var2);
        }
    }

    @Deprecated
    public static class BlockUpdateTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;
        private int block;
        private byte dataValue;

        public BlockUpdateTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public BlockUpdateTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public BlockUpdateTimeLineBuilder setBlock(class_2680 block) {
            this.block = class_2248.method_9507((class_2680)block);
            return this;
        }

        public BlockUpdateTimeLineBuilder setDataValue(byte dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        public BlockUpdateTimeLineV1 build() {
            return new BlockUpdateTimeLineV1(this.world, this.position, this.block, this.dataValue);
        }
    }

    @Deprecated
    public static class BlockUpdateTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final BlockUpdateTimeLineFactory INSTANCE = new BlockUpdateTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_BREAK, TimeLineType.BLOCK_UPDATE_V1, TimeLineType.BLOCK_UPDATE_V2, TimeLineType.BLOCK_REMOVE};
        }

        @Override
        public BlockUpdateTimeLineBuilder getBuilder() {
            return new BlockUpdateTimeLineBuilder();
        }

        public BlockUpdateTimeLineV1 getFromBytes(ByteBuffer buffer) {
            return new BlockUpdateTimeLineV1(WorldTypes.values()[buffer.get()], buffer.getLong(), buffer.getInt(), buffer.get());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
            if (tracker.blockStateCache.containsKey(param)) {
                tracker.updateBlockState(server, param, tracker.blockStateCache.get(param), false);
            }
        }
    }
}

