/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4770;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BlockUpdateTimeLineV2
extends PositionITimeLine<WorldPosIIdentifier> {
    private final int rawBlock;
    private final class_2680 block;
    private final EventType eventType;

    protected BlockUpdateTimeLineV2(WorldTypes world, long position, int block, byte placed) {
        super(TimeLineType.BLOCK_UPDATE_V2, world, position);
        this.rawBlock = block;
        this.block = class_2248.method_9531((int)block);
        this.eventType = EventType.values()[placed];
    }

    public class_2680 getBlock() {
        return this.block;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_3218 world = this.getWorld().toWorld(server);
        class_2680 blockState = this.getBlock();
        boolean result = tracker.updateBlockState(server, this.getIdentifier(), blockState);
        if (result) {
            ReplayEntityTracker<ReplayPlayerEntity> playerTracker = tracker.getReplayPlayerTracker().getEntityTracker();
            if (!silence && playerTracker.isVisible()) {
                if (this.getEventType() == EventType.PLACE) {
                    playerTracker.getTarget().method_6104(playerTracker.getTarget().method_6058());
                    class_2498 blockSoundGroup = blockState.method_26231();
                    world.method_8396(null, this.getBlockPos(), blockState.method_26231().method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
                }
                for (class_3222 serverPlayerEntity : world.method_18456()) {
                    serverPlayerEntity.field_13987.method_14364((class_2596)new class_2620(serverPlayerEntity.method_5628(), this.getBlockPos(), -1));
                }
            }
        }
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 5).put(superBuffer).putInt(this.rawBlock).put((byte)this.getEventType().ordinal());
    }

    public static UpdateEvent getUpdateType(EventType eventType, class_2680 state, @Nullable class_2338 blockPos, @Nullable class_1309 entity) {
        Supplier<Boolean> shouldUpdate = () -> entity == null && blockPos == null || entity != null && blockPos != null && entity.method_24515().method_19771((class_2382)blockPos, 32.0);
        if (state.method_26204() == class_2246.field_10124 && eventType == EventType.UPDATE) {
            return UpdateEvent.AIR;
        }
        if (state.method_26204() instanceof class_4770 && eventType == EventType.UPDATE) {
            return UpdateEvent.FIRE;
        }
        if (state.method_26204() == class_2246.field_10027 && eventType == EventType.UPDATE) {
            return UpdateEvent.END_PORTAL;
        }
        if (state.method_26204() == class_2246.field_10398 && eventType == EventType.UPDATE) {
            return UpdateEvent.END_PORTAL_FRAME;
        }
        if (state.method_26204() == class_2246.field_23152 && eventType == EventType.UPDATE) {
            return UpdateEvent.RESPAWN_ANCHOR_UPDATE;
        }
        if (state.method_26204() instanceof class_2244) {
            return UpdateEvent.BED_UPDATE;
        }
        if (state.method_26204() instanceof class_2323 && shouldUpdate.get().booleanValue()) {
            return UpdateEvent.DOOR_UPDATE;
        }
        if (state.method_26204() instanceof class_2404 && eventType == EventType.PLACE) {
            return UpdateEvent.FLUID;
        }
        if (state.method_26204() == class_2246.field_10540 && eventType == EventType.PLACE) {
            return UpdateEvent.OBSIDIAN;
        }
        if (state.method_26204() == class_2246.field_10540 && eventType == EventType.UPDATE && shouldUpdate.get().booleanValue()) {
            return UpdateEvent.OBSIDIAN;
        }
        return null;
    }

    public static enum EventType {
        PLACE,
        UPDATE;

    }

    public static enum UpdateEvent {
        FIRE,
        BED_UPDATE,
        DOOR_UPDATE,
        END_PORTAL_FRAME,
        END_PORTAL,
        RESPAWN_ANCHOR_UPDATE,
        AIR,
        OBSIDIAN,
        FLUID;

    }

    public static class BlockUpdateTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;
        private int block;
        private byte placed;

        public BlockUpdateTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public BlockUpdateTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public BlockUpdateTimeLineBuilder setBlock(class_2680 block) {
            this.block = class_2248.method_9507((class_2680)block);
            return this;
        }

        public BlockUpdateTimeLineBuilder setPlaced(EventType eventType) {
            this.placed = (byte)eventType.ordinal();
            return this;
        }

        public BlockUpdateTimeLineV2 build() {
            return new BlockUpdateTimeLineV2(this.world, this.position, this.block, this.placed);
        }
    }

    public static class BlockUpdateTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final BlockUpdateTimeLineFactory INSTANCE = new BlockUpdateTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_BREAK, TimeLineType.BLOCK_UPDATE_V1, TimeLineType.BLOCK_UPDATE_V2, TimeLineType.BLOCK_REMOVE};
        }

        @Override
        public BlockUpdateTimeLineBuilder getBuilder() {
            return new BlockUpdateTimeLineBuilder();
        }

        public BlockUpdateTimeLineV2 getFromBytes(ByteBuffer buffer) {
            return new BlockUpdateTimeLineV2(WorldTypes.values()[buffer.get()], buffer.getLong(), buffer.getInt(), buffer.get());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
            if (tracker.blockStateCache.containsKey(param)) {
                tracker.updateBlockState(server, param, tracker.blockStateCache.get(param), false);
            }
        }
    }
}

