/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.dragon;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.TimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.CustomIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.server.MinecraftServer;

public class DragonHealthTimeLine
extends TimeLine<CustomIdentifier> {
    private static final byte BYTE = 0;
    private final int health;

    protected DragonHealthTimeLine(int health) {
        super(TimeLineType.DRAGON_HEALTH_UPDATE);
        this.health = health;
    }

    public int getHealth() {
        return this.health;
    }

    @Override
    public ByteBuffer toBytes() {
        return ByteBuffer.allocate(1).put((byte)(this.getHealth() - 128));
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public CustomIdentifier getIdentifier() {
        return new CustomIdentifier(0);
    }

    @Override
    public void onInit(OpponentPlayerTracker tracker, int tick) {
        tracker.getDragonFight().onUpdateHealth(tick, this.getHealth());
    }

    public static class DragonHealthTimeLineBuilder
    implements TimeLineBuilder {
        private int health;

        public DragonHealthTimeLineBuilder setHealth(int health) {
            this.health = health;
            return this;
        }

        public DragonHealthTimeLine build() {
            return new DragonHealthTimeLine(this.health);
        }
    }

    public static class DragonHealthTimeLineFactory
    implements TimeLineFactorySingleton<CustomIdentifier> {
        public static final DragonHealthTimeLineFactory INSTANCE = new DragonHealthTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[0];
        }

        @Override
        public DragonHealthTimeLineBuilder getBuilder() {
            return new DragonHealthTimeLineBuilder();
        }

        public DragonHealthTimeLine getFromBytes(ByteBuffer buffer) {
            return new DragonHealthTimeLine(buffer.get() + 128);
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, CustomIdentifier param) {
        }
    }
}

