/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.dragon;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.RotationTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.TimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.CustomIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.server.MinecraftServer;

public class DragonPositionTimeLine
extends TimeLine<CustomIdentifier> {
    private static final byte BYTE = 2;
    private final class_1160 position;
    private final short yaw;
    private final short pitch;

    protected DragonPositionTimeLine(class_1160 position, short yaw, short pitch) {
        super(TimeLineType.DRAGON_MOVE);
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    protected DragonPositionTimeLine(class_1160 position, float yaw, float pitch) {
        this(position, RotationTimeLine.convertRotation(yaw), RotationTimeLine.convertRotation(pitch));
    }

    public class_1160 getPosition() {
        return this.position;
    }

    public float getPitch() {
        return RotationTimeLine.convertValue(this.pitch);
    }

    public float getYaw() {
        return RotationTimeLine.convertValue(this.yaw);
    }

    @Override
    public ByteBuffer toBytes() {
        return ByteBuffer.allocate(16).putFloat(this.getPosition().method_4943()).putFloat(this.getPosition().method_4945()).putFloat(this.getPosition().method_4947()).putShort(this.yaw).putShort(this.pitch);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        if (!tracker.getDragonFight().hasInit()) {
            tracker.getDragonFight().refresh(tracker.getCurrentTicks(), server);
        }
        tracker.getDragonFight().getDragon().ifPresent(enderDragonEntity -> enderDragonEntity.method_5808((double)this.getPosition().method_4943(), (double)this.getPosition().method_4945(), (double)this.getPosition().method_4947(), this.getYaw(), this.getPitch()));
    }

    @Override
    public CustomIdentifier getIdentifier() {
        return new CustomIdentifier(2);
    }

    public static class DragonPositionTimeLineBuilder
    implements TimeLineBuilder {
        private class_1160 position;
        private float yaw;
        private float pitch;

        public DragonPositionTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public DragonPositionTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public DragonPositionTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public DragonPositionTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public DragonPositionTimeLine build() {
            return new DragonPositionTimeLine(this.position, this.yaw, this.pitch);
        }
    }

    public static class DragonPositionTimeLineFactory
    implements TimeLineFactorySingleton<CustomIdentifier> {
        public static final DragonPositionTimeLineFactory INSTANCE = new DragonPositionTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[0];
        }

        @Override
        public DragonPositionTimeLineBuilder getBuilder() {
            return new DragonPositionTimeLineBuilder();
        }

        public DragonPositionTimeLine getFromBytes(ByteBuffer buffer) {
            return new DragonPositionTimeLine(new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, CustomIdentifier param) {
        }
    }
}

