/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity.EntityTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldUUIDIdentifier;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1541;
import net.minecraft.class_1621;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EntityAddTimeLine
extends EntityTimeLine<WorldUUIDIdentifier> {
    private final int entityTypeId;
    private final int customData;

    protected EntityAddTimeLine(WorldTypes world, class_1160 position, short yaw, short pitch, int entityId, int entityTypeId, int customData) {
        super(TimeLineType.ENTITY_ADD, world, position, yaw, pitch, entityId);
        this.entityTypeId = entityTypeId;
        this.customData = customData;
    }

    protected EntityAddTimeLine(WorldTypes world, class_1160 position, float yaw, float pitch, int entityId, int entityTypeId, int customData) {
        super(TimeLineType.ENTITY_ADD, world, position, yaw, pitch, entityId);
        this.entityTypeId = entityTypeId;
        this.customData = customData;
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        EntityAddTimeLine.createEntity(tracker, this.getEntityTypeId(), this.getWorld().toWorld(server), this.getEntityUUID(), this.getPosition(), this.getYaw(), this.getPitch(), this.getCustomData(), this.getEntityId(), silence);
    }

    private static void createEntity(OpponentPlayerTracker tracker, int type, class_3218 world, UUID uuid, class_243 pos, float yaw, float pitch, int customData, @Nullable Integer entityId, boolean silence) {
        try {
            class_1297 entity = ((class_1299)class_2378.field_11145.method_10200(type)).method_5883((class_1937)world);
            if (entity != null) {
                if (entity instanceof class_1621) {
                    ((class_1621)entity).method_7161(customData, false);
                } else if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    if (entity instanceof class_1308) {
                        ((class_1308)entity).method_7217(customData < 0);
                    }
                    if (customData != Integer.MIN_VALUE) {
                        livingEntity.method_6122(livingEntity.method_6058(), new class_1799((class_1935)class_1792.method_7875((int)Math.abs(customData))));
                    }
                } else if (entity instanceof class_1541) {
                    if (silence) {
                        return;
                    }
                    entity = new class_1541((class_1937)world, pos.field_1352, pos.field_1351, pos.field_1350, null);
                }
                entity.method_5826(uuid);
                if (entity instanceof class_1510 && entityId != null) {
                    class_1508[] parts = ((class_1510)entity).method_5690();
                    for (int i = 0; i < parts.length; ++i) {
                        parts[i].method_5826(EntityAddTimeLine.getEntityUUIDById(entityId + i));
                    }
                }
                ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().spawnEntity(world, entity, pos, yaw, pitch);
                if (entity instanceof class_1541) {
                    entityTracker.disableFollowPos();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public WorldUUIDIdentifier getIdentifier() {
        return new WorldUUIDIdentifier(this.getWorld(), this.getEntityUUID());
    }

    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    public int getCustomData() {
        return this.customData;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 8).put(superBuffer).putInt(this.entityTypeId).putInt(this.customData);
    }

    public static class EntityAddTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float yaw;
        private float pitch;
        private int entityId;
        private int entityTypeId;
        private int customData;

        public EntityAddTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public EntityAddTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public EntityAddTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public EntityAddTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public EntityAddTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public EntityAddTimeLineBuilder setEntityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityAddTimeLineBuilder setData(class_1297 entity) {
            if (entity instanceof class_1621) {
                this.customData = ((class_1621)entity).method_7152();
            } else if (entity instanceof class_1309) {
                this.customData = class_1792.method_7880((class_1792)((class_1309)entity).method_6047().method_7909());
                if (((class_1309)entity).method_6109()) {
                    this.customData = this.customData == 0 ? Integer.MIN_VALUE : -this.customData;
                }
            } else if (entity instanceof class_1541) {
                this.customData = ((class_1541)entity).method_6969();
            }
            this.entityTypeId = class_2378.field_11145.method_10249((Object)entity.method_5864());
            return this;
        }

        public EntityAddTimeLine build() {
            return new EntityAddTimeLine(this.world, this.position, this.yaw, this.pitch, this.entityId, this.entityTypeId, this.customData);
        }
    }

    public static class EntityAddTimeLineFactory
    implements TimeLineFactorySingleton<WorldUUIDIdentifier> {
        public static final EntityAddTimeLineFactory INSTANCE = new EntityAddTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.ENTITY_ADD, TimeLineType.ENTITY_REMOVE};
        }

        @Override
        public EntityAddTimeLineBuilder getBuilder() {
            return new EntityAddTimeLineBuilder();
        }

        public EntityAddTimeLine getFromBytes(ByteBuffer buffer) {
            return new EntityAddTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort(), buffer.getInt(), buffer.getInt(), buffer.getInt());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldUUIDIdentifier param) {
            ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().getEntityTracker(param.getUUID());
            if (entityTracker != null) {
                entityTracker.setVisible(false);
            }
        }
    }
}

