/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity.EntityTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldUUIDIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.server.MinecraftServer;

public class EntityMoveTimeLine
extends EntityTimeLine<WorldUUIDIdentifier> {
    protected EntityMoveTimeLine(WorldTypes world, class_1160 position, short yaw, short pitch, int entityId) {
        super(TimeLineType.ENTITY_MOVE, world, position, yaw, pitch, entityId);
    }

    protected EntityMoveTimeLine(WorldTypes world, class_1160 position, float yaw, float pitch, int entityId) {
        super(TimeLineType.ENTITY_MOVE, world, position, yaw, pitch, entityId);
    }

    @Override
    public WorldUUIDIdentifier getIdentifier() {
        return new WorldUUIDIdentifier(this.getWorld(), this.getEntityUUID());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        tracker.getEntityManager().moveEntity(this.getWorld().toWorld(server), this.getEntityUUID(), this.getPosition(), this.getYaw(), this.getPitch());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class EntityMoveTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float yaw;
        private float pitch;
        private int entityId;

        public EntityMoveTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public EntityMoveTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public EntityMoveTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public EntityMoveTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public EntityMoveTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public EntityMoveTimeLineBuilder setEntityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityMoveTimeLine build() {
            return new EntityMoveTimeLine(this.world, this.position, this.yaw, this.pitch, this.entityId);
        }
    }

    public static class EntityMoveTimeLineFactory
    implements TimeLineFactorySingleton<WorldUUIDIdentifier> {
        public static final EntityMoveTimeLineFactory INSTANCE = new EntityMoveTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.ENTITY_MOVE};
        }

        @Override
        public EntityMoveTimeLineBuilder getBuilder() {
            return new EntityMoveTimeLineBuilder();
        }

        public EntityMoveTimeLine getFromBytes(ByteBuffer buffer) {
            return new EntityMoveTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort(), buffer.getInt());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldUUIDIdentifier param) {
            tracker.getEntityManager().moveEntity(param.getWorld().toWorld(server), param.getUUID());
        }
    }
}

