/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item.ItemTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.PlayerSlotIdentifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.server.MinecraftServer;

public class ItemEquipTimeLine
extends ItemTimeLine<PlayerSlotIdentifier> {
    private final byte slot;
    private final boolean enchanted;

    protected ItemEquipTimeLine(class_1792 item, byte slot, boolean enchanted) {
        super(TimeLineType.ITEM_EQUIP, item);
        this.slot = slot;
        this.enchanted = enchanted;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.slot + "," + (this.enchanted ? "1" : "0");
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_1799 stack = new class_1799((class_1935)this.getItem());
        if (this.isEnchanted()) {
            stack.method_7978(class_1893.field_9111, 1);
        }
        class_1304 equipSlot = class_1304.values()[this.getSlot()];
        tracker.getReplayPlayerTracker().getEntityTracker().getTarget().method_5673(equipSlot, stack);
    }

    @Override
    public void onInit(OpponentPlayerTracker tracker, int tick) {
        class_1799 stack = new class_1799((class_1935)this.getItem());
        if (this.isEnchanted()) {
            stack.method_7978(class_1893.field_9111, 1);
        }
        tracker.playerInventoryCache.putIfAbsent(tick, new HashMap());
        tracker.playerInventoryCache.get(tick).put(this.slot, stack);
    }

    @Override
    public PlayerSlotIdentifier getIdentifier() {
        return new PlayerSlotIdentifier(this.slot);
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(2 + superBuffer.remaining()).put(superBuffer).put(this.slot).put((byte)(this.enchanted ? 1 : 0));
    }

    public static class ItemEquipTimeLineBuilder
    implements TimeLineBuilder {
        private class_1792 item;
        private byte slot;
        private boolean enchanted;

        public ItemEquipTimeLineBuilder setItem(class_1792 item) {
            this.item = item;
            return this;
        }

        public ItemEquipTimeLineBuilder setSlot(byte slot) {
            this.slot = slot;
            return this;
        }

        public ItemEquipTimeLineBuilder setEnchanted(boolean enchanted) {
            this.enchanted = enchanted;
            return this;
        }

        public ItemEquipTimeLine build() {
            return new ItemEquipTimeLine(this.item, this.slot, this.enchanted);
        }
    }

    public static class ItemEquipTimeLineFactory
    implements TimeLineFactorySingleton<PlayerSlotIdentifier> {
        public static final ItemEquipTimeLineFactory INSTANCE = new ItemEquipTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.ITEM_EQUIP};
        }

        @Override
        public ItemEquipTimeLineBuilder getBuilder() {
            return new ItemEquipTimeLineBuilder();
        }

        public ItemEquipTimeLine getFromBytes(ByteBuffer buffer) {
            return new ItemEquipTimeLine(class_1792.method_7875((int)buffer.getInt()), buffer.get(), buffer.get() == 1);
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, PlayerSlotIdentifier param) {
            tracker.getReplayPlayerTracker().getEntityTracker().getTarget().method_5673(class_1304.values()[param.getSlot()], new class_1799((class_1935)class_1802.field_8162));
        }
    }
}

