/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionFRotationTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.server.MinecraftServer;

public class PlayerPositionTimeLine
extends PositionFRotationTimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();

    protected PlayerPositionTimeLine(WorldTypes world, class_1160 position, short yaw, short pitch) {
        super(TimeLineType.PLAYER_POSITION, world, position, yaw, pitch);
    }

    protected PlayerPositionTimeLine(WorldTypes world, class_1160 position, float yaw, float pitch) {
        super(TimeLineType.PLAYER_POSITION, world, position, yaw, pitch);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    @Override
    public boolean isPlayerMovementTimeline() {
        return true;
    }

    @Override
    public void onPlayerStateUpdate(ReplayPlayerState state) {
        state.setWorldType(this.getWorld());
        state.setPos(this.getPosition());
        state.setPitch(this.getPitch());
        state.setYaw(this.getYaw());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class PlayerPositionTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world = WorldTypes.OVERWORLD;
        private class_1160 position = new class_1160(0.0f, 0.0f, 0.0f);
        private float yaw = 0.0f;
        private float pitch = 0.0f;

        public PlayerPositionTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public PlayerPositionTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public PlayerPositionTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public PlayerPositionTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public PlayerPositionTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public PlayerPositionTimeLine build() {
            return new PlayerPositionTimeLine(this.world, this.position, this.yaw, this.pitch);
        }
    }

    public static class PlayerPositionTimeLineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final PlayerPositionTimeLineFactory INSTANCE = new PlayerPositionTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PLAYER_POSITION};
        }

        @Override
        public PlayerPositionTimeLineBuilder getBuilder() {
            return new PlayerPositionTimeLineBuilder();
        }

        public PlayerPositionTimeLine getFromBytes(ByteBuffer buffer) {
            return new PlayerPositionTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

