/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.TimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.server.MinecraftServer;

public class PlayerRideTimeLine
extends TimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();
    private final boolean riding;

    public boolean isRiding() {
        return this.riding;
    }

    protected PlayerRideTimeLine(boolean riding) {
        super(TimeLineType.PLAYER_RIDE);
        this.riding = riding;
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public boolean isPlayerMovementTimeline() {
        return true;
    }

    @Override
    public void onPlayerStateUpdate(ReplayPlayerState state) {
        state.setRidingBoat(this.isRiding());
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    @Override
    public ByteBuffer toBytes() {
        return ByteBuffer.allocate(1).put((byte)(this.riding ? 1 : 0));
    }

    public static class PlayerRideTimeLineBuilder
    implements TimeLineBuilder {
        private boolean riding;

        public PlayerRideTimeLineBuilder setRiding(boolean riding) {
            this.riding = riding;
            return this;
        }

        public PlayerRideTimeLine build() {
            return new PlayerRideTimeLine(this.riding);
        }
    }

    public static class PlayerRideTimeLineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final PlayerRideTimeLineFactory INSTANCE = new PlayerRideTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PLAYER_RIDE};
        }

        @Override
        public PlayerRideTimeLineBuilder getBuilder() {
            return new PlayerRideTimeLineBuilder();
        }

        public PlayerRideTimeLine getFromBytes(ByteBuffer buffer) {
            return new PlayerRideTimeLine(buffer.get() != 0);
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

