/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionFRotationTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.class_4050;
import net.minecraft.server.MinecraftServer;

public class PlayerSpawnTimeLine
extends PositionFRotationTimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();

    protected PlayerSpawnTimeLine(WorldTypes world, class_1160 position, short yaw, short pitch) {
        super(TimeLineType.PLAYER_SPAWN, world, position, yaw, pitch);
    }

    protected PlayerSpawnTimeLine(WorldTypes world, class_1160 position, float yaw, float pitch) {
        super(TimeLineType.PLAYER_SPAWN, world, position, yaw, pitch);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public void onInit(OpponentPlayerTracker tracker, int tick) {
        tracker.playerDimensionCache.put(tick, this.getWorld());
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    @Override
    public boolean isPlayerMovementTimeline() {
        return true;
    }

    @Override
    public void onPlayerStateUpdate(ReplayPlayerState state) {
        state.setWorldType(this.getWorld());
        state.setPos(this.getPosition());
        state.setPitch(this.getPitch());
        state.setYaw(this.getYaw());
        state.setPose(class_4050.field_18076);
        state.setDeath(false);
        state.setVisible(true);
        state.setInanimate();
    }

    public static class PlayerSpawnTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float yaw;
        private float pitch;

        public PlayerSpawnTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public PlayerSpawnTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public PlayerSpawnTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public PlayerSpawnTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public PlayerSpawnTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public PlayerSpawnTimeLine build() {
            return new PlayerSpawnTimeLine(this.world, this.position, this.yaw, this.pitch);
        }
    }

    public static class PlayerSpawnTimeLineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final PlayerSpawnTimeLineFactory INSTANCE = new PlayerSpawnTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PLAYER_SPAWN, TimeLineType.PLAYER_REMOVE, TimeLineType.PLAYER_POSITION, TimeLineType.PLAYER_POSITION_LOOK, TimeLineType.PLAYER_POSITION_POS};
        }

        @Override
        public PlayerSpawnTimeLineBuilder getBuilder() {
            return new PlayerSpawnTimeLineBuilder();
        }

        public PlayerSpawnTimeLine getFromBytes(ByteBuffer buffer) {
            return new PlayerSpawnTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

