/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.compatible;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.screen.WarningScreen;
import com.mcsrranked.client.info.race.WeeklyRace;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import me.contaria.speedrunapi.config.SpeedrunConfigAPI;
import me.contaria.speedrunapi.config.SpeedrunConfigContainer;
import me.contaria.standardsettings.StandardSettings;
import me.voidxwalker.autoreset.Atum;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;

public class CompatibleWorker {
    private static Consumer<Boolean> fastResetWorker = null;
    private static Runnable worldPreviewWorker = null;
    public static final boolean AVAILABLE_ATUM = FabricLoader.getInstance().getModContainer("atum").isPresent();
    public static boolean APPROVED_ATUM_RESET = false;

    public static void setFastResetActivate(boolean activate) {
        if (fastResetWorker == null) {
            try {
                Class<?> oldFastReset = Class.forName("fast_reset.client.Client");
                Field oldFastResetField = oldFastReset.getDeclaredField("saveOnQuit");
                oldFastResetField.setAccessible(true);
                fastResetWorker = bool -> {
                    try {
                        oldFastResetField.setBoolean(null, bool == false);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                };
            }
            catch (ClassNotFoundException | NoSuchFieldError | NoSuchFieldException oldFastReset) {
                // empty catch block
            }
            try {
                Class<?> newFastReset = Class.forName("fast_reset.client.FastReset");
                Field newFastResetField = newFastReset.getDeclaredField("FAST_CLOSE");
                ThreadLocal booleanThread = (ThreadLocal)newFastResetField.get(null);
                fastResetWorker = booleanThread::set;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldError | NoSuchFieldException throwable) {
                // empty catch block
            }
            if (fastResetWorker == null) {
                fastResetWorker = bool -> {};
            }
        }
        fastResetWorker.accept(activate);
    }

    public static void worldPreviewRenderCancel() {
        if (worldPreviewWorker == null) {
            try {
                Field killPreview2;
                Class<?> worldPreview = Class.forName("me.voidxwalker.worldpreview.WorldPreview");
                try {
                    killPreview2 = worldPreview.getDeclaredField("freezePreview");
                    killPreview2.setAccessible(true);
                    worldPreviewWorker = () -> {
                        try {
                            killPreview2.setBoolean(null, true);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    };
                }
                catch (NoSuchFieldError | NoSuchFieldException killPreview2) {
                    // empty catch block
                }
                try {
                    killPreview2 = worldPreview.getDeclaredField("inPreview");
                    killPreview2.setAccessible(true);
                    if (worldPreviewWorker == null) {
                        worldPreviewWorker = () -> {
                            try {
                                killPreview2.setBoolean(null, false);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                        };
                    }
                }
                catch (NoSuchFieldError | NoSuchFieldException throwable) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (worldPreviewWorker == null) {
                worldPreviewWorker = () -> {};
            }
        }
        worldPreviewWorker.run();
    }

    private static boolean checkSpeedrunAPI() {
        return FabricLoader.getInstance().getModContainer("speedrunapi").map(mod -> {
            try {
                return VersionPredicate.parse((String)">=2.0").test((Object)mod.getMetadata().getVersion());
            }
            catch (VersionParsingException e) {
                return false;
            }
        }).orElse(false);
    }

    public static boolean shouldResetStandardSettings() {
        if (!CompatibleWorker.checkSpeedrunAPI()) {
            return false;
        }
        return SpeedrunConfigAPI.getConfigValueOptionally((String)"standardsettings", (String)"toggleStandardSettings").orElse(false);
    }

    public static void setResetStandardSettings(boolean value) {
        if (CompatibleWorker.checkSpeedrunAPI()) {
            return;
        }
        SpeedrunConfigAPI.setConfigValueOptionally((String)"standardsettings", (String)"toggleStandardSettings", (Object)value);
        try {
            Class<?> clazz = Class.forName("me.contaria.speedrunapi.config.SpeedrunConfigAPI");
            Method method = clazz.getDeclaredMethod("getConfig", String.class);
            method.setAccessible(true);
            SpeedrunConfigContainer container = (SpeedrunConfigContainer)method.invoke(null, "standardsettings");
            container.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void standardSettingsInit() {
        if (!CompatibleWorker.shouldResetStandardSettings()) {
            return;
        }
        StandardSettings.createCache();
        StandardSettings.reset();
    }

    public static void standardSettingsTail(String worldName) {
        if (!CompatibleWorker.shouldResetStandardSettings()) {
            return;
        }
        StandardSettings.saveToWorldFile((String)worldName);
        if (class_310.method_1551().method_1569()) {
            StandardSettings.onWorldJoin();
        } else {
            StandardSettings.onWorldJoinPending = true;
            StandardSettings.autoF3EscPending = StandardSettings.config.autoF3Esc;
        }
    }

    public static boolean shouldAtumCancel() {
        return MCSRRankedClient.getCurrentRace().map(WeeklyRace::isPlaying).orElse(false) != false || MCSRRankedClient.getOnlineMatch().isPresent();
    }

    public static void disableAtumResetting() {
        if (AVAILABLE_ATUM) {
            Atum.stopRunning();
        }
    }

    public static boolean submitAtumWarning() {
        return WarningScreen.check(() -> AVAILABLE_ATUM && !APPROVED_ATUM_RESET, bl -> {
            if (bl.booleanValue()) {
                APPROVED_ATUM_RESET = true;
                Atum.scheduleReset();
            } else {
                CompatibleWorker.disableAtumResetting();
                class_310.method_1551().method_1507(null);
            }
        }, (class_2561)new class_2588("projectelo.warning.atum_modified"));
    }
}

