/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui;

import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.LiveMatchPlayerListHud;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerStatus;
import com.mcsrranked.client.utils.EasyBitFlag;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class LiveMatchHud {
    public static final class_2960 STRUCTURE_ICONS = new class_2960("mcsrranked", "textures/gui/structure_icons.png");
    private static LiveMatchHud instance = null;
    private static final int TOTAL_HEIGHT = 32;

    public static LiveMatchHud getInstance() {
        if (instance == null) {
            instance = new LiveMatchHud();
        }
        return instance;
    }

    public void render(OnlineMatch onlineMatch, class_4587 matrixStack) {
        if (!((Boolean)SpeedRunOption.getOption(RankedOptions.TOGGLE_INFO_GUI)).booleanValue() || onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.DISABLE_LIVE_MATCH_GUI)) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        ProgressFilter progressFilter = (ProgressFilter)SpeedRunOption.getOption(RankedOptions.SHOW_HUD_PROGRESS);
        List playerList = LiveMatchPlayerListHud.getSortedPlayers(onlineMatch, true).stream().filter(p -> {
            if (progressFilter.isHideSelf() && p.isMe()) {
                return false;
            }
            if (progressFilter.isShowInPlayOnly() && (p.getStatus() != PlayerStatus.ONLINE || !onlineMatch.getPlayLog((OnlinePlayer)p).getLastSplit().shouldDisplay())) {
                return false;
            }
            return !progressFilter.isFastestOnly() || p.getStatus().isOnline();
        }).collect(Collectors.toList());
        int scrollSpeed = (int)(3000.0f / ((Float)SpeedRunOption.getOption(RankedOptions.HUD_SCROLL_SPEED)).floatValue());
        int color = class_5253.class_5254.method_27764((int)((int)(((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_OPACITY)).floatValue() * 255.0f)), (int)255, (int)255, (int)255);
        int playerIndex = progressFilter.isFastestOnly() || playerList.isEmpty() ? 0 : (int)(System.currentTimeMillis() / (long)scrollSpeed % (long)playerList.size());
        float guiScale = ((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_SCALE)).floatValue();
        OnlinePlayer targetPlayer = playerList.isEmpty() ? onlineMatch.getPlayers().get(0) : (OnlinePlayer)playerList.get(playerIndex);
        class_3545 guiPosition = new class_3545((Object)((int)((float)class_310.method_1551().method_22683().method_4486() / guiScale * ((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_POSITION_X)).floatValue())), (Object)((int)((float)class_310.method_1551().method_22683().method_4502() / guiScale * ((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_POSITION_Y)).floatValue())));
        class_3545 guiAlign = new class_3545((Object)(((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_POSITION_X)).floatValue() >= 0.5f ? 1 : 0), (Object)(((Float)SpeedRunOption.getOption(RankedOptions.INFO_GUI_POSITION_Y)).floatValue() >= 0.5f ? 1 : 0));
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)guiScale, (float)guiScale, (float)1.0f);
        RenderSystem.enableBlend();
        this.drawGuiText(matrixStack, textRenderer, (class_2561)new class_2588("projectelo.text.match.current_match").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), ((Integer)guiPosition.method_15442()).intValue(), ((Integer)guiPosition.method_15441()).intValue(), 0.0f, (class_3545<Boolean, Boolean>)guiAlign, color);
        this.drawGuiText(matrixStack, textRenderer, onlineMatch.getDisplayName(), ((Integer)guiPosition.method_15442()).intValue(), ((Integer)guiPosition.method_15441()).intValue(), 10.0f, (class_3545<Boolean, Boolean>)guiAlign, color);
        this.drawOpponentText(onlineMatch, targetPlayer, matrixStack, textRenderer, ((Integer)guiPosition.method_15442()).intValue(), ((Integer)guiPosition.method_15441()).intValue(), (class_3545<Boolean, Boolean>)guiAlign, color);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    private void drawOpponentText(OnlineMatch currentMatch, OnlinePlayer targetPlayer, class_4587 matrixStack, class_327 textRenderer, float x, float y, class_3545<Boolean, Boolean> alignPair, int color) {
        int nicknameWidth = BasePlayer.getNicknameWidth(targetPlayer);
        float f = 10 + nicknameWidth;
        Objects.requireNonNull(textRenderer);
        class_3545<Float, Float> headPosition = this.getDrawPosition(x, y, 0.0f, 23.0f, f, 9.0f, alignPair);
        RenderUtils.renderPlayerHead(targetPlayer.getDisplayUUID(), matrixStack, ((Float)headPosition.method_15442()).intValue(), ((Float)headPosition.method_15441()).intValue(), 8, 8, (float)class_5253.class_5254.method_27762((int)color) / 255.0f);
        float f2 = (Boolean)alignPair.method_15442() != false ? 0 : 10;
        float f3 = nicknameWidth;
        Objects.requireNonNull(textRenderer);
        class_3545<Float, Float> nicknamePosition = this.getDrawPosition(x, y, f2, 23.0f, f3, 9.0f, alignPair);
        BasePlayer.renderNickname(matrixStack, ((Float)nicknamePosition.method_15442()).intValue(), ((Float)nicknamePosition.method_15441()).intValue(), targetPlayer, color);
        if (!((Boolean)SpeedRunOption.getOption(RankedOptions.SHOW_HUD_PLAYER_PACE)).booleanValue()) {
            return;
        }
        boolean disableIcon = false;
        MatchSplit currentSplit = currentMatch.getPlayLog(targetPlayer).getLastSplit();
        String statusId = "projectelo.player.status." + currentSplit.name().toLowerCase(Locale.ROOT);
        class_5250 statusText = new class_2588(statusId).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
        class_3545<Float, Float> position = this.getDrawPosition(x, y, 0.0f, 32.0f, 11 + textRenderer.method_27525((class_5348)statusText), 8.0f, alignPair);
        boolean displayIcon = false;
        if (currentSplit.getU() > -1 && ((Boolean)SpeedRunOption.getOption(RankedOptions.SHOW_HUD_STATUS_ICON)).booleanValue() && !disableIcon) {
            class_310.method_1551().method_1531().method_22813(STRUCTURE_ICONS);
            matrixStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)class_5253.class_5254.method_27762((int)color) / 255.0f));
            matrixStack.method_22904(0.0, (Boolean)alignPair.method_15441() != false ? -0.5 : 0.5, 0.0);
            class_332.method_25293((class_4587)matrixStack, (int)((Float)position.method_15442()).intValue(), (int)((Float)position.method_15441()).intValue(), (int)8, (int)8, (float)currentSplit.getU(), (float)currentSplit.getV(), (int)16, (int)16, (int)64, (int)64);
            matrixStack.method_22909();
            displayIcon = true;
        }
        this.drawGuiText(matrixStack, textRenderer, (class_2561)statusText, x + (float)((Boolean)alignPair.method_15442() == false && displayIcon ? 11 : 0), y, 33.0f, alignPair, color);
    }

    private void drawGuiText(class_4587 matrixStack, class_327 textRenderer, class_2561 text, float x, float y, float advanceY, class_3545<Boolean, Boolean> alignPair, int color) {
        float f = textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        class_3545<Float, Float> position = this.getDrawPosition(x, y, 0.0f, advanceY, f, 9.0f, alignPair);
        textRenderer.method_27517(matrixStack, (class_5348)text, ((Float)position.method_15442()).floatValue(), ((Float)position.method_15441()).floatValue(), color);
    }

    private class_3545<Float, Float> getDrawPosition(float x, float y, float advanceX, float advanceY, float width, float height, class_3545<Boolean, Boolean> alignPair) {
        return new class_3545((Object)Float.valueOf(x - ((Boolean)alignPair.method_15442() != false ? width + advanceX : -advanceX)), (Object)Float.valueOf(y + ((Boolean)alignPair.method_15441() != false ? -(height - advanceY + 32.0f) : advanceY)));
    }

    public static class ProgressFilter {
        public static ProgressFilter DEFAULT = new ProgressFilter(false, false, false);
        private boolean hideSelf;
        private boolean showInPlayOnly;
        private boolean fastestOnly;

        public ProgressFilter(boolean hideSelf, boolean showInPlayOnly, boolean fastestOnly) {
            this.hideSelf = hideSelf;
            this.showInPlayOnly = showInPlayOnly;
            this.fastestOnly = fastestOnly;
        }

        public static ProgressFilter fromFlags(EasyBitFlag easyBitFlag) {
            return new ProgressFilter(easyBitFlag.includeValue(0), easyBitFlag.includeValue(1), easyBitFlag.includeValue(2));
        }

        public int toFlags() {
            return EasyBitFlag.of(this.isHideSelf(), this.isShowInPlayOnly(), this.isFastestOnly()).getFlagValue();
        }

        public boolean isHideSelf() {
            return this.hideSelf;
        }

        public boolean isFastestOnly() {
            return this.fastestOnly;
        }

        public boolean isShowInPlayOnly() {
            return this.showInPlayOnly;
        }

        public ProgressFilter toggleFastestOnly() {
            this.fastestOnly = !this.fastestOnly;
            return this;
        }

        public ProgressFilter toggleShowInPlayOnly() {
            this.showInPlayOnly = !this.showInPlayOnly;
            return this;
        }

        public ProgressFilter toggleHideSelf() {
            this.hideSelf = !this.hideSelf;
            return this;
        }
    }
}

