/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen;

import com.google.common.collect.Lists;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.player.PlayerCountry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class CountrySelectScreen
extends RankedScreen {
    private final Consumer<@Nullable PlayerCountry> onResult;
    private CountryListWidget countryListWidget;
    private class_342 searchField;

    public CountrySelectScreen(class_437 parent, Consumer<@Nullable PlayerCountry> onResult) {
        super(parent, (class_2561)new class_2588("projectelo.title.select_country"));
        this.onResult = onResult;
    }

    protected void method_25426() {
        this.countryListWidget = new CountryListWidget(this.field_22787, this);
        this.method_25429((class_364)this.countryListWidget);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 152, this.field_22790 - 28, 150, 20, (class_2561)new class_2588("projectelo.button.apply"), button -> {
            this.onResult.accept(this.countryListWidget.method_25334() == null ? null : ((CountryListWidget.Entry)this.countryListWidget.method_25334()).country);
            this.method_25419();
        }));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 28, 150, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
        this.searchField = (class_342)this.method_25429((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 100, 20, 200, 20, class_2585.field_24366));
        this.searchField.method_1887(class_1074.method_4662((String)"gui.recipebook.search_hint", (Object[])new Object[0]));
        this.searchField.method_1863(text -> {
            this.countryListWidget.updateEntries((String)text);
            this.searchField.method_1887(text.isEmpty() ? class_1074.method_4662((String)"gui.recipebook.search_hint", (Object[])new Object[0]) : "");
        });
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.countryListWidget.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.searchField.method_25394(matrices, mouseX, mouseY, delta);
        this.method_27534(matrices, this.field_22793, (class_5348)this.method_25440(), this.field_22789 / 2, 6, 0xFFFFFF);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.searchField.method_1865();
    }

    public class CountryListWidget
    extends class_4280<Entry>
    implements RankedEntryListWidget {
        public CountryListWidget(class_310 minecraftClient, class_437 currentScreen) {
            super(minecraftClient, currentScreen.field_22789, currentScreen.field_22790, 46, currentScreen.field_22790 - 36, 16);
            this.updateEntries("");
        }

        public void updateEntries(String search) {
            PlayerCountry selectedCountry = null;
            if (this.method_25334() != null) {
                selectedCountry = ((Entry)this.method_25334()).country;
            }
            this.method_25339();
            this.method_25321((class_350.class_351)new Entry(null));
            ArrayList countries = Lists.newArrayList(PlayerCountry.getAvailableCountries());
            countries.sort(Comparator.comparing(PlayerCountry::getName));
            int index = 0;
            for (PlayerCountry country : countries) {
                if (!country.isSearchable(search)) continue;
                int target = this.method_25321((class_350.class_351)new Entry(country));
                if (selectedCountry == null || !country.getCode().equals(selectedCountry.getCode())) continue;
                index = target;
            }
            this.method_25313((class_350.class_351)((Entry)this.method_25326(index)));
            this.method_25307(this.method_25341());
        }

        protected int method_25329() {
            return this.field_19087 - 8;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return super.method_25401(mouseX, mouseY, amount * 3.0);
        }

        public int method_25322() {
            return (int)((double)this.field_22742 * 0.8);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            super.method_25394(matrices, mouseX, mouseY, delta);
        }

        public class Entry
        extends class_4280.class_4281<Entry> {
            private final PlayerCountry country;

            public Entry(PlayerCountry country) {
                this.country = country;
            }

            public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.country == null) {
                    CountrySelectScreen.this.method_27534(matrices, CountrySelectScreen.this.field_22793, (class_5348)RankedScreenTexts.NONE.text(), x + entryWidth / 2, y + 2, 0xFFFFFF);
                    return;
                }
                class_2585 text = new class_2585(this.country.getContext());
                int textWidth = CountrySelectScreen.this.field_22793.method_27525((class_5348)text);
                int flagWidth = 12;
                PlayerCountry.renderCountryFlag(this.country, matrices, x + (entryWidth - flagWidth - textWidth) / 2, y + 3, 9, 6, CountrySelectScreen.this, 0, 0);
                CountrySelectScreen.this.method_27535(matrices, CountrySelectScreen.this.field_22793, (class_5348)text, x + (entryWidth + flagWidth - textWidth) / 2, y + 2, 0xFFFFFF);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                CountryListWidget.this.method_25313((class_350.class_351)this);
                return super.method_25402(mouseX, mouseY, button);
            }
        }
    }
}

