/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.info;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.CountrySelectScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.PhaseLeaderboardScreen;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.UserLeaderboardWidget;
import com.mcsrranked.client.info.player.LeaderboardPlayer;
import com.mcsrranked.client.info.player.PlayerCountry;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class EloLeaderboardScreen
extends RankedScreen {
    private class_4185 prevSeasonButton;
    private class_4185 nextSeasonButton;
    private UserLeaderboardWidget leaderboardWidget;
    private final CopyOnWriteArrayList<LeaderboardPlayer> leaderboardData = new CopyOnWriteArrayList();
    private int currentSeason = -1;
    private int seasonNumber = -1;
    private Long seasonEndTime = null;
    private Double previousScrollAmount = null;
    private class_4185 phaseButton;
    private class_4185 countryButton;
    private PlayerCountry selectedCountry = null;
    private boolean shouldRefresh = false;

    public EloLeaderboardScreen(class_437 parent) {
        super(parent, (class_2561)new class_2588("projectelo.button.elo_leaderboard"));
    }

    public EloLeaderboardScreen(class_437 parent, PlayerCountry playerCountry) {
        this(parent);
        this.selectedCountry = playerCountry;
    }

    private void loadLeaderboard(int seasonNumber, PlayerCountry country) {
        if (!this.prevSeasonButton.field_22763 && !this.nextSeasonButton.field_22763) {
            return;
        }
        if (this.seasonNumber != seasonNumber || this.selectedCountry != country || this.shouldRefresh) {
            this.previousScrollAmount = null;
            this.leaderboardData.clear();
            this.leaderboardWidget.updatePlayerList(new CopyOnWriteArrayList<LeaderboardPlayer>(), 0.0, this.selectedCountry != null);
            this.shouldRefresh = false;
        }
        this.seasonNumber = seasonNumber;
        this.nextSeasonButton.field_22763 = false;
        this.prevSeasonButton.field_22763 = false;
        if (this.leaderboardData.isEmpty()) {
            MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
                JsonElement seasonEnd;
                JsonElement result;
                ArrayList params = Lists.newArrayList();
                if (seasonNumber > 0) {
                    params.add("season=" + seasonNumber);
                }
                if (country != null) {
                    params.add("country=" + country.getCode());
                }
                if ((result = ClientUtils.getApiResponse("leaderboard" + (params.isEmpty() ? "" : "?" + String.join((CharSequence)"&", params)))) == null) {
                    return;
                }
                if (seasonNumber <= 0) {
                    this.seasonNumber = this.currentSeason = result.getAsJsonObject().getAsJsonObject("season").get("number").getAsInt();
                }
                this.seasonEndTime = (seasonEnd = result.getAsJsonObject().getAsJsonObject("season").get("endsAt")).isJsonNull() ? null : Long.valueOf((long)seasonEnd.getAsInt() * 1000L);
                JsonArray playerListArray = result.getAsJsonObject().getAsJsonArray("users");
                for (JsonElement jsonElement : playerListArray) {
                    this.leaderboardData.add((LeaderboardPlayer)MCSRRankedClient.GSON.fromJson(jsonElement, LeaderboardPlayer.class));
                }
                this.prevSeasonButton.field_22763 = this.seasonNumber > 1;
                this.nextSeasonButton.field_22763 = this.seasonNumber < this.currentSeason;
                this.selectedCountry = country;
                class_310.method_1551().execute(() -> this.leaderboardWidget.updatePlayerList(this.leaderboardData, this.previousScrollAmount, this.selectedCountry != null));
            });
        } else {
            this.leaderboardWidget.updatePlayerList(this.leaderboardData, this.previousScrollAmount, this.selectedCountry != null);
            this.prevSeasonButton.field_22763 = this.seasonNumber > 1;
            this.nextSeasonButton.field_22763 = this.seasonNumber < this.currentSeason;
            this.selectedCountry = country;
        }
    }

    protected void method_25426() {
        this.leaderboardWidget = (UserLeaderboardWidget)this.method_25429((class_364)new UserLeaderboardWidget(this.field_22787, this, false));
        this.prevSeasonButton = (class_4185)this.method_25411((class_339)new class_4185((this.field_22789 - this.leaderboardWidget.method_25322()) / 2 - 30, 6, 20, 20, class_2561.method_30163((String)"<"), button -> this.loadLeaderboard(this.seasonNumber - 1, this.selectedCountry), (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)new class_2588("projectelo.button.prev_season"), mouseX, button.field_22761 + button.method_25364())));
        this.nextSeasonButton = (class_4185)this.method_25411((class_339)new class_4185((this.field_22789 + this.leaderboardWidget.method_25322()) / 2 + 10, 6, 20, 20, class_2561.method_30163((String)">"), button -> this.loadLeaderboard(this.seasonNumber + 1, this.selectedCountry), (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)new class_2588("projectelo.button.next_season"), mouseX, button.field_22761 + button.method_25364())));
        this.loadLeaderboard(this.seasonNumber, this.selectedCountry);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
        this.phaseButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(this.field_22789 / 2 - 132, this.field_22790 - 32, 24, 24, class_2585.field_24366, button -> this.openScreen(new PhaseLeaderboardScreen(this.getParent())), (button, matrices, mouseX, mouseY) -> this.setTooltip(new class_2588("projectelo.title.phase_point_leaderboard"))));
        this.countryButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(this.field_22789 / 2 + 108, this.field_22790 - 32, 24, 24, class_2585.field_24366, button -> this.openScreen(new CountrySelectScreen((class_437)this, country -> {
            this.selectedCountry = country;
            this.shouldRefresh = true;
        })), (button, matrices, mouseX, mouseY) -> this.setTooltip(new class_2588("projectelo.tooltip.selected_country").method_27693(": ").method_10852((class_2561)(this.selectedCountry == null ? RankedScreenTexts.NONE.text() : new class_2585(this.selectedCountry.getContext()))))));
        this.countryButton.field_22763 = false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.previousScrollAmount = this.leaderboardWidget.method_25341();
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.leaderboardWidget.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.phaseButton != null) {
            TextureUtils.renderPhasePointIcon(matrices, this.phaseButton.field_22760 + 4, this.phaseButton.field_22761 + 4, 16);
        }
        if (this.countryButton != null) {
            this.countryButton.field_22763 = this.prevSeasonButton.field_22763 || this.nextSeasonButton.field_22763;
            this.getClient().method_1531().method_22813(TextureUtils.DEFAULT_GUI_TEXTURE);
            if (this.selectedCountry == null) {
                EloLeaderboardScreen.method_25293((class_4587)matrices, (int)(this.countryButton.field_22760 + 4), (int)(this.countryButton.field_22761 + 4), (int)16, (int)16, (float)48.0f, (float)48.0f, (int)16, (int)16, (int)128, (int)128);
            } else {
                RenderSystem.pushMatrix();
                RenderSystem.color3f((float)0.3f, (float)0.3f, (float)0.3f);
                EloLeaderboardScreen.method_25293((class_4587)matrices, (int)(this.countryButton.field_22760 + 4), (int)(this.countryButton.field_22761 + 4), (int)16, (int)16, (float)48.0f, (float)48.0f, (int)16, (int)16, (int)128, (int)128);
                RenderSystem.popMatrix();
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                PlayerCountry.renderCountryFlag(this.selectedCountry, matrices, this.countryButton.field_22760 + 6, this.countryButton.field_22761 + 8, 12, 8, this, mouseX, mouseY);
            }
        }
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        if (!this.prevSeasonButton.field_22763 && !this.nextSeasonButton.field_22763) {
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 - 10);
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.loading_server"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        } else {
            int seasonEndWidth;
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.getSeasonText(), this.field_22789 / 2, 20, 0xFFFFFF);
            if (this.seasonEndTime != null && mouseX >= (this.field_22789 - (seasonEndWidth = this.field_22793.method_27525((class_5348)this.getSeasonText()))) / 2 && mouseX < (this.field_22789 + seasonEndWidth) / 2 && mouseY >= 20 && mouseY < 29) {
                this.setTooltip(new class_2588("projectelo.text.season_ends").method_27693(": " + ClientUtils.getDateFormat(new Date(this.seasonEndTime), false)));
            }
        }
    }

    private class_2561 getSeasonText() {
        class_5250 text = new class_2588("projectelo.text.profile.season").method_27693(": ").method_10852((class_2561)new class_2585(String.valueOf(this.seasonNumber)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        if (this.seasonEndTime == null) {
            return text;
        }
        String endDate = ClientUtils.timeToDurationFormat(this.seasonEndTime);
        return text.method_27693(" | ").method_10852((class_2561)new class_2588("projectelo.text.season_ends").method_27693(": ").method_10852((class_2561)new class_2585(endDate).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})));
    }
}

