/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.UserMatchListWidget;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.server.BaseMatchData;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.ClientUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UserMatchListScreen
extends RankedScreen {
    private final BasePlayer playerProfile;
    private final CopyOnWriteArrayList<BaseMatchData> matchResults = new CopyOnWriteArrayList();
    private final Supplier<class_5250> sortTextSupplier;
    private int currentPage = 0;
    private final Map<Integer, Integer> lastMatchIdMap = new HashMap<Integer, Integer>();
    private int currentFilter = 2;
    private SortMethod currentSortMethod = SortMethod.NEWEST;
    private boolean matchLoaded = false;
    private UserMatchListWidget matchListWidget;
    private class_4185 closeButton;
    private class_4185 nextPageButton;
    private class_4185 prevPageButton;
    private class_4185 sortButton;

    public UserMatchListScreen(class_437 parent, BasePlayer playerProfile) {
        super(parent, (class_2561)new class_2588("projectelo.title.player_match_list", new Object[]{playerProfile.getNickname()}));
        this.playerProfile = playerProfile;
        this.loadMatches(0, this.currentFilter, this.currentSortMethod);
        this.sortTextSupplier = () -> new class_2588("projectelo.button.sort").method_27693(": ").method_10852((class_2561)this.currentSortMethod.toText().method_27692(class_124.field_1060));
    }

    protected void method_25426() {
        super.method_25426();
        boolean prevActive = this.nextPageButton != null && this.nextPageButton.field_22763;
        this.nextPageButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 62, this.field_22790 - 54, 50, 20, class_2561.method_30163((String)">"), button -> this.loadMatches(this.currentPage + 1, this.currentFilter, this.currentSortMethod)));
        this.nextPageButton.field_22763 = prevActive;
        prevActive = this.prevPageButton != null && this.prevPageButton.field_22763;
        this.prevPageButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 112, this.field_22790 - 54, 50, 20, class_2561.method_30163((String)"<"), button -> this.loadMatches(this.currentPage - 1, this.currentFilter, this.currentSortMethod)));
        this.prevPageButton.field_22763 = prevActive;
        Supplier<class_2561> filterText = () -> new class_2588("projectelo.button.filter").method_27693(": ").method_10852((class_2561)new class_2588(this.currentFilter == 0 ? "gui.all" : MatchType.byID(this.currentFilter).getKey()));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 60, this.field_22790 - 54, 120, 20, filterText.get(), button -> {
            if (++this.currentFilter == 5) {
                this.currentFilter = 0;
            }
            button.method_25355((class_2561)filterText.get());
            this.loadMatches(0, this.currentFilter, SortMethod.NEWEST);
        }));
        this.sortButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(this.field_22789 - 100, 9, 90, 18, (class_2561)this.sortTextSupplier.get(), button -> {
            this.currentSortMethod = this.currentFilter != 2 || class_437.method_25442() ? this.currentSortMethod.invert() : this.currentSortMethod.change();
            button.method_25355((class_2561)this.sortTextSupplier.get());
            this.loadMatches(0, this.currentFilter, this.currentSortMethod);
        }, (button, matrices, mouseX, mouseY) -> {
            if (this.currentFilter != 2) {
                this.setTooltipWithWrap(new class_2585(String.format("%s\nClick > %s", class_1074.method_4662((String)"projectelo.text.click_sort_change", (Object[])new Object[0]), class_1074.method_4662((String)"projectelo.text.change_to", (Object[])new Object[]{this.currentSortMethod.invert().toText().getString()}))), 300);
            } else {
                this.setTooltipWithWrap(new class_2585(String.format("%s\nClick > %s\nShift + Click > %s", class_1074.method_4662((String)"projectelo.text.click_sort_change", (Object[])new Object[0]), class_1074.method_4662((String)"projectelo.text.change_to", (Object[])new Object[]{this.currentSortMethod.change().toText().getString()}), class_1074.method_4662((String)"projectelo.text.change_to", (Object[])new Object[]{this.currentSortMethod.invert().toText().getString()}))), 300);
            }
        }));
        this.closeButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
        this.matchListWidget = (UserMatchListWidget)this.method_25429((class_364)new UserMatchListWidget(this.field_22787, this, this.playerProfile));
        this.matchListWidget.updateMatchList(this.matchResults);
        if (!this.matchLoaded) {
            for (class_339 button2 : this.field_22791) {
                if (button2 == this.closeButton) continue;
                button2.field_22763 = false;
            }
        }
    }

    public void loadMatches(int page, int filter, SortMethod sortMethod) {
        this.currentPage = page;
        this.currentFilter = filter;
        if (this.currentSortMethod != sortMethod) {
            this.lastMatchIdMap.clear();
        }
        this.currentSortMethod = sortMethod;
        for (class_339 button : this.field_22791) {
            if (button == this.closeButton) continue;
            button.field_22763 = false;
        }
        this.matchLoaded = false;
        if (this.matchListWidget != null) {
            this.matchListWidget.updateMatchList(new CopyOnWriteArrayList<BaseMatchData>());
        }
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            Integer lastMatchId = this.lastMatchIdMap.getOrDefault(page - 1, null);
            JsonElement result = ClientUtils.getApiResponse("users/" + this.playerProfile.getUUIDString() + "/matches?type=" + filter + (lastMatchId == null ? "" : "&before=" + lastMatchId) + "&sort=" + this.currentSortMethod.toLowerName());
            if (result == null) {
                for (class_339 button : this.field_22791) {
                    if (button == this.closeButton) continue;
                    button.field_22763 = true;
                }
                this.nextPageButton.field_22763 = false;
                this.prevPageButton.field_22763 = false;
                this.matchLoaded = true;
                return;
            }
            JsonArray matchListArray = result.getAsJsonArray();
            if (matchListArray.size() == 0) {
                for (class_339 button : this.field_22791) {
                    if (button == this.closeButton) continue;
                    button.field_22763 = true;
                }
                this.nextPageButton.field_22763 = false;
                this.prevPageButton.field_22763 = this.currentPage > 0;
                this.matchLoaded = true;
                return;
            }
            this.matchResults.clear();
            int size = 0;
            for (JsonElement jsonElement : matchListArray) {
                if (size++ == 20) continue;
                BaseMatchData matchData = (BaseMatchData)MCSRRankedClient.GSON.fromJson(jsonElement, BaseMatchData.class);
                matchData.getPlayers().sort((p1, p2) -> {
                    if (p1.equals(this.playerProfile)) {
                        return -1;
                    }
                    if (p2.equals(this.playerProfile)) {
                        return 1;
                    }
                    return p1.getNickname().compareTo(p2.getNickname());
                });
                this.matchResults.add(matchData);
                this.lastMatchIdMap.put(page, matchData.getID());
            }
            CopyOnWriteArrayList<BaseMatchData> newMatchResults = new CopyOnWriteArrayList<BaseMatchData>(this.matchResults);
            class_310.method_1551().execute(() -> {
                this.matchListWidget.updateMatchList(newMatchResults);
                this.matchListWidget.method_25307(0.0);
                for (class_339 button : this.field_22791) {
                    if (button == this.closeButton) continue;
                    button.field_22763 = true;
                }
                this.nextPageButton.field_22763 = matchListArray.size() >= 20 && this.currentPage < 99;
                this.prevPageButton.field_22763 = this.currentPage > 0;
                this.matchLoaded = true;
            });
        });
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.sortButton != null) {
            this.sortButton.method_25355((class_2561)this.sortTextSupplier.get());
        }
        this.method_25420(matrices);
        this.matchListWidget.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (!this.matchLoaded) {
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 - 10);
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.loading_server"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        }
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, 14, 0xFFFFFF);
    }

    public static enum SortMethod {
        NEWEST,
        OLDEST,
        FASTEST,
        SLOWEST;


        public SortMethod invert() {
            switch (this.ordinal()) {
                case 0: {
                    return OLDEST;
                }
                case 1: {
                    return NEWEST;
                }
                case 2: {
                    return SLOWEST;
                }
                case 3: {
                    return FASTEST;
                }
            }
            return NEWEST;
        }

        public SortMethod change() {
            switch (this.ordinal()) {
                case 0: {
                    return FASTEST;
                }
                case 1: {
                    return SLOWEST;
                }
                case 2: {
                    return NEWEST;
                }
                case 3: {
                    return OLDEST;
                }
            }
            return NEWEST;
        }

        public String toLowerName() {
            return this.name().toLowerCase();
        }

        public class_2588 toText() {
            return new class_2588("projectelo.text.sort." + this.toLowerName());
        }
    }
}

