/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.info;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.CountrySelectScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.EloLeaderboardScreen;
import com.mcsrranked.client.gui.screen.info.UserMatchListScreen;
import com.mcsrranked.client.gui.widget.EloChangeChartWidget;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.FreeSizeTexturedButtonWidget;
import com.mcsrranked.client.info.match.server.BaseMatchData;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.PlayerConnections;
import com.mcsrranked.client.info.player.PlayerCountry;
import com.mcsrranked.client.info.player.StatisticPlayer;
import com.mcsrranked.client.info.player.achievement.AchievementManager;
import com.mcsrranked.client.info.player.achievement.AchievementWorker;
import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.info.player.statistic.PlayerAchievements;
import com.mcsrranked.client.info.player.statistic.PlayerSeasonResult;
import com.mcsrranked.client.info.player.statistic.PlayerStatistics;
import com.mcsrranked.client.info.player.statistic.SimplePhaseResult;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.lwjgl.glfw.GLFW;

public class UserProfileScreen
extends RankedScreen {
    public static final class_2960 YOUTUBE_ICON = new class_2960("mcsrranked", "textures/gui/youtube_social.png");
    public static final class_2960 TWITCH_ICON = new class_2960("mcsrranked", "textures/gui/twitch_social.png");
    public static final class_2960 DISCORD_ICON = new class_2960("mcsrranked", "textures/gui/discord_social.png");
    private final String query;
    private boolean errorOccurred = false;
    private boolean initialized = false;
    private StatisticPlayer playerProfile = null;
    private EloChangeChartWidget chartWidget = null;
    private FreeSizeButtonWidget profileSettingsButton = null;
    private int tabWidth = 0;
    private int achievementPage = 1;
    private int achievementMaxPage = 0;
    private class_4185 achievementNextButton = null;
    private class_4185 achievementPrevButton = null;
    private PlayerAchievement hoveredAchievement = null;
    private PlayerAchievement focusedAchievement = null;
    private PlayerAchievements originalAchievements = null;
    private class_238 flagPosition = null;

    public UserProfileScreen(String query, class_437 parent) {
        super(parent, class_2585.field_24366);
        this.query = query.replaceAll("-", "");
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            JsonElement userResult = ClientUtils.getApiResponse("users/" + this.query);
            if (userResult == null) {
                this.errorOccurred = true;
                return;
            }
            this.playerProfile = (StatisticPlayer)MCSRRankedClient.GSON.fromJson(userResult, StatisticPlayer.class);
            MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
                JsonElement matchListResult = ClientUtils.getApiResponse("users/" + query.replaceAll("-", "") + "/matches?filter=2&count=100");
                if (matchListResult == null) {
                    return;
                }
                JsonArray matchListArray = matchListResult.getAsJsonArray();
                CopyOnWriteArrayList<BaseMatchData> matchDataList = new CopyOnWriteArrayList<BaseMatchData>();
                int size = 0;
                for (JsonElement jsonElement : matchListArray) {
                    if (size++ == 20) continue;
                    BaseMatchData matchData = (BaseMatchData)MCSRRankedClient.GSON.fromJson(jsonElement, BaseMatchData.class);
                    matchDataList.add(0, matchData);
                }
                if (matchDataList.size() > 1) {
                    this.chartWidget = new EloChangeChartWidget(this.tabWidth + 10, 100, this.field_22789 - (this.tabWidth + 20), this.field_22790 - 70 - 104, this.field_22793);
                    this.chartWidget.updateMatchList(this.playerProfile.getUUID(), matchDataList);
                }
            });
        });
        SocketInstance.on("p$receive_token", payload -> {
            String oauthType = payload.getNextString();
            String oauthKey = payload.getNextString();
            class_156.method_668().method_670(MCSRRankedClient.getServerUrl("http") + "/oauth/" + oauthType + "?key=" + oauthKey);
        });
        SocketInstance.on("p$complete_oauth", payload -> {
            String authType = payload.getNextString();
            MCSRRankedClient.PLAYER_CONNECTIONS.setConnection(authType, (PlayerConnections.Connection)MCSRRankedClient.GSON.fromJson((JsonElement)payload.getNextJsonObject(), PlayerConnections.Connection.class));
            if (Objects.equals(authType, "patreon")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.linked_third_party", (Object[])new Object[]{"Patreon"})));
            }
            if (Objects.equals(authType, "discord")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.linked_third_party", (Object[])new Object[]{"Discord"})));
            }
            if (Objects.equals(authType, "twitch")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.linked_third_party", (Object[])new Object[]{"Twitch"})));
            }
            if (Objects.equals(authType, "youtube")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.linked_third_party", (Object[])new Object[]{"Youtube"})));
            }
            GLFW.glfwShowWindow((long)class_310.method_1551().method_22683().method_4490());
            class_310.method_1551().execute(() -> {
                if (class_310.method_1551().field_1755 instanceof UserProfileScreen) {
                    ((UserProfileScreen)class_310.method_1551().field_1755).initAllButtons();
                }
            });
        });
        SocketInstance.on("p$unlink_oauth", payload -> {
            String authType = payload.getNextString();
            MCSRRankedClient.PLAYER_CONNECTIONS.setConnection(authType, null);
            if (Objects.equals(authType, "patreon")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.unlinked_third_party", (Object[])new Object[]{"Patreon"})));
            }
            if (Objects.equals(authType, "discord")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.unlinked_third_party", (Object[])new Object[]{"Discord"})));
            }
            if (Objects.equals(authType, "twitch")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.unlinked_third_party", (Object[])new Object[]{"Twitch"})));
            }
            if (Objects.equals(authType, "youtube")) {
                class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.unlinked_third_party", (Object[])new Object[]{"Youtube"})));
            }
            GLFW.glfwShowWindow((long)class_310.method_1551().method_22683().method_4490());
            class_310.method_1551().execute(() -> {
                if (class_310.method_1551().field_1755 instanceof UserProfileScreen) {
                    ((UserProfileScreen)class_310.method_1551().field_1755).initAllButtons();
                }
            });
        });
        SocketInstance.on("p$private_key", payload -> {
            class_310.method_1551().field_1774.method_1455(payload.getNextString());
            class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.copied_private_key", (Object[])new Object[0])));
        });
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = false;
        this.tabWidth = this.field_22789 / 6;
        this.initTabButtons();
        if (this.chartWidget != null) {
            this.chartWidget.updatePos(this.tabWidth + 10, 100, this.field_22789 - (this.tabWidth + 20), this.field_22790 - 70 - 104);
        }
    }

    public void initAllButtons() {
        this.initTabButtons();
        this.initAchievementButtons();
        this.initCurrentTab();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.playerProfile != null && !this.initialized) {
            this.initAllButtons();
            this.initialized = true;
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        this.method_25420(matrices);
        if (this.playerProfile != null && this.profileSettingsButton != null && this.playerProfile.isMe()) {
            this.profileSettingsButton.field_22764 = true;
        }
        this.renderTabIcons(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.playerProfile != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)3.0f, (float)3.0f, (float)3.0f);
            int xOffset = this.tabWidth / 3 + 4;
            RenderUtils.renderPlayerHead(this.playerProfile.getUUID(), matrices, xOffset, 5, 8, 8);
            if (PlayerCountry.renderCountryFlag(this.playerProfile.getCountry(), matrices, xOffset += 11, 6, 9, 6, this, mouseX / 3, mouseY / 3)) {
                this.flagPosition = new class_238((double)(xOffset * 3), 18.0, 0.0, (double)((xOffset + 9) * 3), 36.0, 1.0);
                xOffset += 11;
            }
            BasePlayer.renderNickname(matrices, xOffset, 5, this.playerProfile, this, mouseX / 3, mouseY / 3);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.0f);
            int eloXOffset = (int)((float)this.tabWidth / 1.5f + 6.0f);
            int eloWidth = BasePlayer.renderEloText(matrices, eloXOffset, 30, this.playerProfile.getEloRate(), this.playerProfile.getEloRank());
            if (this.playerProfile.getSeasonResult().getSeasonResult().getPhasePoint() > 0) {
                TextureUtils.renderPhasePointIcon(matrices, eloXOffset + 8 + eloWidth, 30, 8);
                this.method_25303(matrices, this.field_22793, String.valueOf(this.playerProfile.getSeasonResult().getSeasonResult().getPhasePoint()), eloXOffset + 19 + eloWidth, 30, 0xFFFFFF);
                int phaseWidth = this.field_22793.method_1727(String.valueOf(this.playerProfile.getSeasonResult().getSeasonResult().getPhasePoint()));
                if ((float)mouseX / 1.5f >= (float)(eloXOffset + 8 + eloWidth) && (float)mouseY / 1.5f >= 30.0f && (float)mouseX / 1.5f < (float)(eloXOffset + 19 + eloWidth + phaseWidth) && (float)mouseY / 1.5f < 38.0f) {
                    ArrayList tooltips = Lists.newArrayList();
                    tooltips.add(new class_2588("projectelo.text.phase_points"));
                    for (SimplePhaseResult phaseResult : this.playerProfile.getSeasonResult().getPhaseResults()) {
                        class_2585 text = new class_2585("- Phase " + phaseResult.getPhase() + ": ");
                        text.method_10852((class_2561)new class_2585("+" + phaseResult.getPoint()).method_27692(class_124.field_1054));
                        text.method_10852((class_2561)new class_2585(" (#" + phaseResult.getEloRank() + ")").method_27692(class_124.field_1080));
                        tooltips.add(text);
                    }
                    this.setTooltip(tooltips);
                }
            }
            RenderSystem.popMatrix();
        } else if (this.errorOccurred) {
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.failed_to_find_profile"), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2, 0xFFFFFF);
        } else {
            this.renderLoadingText(matrices, this.field_22789 / 2 + 40, this.field_22790 / 2 - 10);
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.loading_server"), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2, 0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.playerProfile != null && this.playerProfile.isMe()) {
            if (this.hoveredAchievement != null && !this.hoveredAchievement.equals(this.focusedAchievement)) {
                if (this.focusedAchievement != null || !this.hoveredAchievement.getID().equals("empty")) {
                    if (this.focusedAchievement == null) {
                        this.focusedAchievement = this.hoveredAchievement;
                    } else {
                        boolean hoverDisplay;
                        if (this.originalAchievements == null) {
                            this.originalAchievements = (PlayerAchievements)MCSRRankedClient.GSON.fromJson(MCSRRankedClient.GSON.toJson((Object)this.playerProfile.getAchievements()), PlayerAchievements.class);
                        }
                        List<PlayerAchievement> displayAchieve = this.playerProfile.getAchievements().getDisplay();
                        List<PlayerAchievement> totalAchieve = this.playerProfile.getAchievements().getTotal();
                        boolean focusDisplay = displayAchieve.contains(this.focusedAchievement) || this.focusedAchievement.getGoal() != null && this.focusedAchievement.getGoal() == 1L;
                        boolean bl = hoverDisplay = displayAchieve.contains(this.hoveredAchievement) || this.hoveredAchievement.getGoal() != null && this.hoveredAchievement.getGoal() == 1L;
                        if (focusDisplay == hoverDisplay && focusDisplay) {
                            int focusIndex = displayAchieve.indexOf(this.focusedAchievement);
                            int hoverIndex = displayAchieve.indexOf(this.hoveredAchievement);
                            displayAchieve.remove(this.focusedAchievement);
                            if (hoverIndex > -1) {
                                displayAchieve.add(hoverIndex, this.focusedAchievement);
                                displayAchieve.remove(this.hoveredAchievement);
                                displayAchieve.add(focusIndex, this.hoveredAchievement);
                            } else {
                                displayAchieve.add(this.focusedAchievement);
                            }
                        } else if (focusDisplay != hoverDisplay) {
                            if (focusDisplay) {
                                int totalIndex;
                                int focusIndex = displayAchieve.indexOf(this.focusedAchievement);
                                displayAchieve.remove(this.focusedAchievement);
                                for (totalIndex = 0; totalIndex < totalAchieve.size() && !totalAchieve.get(totalIndex).getDate().before(this.focusedAchievement.getDate()); ++totalIndex) {
                                }
                                totalAchieve.add(totalIndex, this.focusedAchievement);
                                if (totalAchieve.contains(this.hoveredAchievement)) {
                                    totalAchieve.remove(this.hoveredAchievement);
                                    displayAchieve.add(focusIndex, this.hoveredAchievement);
                                }
                            } else {
                                int hoverIndex = displayAchieve.indexOf(this.hoveredAchievement);
                                totalAchieve.remove(this.focusedAchievement);
                                if (hoverIndex > -1) {
                                    displayAchieve.add(hoverIndex, this.focusedAchievement);
                                } else {
                                    displayAchieve.add(this.focusedAchievement);
                                }
                                if (displayAchieve.contains(this.hoveredAchievement)) {
                                    int totalIndex;
                                    for (totalIndex = 0; totalIndex < totalAchieve.size() && !totalAchieve.get(totalIndex).getDate().before(this.hoveredAchievement.getDate()); ++totalIndex) {
                                    }
                                    displayAchieve.remove(this.hoveredAchievement);
                                    totalAchieve.add(totalIndex, this.hoveredAchievement);
                                }
                            }
                        }
                        this.focusedAchievement = null;
                    }
                }
            } else {
                this.focusedAchievement = null;
            }
        }
        if (this.playerProfile != null && this.flagPosition != null && this.flagPosition.method_1008(mouseX, mouseY, 0.0)) {
            ClientUtils.playSound(class_3417.field_15015, 1.0f, 0.25f);
            this.openScreen(new EloLeaderboardScreen((class_437)this, this.playerProfile.getCountry()));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25419() {
        if (this.originalAchievements != null) {
            ArrayList original = Lists.newArrayList();
            original.addAll(this.originalAchievements.getDisplay());
            original.addAll(this.originalAchievements.getTotal());
            StringBuilder result = new StringBuilder();
            for (PlayerAchievement achievement : this.playerProfile.getAchievements().getDisplay()) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(original.indexOf(achievement));
                original.remove(achievement);
            }
            SocketInstance.getInstance().emit("p$reorder_badge", result);
            ClientUtils.deleteApiResponseCache("users/" + this.query);
        }
        super.method_25419();
    }

    private void initTabButtons() {
        FreeSizeButtonWidget generalButton = new FreeSizeButtonWidget(-3, 0, this.tabWidth, 39, class_2585.field_24366, button -> this.getPagination().setPage(0));
        this.getPagination().setPageSelectButton(0, generalButton);
        FreeSizeButtonWidget statsButton = new FreeSizeButtonWidget(-3, 39, this.tabWidth, 39, class_2585.field_24366, button -> this.getPagination().setPage(1));
        this.getPagination().setPageSelectButton(1, statsButton);
        FreeSizeButtonWidget matchesButton = new FreeSizeButtonWidget(-3, 78, this.tabWidth, 39, class_2585.field_24366, button -> {
            BasePlayer targetProfile;
            BasePlayer basePlayer = targetProfile = this.query.equals(MCSRRankedClient.LOCAL_PLAYER.getUUIDString()) ? MCSRRankedClient.LOCAL_PLAYER : this.playerProfile;
            if (targetProfile != null) {
                this.openScreen(new UserMatchListScreen((class_437)this, targetProfile));
            }
        });
        this.getPagination().setPageSelectButton(2, matchesButton);
        FreeSizeButtonWidget achievementButton = new FreeSizeButtonWidget(-3, 117, this.tabWidth, 39, class_2585.field_24366, button -> this.getPagination().setPage(4));
        this.getPagination().setPageSelectButton(4, achievementButton);
        this.profileSettingsButton = new FreeSizeButtonWidget(-3, 156, this.tabWidth, 39, class_2585.field_24366, button -> this.getPagination().setPage(3));
        this.profileSettingsButton.field_22764 = false;
        this.getPagination().setPageSelectButton(3, this.profileSettingsButton);
        this.method_25411((class_339)new FreeSizeButtonWidget(-3, this.field_22790 - 26, this.tabWidth, 26, (class_2561)RankedScreenTexts.BACK.text(), button -> this.method_25419()));
    }

    private void renderTabIcons(class_4587 matrixStack) {
        if (this.field_22787 == null) {
            return;
        }
        class_339 targetButton = this.getPagination().getPageSelectButton(0);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.0f);
        this.field_22787.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8367), (int)((double)targetButton.method_25368() / 2.4 - 11.0), (int)((float)(targetButton.field_22761 + 5) / 1.2f));
        RenderSystem.popMatrix();
        this.drawCenteredTextWithShadow(matrixStack, this.field_22793, (class_5348)RankedScreenTexts.GENERAL.text(), targetButton.method_25368() / 2 - 3, targetButton.field_22761 + 25, 0xFFFFFF);
        targetButton = this.getPagination().getPageSelectButton(1);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)-1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.0f);
        this.field_22787.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8251), (int)((double)targetButton.method_25368() / 2.4 - 11.0), (int)((float)(targetButton.field_22761 + 5) / 1.2f));
        RenderSystem.popMatrix();
        this.drawCenteredTextWithShadow(matrixStack, this.field_22793, (class_5348)RankedScreenTexts.STATS.text(), targetButton.method_25368() / 2 - 3, targetButton.field_22761 + 25, 0xFFFFFF);
        targetButton = this.getPagination().getPageSelectButton(2);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)-1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.0f);
        this.field_22787.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8674), (int)((double)targetButton.method_25368() / 2.4 - 11.0), (int)((float)(targetButton.field_22761 + 5) / 1.2f));
        RenderSystem.popMatrix();
        this.drawCenteredTextWithShadow(matrixStack, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.matches"), targetButton.method_25368() / 2 - 3, targetButton.field_22761 + 25, 0xFFFFFF);
        targetButton = this.getPagination().getPageSelectButton(4);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)-1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.0f);
        this.field_22787.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8137), (int)((double)targetButton.method_25368() / 2.4 - 11.0), (int)((float)(targetButton.field_22761 + 5) / 1.2f));
        RenderSystem.popMatrix();
        this.drawCenteredTextWithShadow(matrixStack, this.field_22793, (class_5348)new class_2588("projectelo.text.achievement"), targetButton.method_25368() / 2 - 3, targetButton.field_22761 + 25, 0xFFFFFF);
        targetButton = this.getPagination().getPageSelectButton(3);
        if (targetButton.field_22764) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)1.2f, (float)1.2f, (float)1.0f);
            this.field_22787.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8220), (int)((double)targetButton.method_25368() / 2.4 - 11.0), (int)((float)(targetButton.field_22761 + 5) / 1.2f));
            RenderSystem.popMatrix();
            this.drawCenteredTextWithShadow(matrixStack, this.field_22793, (class_5348)new class_2588("projectelo.button.settings"), targetButton.method_25368() / 2 - 3, targetButton.field_22761 + 25, 0xFFFFFF);
        }
    }

    private void initCurrentTab() {
        if (this.playerProfile == null) {
            return;
        }
        int connections = 0;
        if (this.playerProfile.getConnections().containsKey("twitch")) {
            this.getPagination().addElement(0, new FreeSizeTexturedButtonWidget(this.field_22789 - 30, 62, 20, 20, 0, 0, 64, 64, TWITCH_ICON, 64, 64, button -> class_156.method_668().method_670("https://www.twitch.tv/" + this.playerProfile.getConnections().get("twitch").getId()), (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, Lists.newArrayList((Object[])new class_2561[]{class_2561.method_30163((String)("Twitch: " + this.playerProfile.getConnections().get("twitch").getName())), new class_2588("projectelo.tooltip.click_to_open_url")}), mouseX, mouseY)));
            ++connections;
        }
        if (this.playerProfile.getConnections().containsKey("youtube")) {
            this.getPagination().addElement(0, new FreeSizeTexturedButtonWidget(this.field_22789 - 30 - connections * 24, 62, 20, 20, 0, 0, 64, 64, YOUTUBE_ICON, 64, 64, button -> class_156.method_668().method_670("https://www.youtube.com/channel/" + this.playerProfile.getConnections().get("youtube").getId()), (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, Lists.newArrayList((Object[])new class_2561[]{class_2561.method_30163((String)("YouTube: " + this.playerProfile.getConnections().get("youtube").getName())), new class_2588("projectelo.tooltip.click_to_open_url")}), mouseX, mouseY)));
            ++connections;
        }
        if (this.playerProfile.getConnections().containsKey("discord")) {
            FreeSizeTexturedButtonWidget discordButton = new FreeSizeTexturedButtonWidget(this.field_22789 - 30 - connections * 24, 62, 20, 20, 0, 0, 64, 64, DISCORD_ICON, 64, 64, button -> {}, (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)class_2561.method_30163((String)this.playerProfile.getConnections().get("discord").getName()), mouseX, mouseY));
            discordButton.field_22763 = false;
            this.getPagination().addElement(0, discordButton);
        }
        Supplier<class_2561> countryText = () -> new class_2588("projectelo.tooltip.selected_country").method_27693(": ").method_10852((class_2561)(this.playerProfile.getCountry() == null ? RankedScreenTexts.NONE.text() : new class_2585(this.playerProfile.getCountry().getLocaleName())));
        this.getPagination().addElement(3, new FreeSizeButtonWidget(this.tabWidth + 10, 62, this.field_22789 - this.tabWidth - 30, 20, countryText.get(), button -> this.getClient().method_1507((class_437)new CountrySelectScreen((class_437)this, arg_0 -> this.lambda$initCurrentTab$21(button, (Supplier)countryText, arg_0)))));
        this.createConnectionButtons("patreon", "Patreon", 86, false);
        this.createConnectionButtons("discord", "Discord", 110, true);
        this.createConnectionButtons("twitch", "Twitch", 134, true);
        this.createConnectionButtons("youtube", "YouTube", 158, true);
        this.getPagination().addElement(3, new FreeSizeButtonWidget(this.tabWidth + 10 + (this.field_22789 - (this.tabWidth + 30)) / 2 - 100, 182, 200, 20, (class_2561)new class_2588("projectelo.button.generate_private_key"), button -> {
            button.field_22763 = false;
            SocketInstance.getInstance().emit("p$private_key", new Object[0]);
        }, (button, matrices, mouseX, mouseY) -> this.setTooltipWithWrap(new class_2588("projectelo.tooltip.generate_api_private_key"), 250)));
        this.getPagination().setPreRenderPage(0, (matrices, mouseX, mouseY, delta) -> this.renderCurrentTab(0, matrices, mouseX, mouseY, delta));
        this.getPagination().setPreRenderPage(1, (matrices, mouseX, mouseY, delta) -> this.renderCurrentTab(1, matrices, mouseX, mouseY, delta));
        this.getPagination().setPreRenderPage(3, (matrices, mouseX, mouseY, delta) -> this.renderCurrentTab(3, matrices, mouseX, mouseY, delta));
        this.getPagination().setPreRenderPage(4, (matrices, mouseX, mouseY, delta) -> this.renderCurrentTab(4, matrices, mouseX, mouseY, delta));
    }

    private void createConnectionButtons(String oauthType, String display, int y, boolean canPublic) {
        if (MCSRRankedClient.PLAYER_CONNECTIONS.getConnection(oauthType) == null) {
            this.getPagination().addElement(3, new class_4185(this.field_22789 - 120, y, 100, 20, (class_2561)new class_2588("projectelo.button.link_third_party", new Object[]{display}), button -> {
                SocketInstance.getInstance().emit("p$create_token", oauthType);
                button.field_22763 = false;
            }));
        } else {
            if (canPublic) {
                Supplier<class_2561> publicTextSupplier = () -> new class_2588("projectelo.button.public_third_party").method_27693(": ").method_10852((class_2561)(MCSRRankedClient.PLAYER_CONNECTIONS.getConnection(oauthType).isVisible() ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text()));
                this.getPagination().addElement(3, new class_4185(this.field_22789 - 182, y, 60, 20, publicTextSupplier.get(), button -> {
                    boolean isVisible = MCSRRankedClient.PLAYER_CONNECTIONS.getConnection(oauthType).isVisible();
                    MCSRRankedClient.PLAYER_CONNECTIONS.getConnection(oauthType).setVisible(!isVisible);
                    SocketInstance.getInstance().emit("p$connection_public", oauthType, !isVisible);
                    button.method_25355((class_2561)publicTextSupplier.get());
                    ClientUtils.deleteApiResponseCache("users/" + this.query);
                }, (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, this.field_22793.method_1728((class_5348)new class_2588("projectelo.button.public_third_party.description", new Object[]{display}), this.field_22789 / 2), mouseX, mouseY)));
            }
            this.getPagination().addElement(3, new class_4185(this.field_22789 - 120, y, 100, 20, (class_2561)new class_2588("projectelo.button.unlink_third_party", new Object[]{display}), button -> {
                SocketInstance.getInstance().emit("p$connection_unlink", oauthType);
                button.field_22763 = false;
            }));
        }
    }

    private int getAchievementColumnPerPage() {
        int minX = this.tabWidth + 60;
        int maxX = this.field_22789 - 60;
        return (maxX - minX) / 36;
    }

    private int getAchievementRowPerPage() {
        return (this.field_22790 - 38 - 134) / 34;
    }

    private void initAchievementButtons() {
        this.achievementPage = 1;
        this.achievementMaxPage = class_3532.method_15340((int)class_3532.method_15386((float)((float)this.playerProfile.getAchievements().getTotal().size() / ((float)(this.getAchievementColumnPerPage() * this.getAchievementRowPerPage()) * 1.0f))), (int)1, (int)999);
        Runnable pageUpdate = () -> {
            this.achievementPrevButton.field_22763 = this.achievementPage > 1;
            this.achievementNextButton.field_22763 = this.achievementPage < this.achievementMaxPage;
        };
        this.achievementPrevButton = new FreeSizeButtonWidget(this.tabWidth + 30, 122 + (this.field_22790 - 182) / 2, 20, 40, class_2561.method_30163((String)"<"), button -> {
            --this.achievementPage;
            pageUpdate.run();
        });
        this.getPagination().addElement(4, this.achievementPrevButton);
        this.achievementNextButton = new FreeSizeButtonWidget(this.field_22789 - 50, 122 + (this.field_22790 - 182) / 2, 20, 40, class_2561.method_30163((String)">"), button -> {
            ++this.achievementPage;
            pageUpdate.run();
        });
        this.getPagination().addElement(4, this.achievementNextButton);
        pageUpdate.run();
    }

    private void renderCurrentTab(int page, class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.hoveredAchievement = null;
        if (this.playerProfile == null) {
            return;
        }
        if (page == 0) {
            class_5250 createdTimeText = new class_2588("projectelo.text.profile.created_time").method_27693(" : ").method_10852((class_2561)new class_2585(ClientUtils.timeToDurationFormat(this.playerProfile.getTimestamp().getFirstOnline())).method_27692(class_124.field_1056));
            this.method_27535(matrices, this.field_22793, (class_5348)createdTimeText, this.tabWidth + 10, 66, 0xFFFFFF);
            class_5250 latestTimeText = new class_2588("projectelo.text.profile.latest_time").method_27693(" : ").method_10852((class_2561)new class_2585(ClientUtils.timeToDurationFormat(this.playerProfile.getTimestamp().getLastOnline())).method_27692(class_124.field_1056));
            this.method_27535(matrices, this.field_22793, (class_5348)latestTimeText, this.tabWidth + 10, 76, 0xFFFFFF);
            long playerPB = Optional.ofNullable(this.playerProfile.getTotalStatistics().getBestTime()).map(PlayerStatistics.Element::getRanked).orElse(0L);
            class_5250 bestTimeText = new class_2588("projectelo.text.profile.best_record_time").method_27693(" : ").method_10852((class_2561)new class_2585(playerPB == 0L ? "-" : InGameTimerUtils.timeToStringFormat((long)playerPB)).method_27692(class_124.field_1056));
            this.method_27535(matrices, this.field_22793, (class_5348)bestTimeText, this.tabWidth + 10, 86, 0xFFFFFF);
            if (this.playerProfile.getTimestamp().getNextDecay() != null) {
                int decayTextX = this.field_22789 - 10;
                int decayTextY = 86;
                class_5250 decayTimeText = new class_2588("projectelo.text.profile.decay_timer").method_27693(" : ").method_10852((class_2561)new class_2585(ClientUtils.timeToHourDurationFormat(this.playerProfile.getTimestamp().getNextDecay()) + "/" + MCSRRankedClient.MATCH_ARGUMENT.getDecayHours() + "h").method_27692(class_124.field_1056));
                this.method_27535(matrices, this.field_22793, (class_5348)decayTimeText, decayTextX - this.field_22793.method_27525((class_5348)decayTimeText), decayTextY, 0xFFFFFF);
                if (decayTextX - this.field_22793.method_27525((class_5348)decayTimeText) <= mouseX && decayTextX > mouseX && decayTextY <= mouseY && decayTextY + 9 > mouseY) {
                    this.setTooltip(Lists.newArrayList((Object[])new class_5250[]{new class_2588("projectelo.text.next_decay_at").method_10852((class_2561)new class_2585(": " + ClientUtils.getDateFormat(new Date(this.playerProfile.getTimestamp().getNextDecay()), false))), new class_2588("projectelo.text.decay_timer_add").method_27692(class_124.field_1054)}));
                }
            }
            if (this.chartWidget != null) {
                this.chartWidget.method_25394(matrices, mouseX, mouseY, delta);
                List<class_5348> chartToolTip = this.chartWidget.getTargetToolTip();
                this.setTooltip(chartToolTip);
            }
            int achievesSize = this.playerProfile.getAchievements().getDisplay().size();
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.achievement_badges").method_27692(class_124.field_1067), (this.field_22789 + this.tabWidth) / 2, this.field_22790 - 66, 0xFFFFFF);
            if (achievesSize == 0) {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)RankedScreenTexts.NONE.text().method_27693(" :("), (this.field_22789 + this.tabWidth) / 2, this.field_22790 - 46, 0xFFFFFF);
            }
            Supplier<List> hoverAchievement = null;
            for (int i = 0; i < achievesSize; ++i) {
                PlayerAchievement achievement = this.playerProfile.getAchievements().getDisplay().get(i);
                int achieveX = (this.field_22789 + this.tabWidth) / 2 - achievesSize % 2 * 16 + (i - achievesSize / 2) * 34;
                int achieveY = this.field_22790 - 52;
                AchievementWorker worker = AchievementManager.getWorker(achievement);
                worker.renderIcon(matrices, achieveX, achieveY, achievement);
                if (!worker.isMouseOver(achieveX, achieveY, mouseX, mouseY, 1.0f)) continue;
                hoverAchievement = () -> worker.getTooltips(achievement);
            }
            if (hoverAchievement != null) {
                this.method_25417(matrices, (List)hoverAchievement.get(), mouseX, mouseY);
            }
        } else if (page == 1) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)16.0f, (float)0.0f);
            class_332.method_25294((class_4587)matrices, (int)((this.field_22789 + this.tabWidth) / 2 - 135), (int)(this.field_22790 / 2 - 56), (int)((this.field_22789 + this.tabWidth) / 2 + 138), (int)(this.field_22790 / 2 + 2), (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.ranked_statistics").method_27692(class_124.field_1067), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2 - 50, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.total_played").method_27693(": (").method_10852((class_2561)new class_2585("").method_10852((class_2561)new class_2585(String.valueOf(this.playerProfile.getTotalStatistics().getPlayedMatches().getRanked())).method_27692(class_124.field_1075)).method_27693(" / ").method_10852((class_2561)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getPlayedMatches().getRanked())).method_27692(class_124.field_1054))).method_27693(")"), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2 - 38, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.highest_winstreak").method_27693(": (").method_10852((class_2561)new class_2585("").method_10852((class_2561)new class_2585(String.valueOf(this.playerProfile.getTotalStatistics().getHighestWinStreak().getRanked())).method_27692(class_124.field_1075)).method_27693(" / ").method_10852((class_2561)new class_2585(String.valueOf(this.playerProfile.getTotalStatistics().getCurrentWinStreak().getRanked())).method_27692(class_124.field_1054))).method_27693(")"), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2 - 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.best_elo_rate").method_27693(": (").method_10852((class_2561)new class_2585("").method_10852((class_2561)new class_2585(Optional.ofNullable(this.playerProfile.getSeasonResult()).map(PlayerSeasonResult::getHighestElo).map(String::valueOf).orElse("-")).method_27692(class_124.field_1075)).method_27693(" / ").method_10852((class_2561)new class_2585(Optional.ofNullable(this.playerProfile.getSeasonResult()).map(PlayerSeasonResult::getLowestElo).map(String::valueOf).orElse("-")).method_27692(class_124.field_1054))).method_27693(")"), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2 - 14, 0xFFFFFF);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)32.0f, (float)0.0f);
            class_332.method_25294((class_4587)matrices, (int)((this.field_22789 + this.tabWidth) / 2 - 135), (int)(this.field_22790 / 2 - 4), (int)((this.field_22789 + this.tabWidth) / 2 + 138), (int)(this.field_22790 / 2 + 54), (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.player_records").method_27692(class_124.field_1067), (this.field_22789 + this.tabWidth) / 2, this.field_22790 / 2 + 2, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585("-"), (this.field_22789 + this.tabWidth) / 2 - 82, this.field_22790 / 2 + 14, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.matchtype.ranked"), (this.field_22789 + this.tabWidth) / 2 - 82, this.field_22790 / 2 + 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.matchtype.casual"), (this.field_22789 + this.tabWidth) / 2 - 82, this.field_22790 / 2 + 38, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.matches").method_27692(class_124.field_1073), (this.field_22789 + this.tabWidth) / 2 - 22, this.field_22790 / 2 + 14, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getPlayedMatches().getRanked())).method_27692(class_124.field_1054), (this.field_22789 + this.tabWidth) / 2 - 22, this.field_22790 / 2 + 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getPlayedMatches().getCasual())).method_27692(class_124.field_1054), (this.field_22789 + this.tabWidth) / 2 - 22, this.field_22790 / 2 + 38, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.win").method_27692(class_124.field_1073), (this.field_22789 + this.tabWidth) / 2 + 18, this.field_22790 / 2 + 14, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getWins().getRanked())).method_27692(class_124.field_1060), (this.field_22789 + this.tabWidth) / 2 + 18, this.field_22790 / 2 + 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getWins().getCasual())).method_27692(class_124.field_1060), (this.field_22789 + this.tabWidth) / 2 + 18, this.field_22790 / 2 + 38, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.loss").method_27692(class_124.field_1073), (this.field_22789 + this.tabWidth) / 2 + 58, this.field_22790 / 2 + 14, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getLoses().getRanked())).method_27692(class_124.field_1061), (this.field_22789 + this.tabWidth) / 2 + 58, this.field_22790 / 2 + 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(String.valueOf(this.playerProfile.getSeasonStatistics().getLoses().getCasual())).method_27692(class_124.field_1061), (this.field_22789 + this.tabWidth) / 2 + 58, this.field_22790 / 2 + 38, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.profile.winrates").method_27692(class_124.field_1073), (this.field_22789 + this.tabWidth) / 2 + 98, this.field_22790 / 2 + 14, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585((int)((float)this.playerProfile.getSeasonStatistics().getWins().getRanked().longValue() * 1.0f / (float)(this.playerProfile.getSeasonStatistics().getWins().getRanked() + this.playerProfile.getSeasonStatistics().getLoses().getRanked()) * 100.0f) + "%").method_27692(class_124.field_1075), (this.field_22789 + this.tabWidth) / 2 + 98, this.field_22790 / 2 + 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585((int)((float)this.playerProfile.getSeasonStatistics().getWins().getCasual().longValue() * 1.0f / (float)(this.playerProfile.getSeasonStatistics().getWins().getCasual() + this.playerProfile.getSeasonStatistics().getLoses().getCasual()) * 100.0f) + "%").method_27692(class_124.field_1075), (this.field_22789 + this.tabWidth) / 2 + 98, this.field_22790 / 2 + 38, 0xFFFFFF);
            RenderSystem.popMatrix();
        } else if (page == 3) {
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.button.link_third_party", new Object[]{"Patreon"}).method_27693(this.getConnectionInfo("patreon")), this.tabWidth + 10, 92, 0xFFFFFF);
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.button.link_third_party", new Object[]{"Discord"}).method_27693(this.getConnectionInfo("discord")), this.tabWidth + 10, 116, 0xFFFFFF);
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.button.link_third_party", new Object[]{"Twitch"}).method_27693(this.getConnectionInfo("twitch")), this.tabWidth + 10, 140, 0xFFFFFF);
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.button.link_third_party", new Object[]{"YouTube"}).method_27693(this.getConnectionInfo("youtube")), this.tabWidth + 10, 164, 0xFFFFFF);
        } else if (page == 4) {
            class_332.method_25294((class_4587)matrices, (int)(this.tabWidth + 20), (int)70, (int)(this.field_22789 - 20), (int)120, (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
            class_332.method_25294((class_4587)matrices, (int)(this.tabWidth + 20), (int)124, (int)(this.field_22789 - 20), (int)(this.field_22790 - 20), (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.achievement_badges").method_27692(class_124.field_1054), (this.field_22789 + this.tabWidth) / 2, 73, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.all_achievements").method_27693(String.format(" (%s/%s)", this.achievementPage, this.achievementMaxPage)), (this.field_22789 + this.tabWidth) / 2, this.field_22790 - 31, 0xFFFFFF);
            if (this.playerProfile.isMe()) {
                this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.change_achievement_place").method_27692(class_124.field_1075), (this.field_22789 + this.tabWidth) / 2, this.field_22790 - 14, 0xFFFFFF);
            }
            List<PlayerAchievement> displayAchieves = this.playerProfile.getAchievements().getDisplay();
            int achieveSlots = this.playerProfile.isMe() ? this.playerProfile.getMaxAchievements() : displayAchieves.size();
            int achieveWidth = achieveSlots * 36 - 4;
            int achieveIndex = 0;
            for (int i = 0; i < achieveSlots; ++i) {
                int achieveY;
                int achieveX;
                PlayerAchievement playerAchievement = i < displayAchieves.size() ? displayAchieves.get(i) : new PlayerAchievement("empty", 0, new String[0], i, 1L, 0L);
                boolean focused = playerAchievement.equals(this.focusedAchievement);
                AchievementWorker worker = AchievementManager.getWorker(playerAchievement);
                if (worker.isMouseOver(achieveX = (this.field_22789 + this.tabWidth - achieveWidth) / 2 + achieveIndex++ * 36, achieveY = 84, mouseX, mouseY, 1.0f) && !focused) {
                    if (worker == AchievementManager.EMPTY) {
                        this.setTooltip(new class_2588("projectelo.text.empty_achievement_place.description"));
                    } else {
                        this.setTooltip(worker.getTooltips(playerAchievement));
                    }
                    this.hoveredAchievement = playerAchievement;
                }
                if (focused) continue;
                worker.renderIcon(matrices, achieveX, achieveY, playerAchievement);
            }
            List<PlayerAchievement> allAchieves = this.playerProfile.getAchievements().getTotal();
            int columnCount = this.getAchievementColumnPerPage();
            int rowCount = this.getAchievementRowPerPage();
            int pageCount = columnCount * rowCount;
            int pendingX = (this.field_22789 - 60 - (this.tabWidth + 60) - (columnCount * 36 - 4)) / 2;
            for (int i = 0; i <= allAchieves.size(); ++i) {
                if (i < (this.achievementPage - 1) * pageCount || i >= this.achievementPage * pageCount || i == allAchieves.size() && !this.playerProfile.isMe()) continue;
                PlayerAchievement playerAchievement = i < allAchieves.size() ? allAchieves.get(i) : new PlayerAchievement("empty", 0, new String[0], i, 0L, 0L);
                boolean focused = playerAchievement.equals(this.focusedAchievement);
                AchievementWorker worker = AchievementManager.getWorker(playerAchievement);
                if (worker == null) continue;
                int columnIndex = i % columnCount;
                int achieveX = this.tabWidth + 60 + pendingX + columnIndex * 36;
                int rowIndex = i % pageCount / columnCount;
                int achieveY = 134 + rowIndex * 34;
                if (worker.isMouseOver(achieveX, achieveY, mouseX, mouseY, 1.0f) && !focused) {
                    if (worker == AchievementManager.EMPTY) {
                        this.setTooltip(new class_2588("projectelo.text.empty_achievement_place.description"));
                    } else {
                        this.setTooltip(worker.getTooltips(playerAchievement));
                    }
                    this.hoveredAchievement = playerAchievement;
                }
                if (focused) continue;
                worker.renderIcon(matrices, achieveX, achieveY, playerAchievement);
            }
            if (this.focusedAchievement != null) {
                AchievementWorker worker = AchievementManager.getWorker(this.focusedAchievement);
                worker.renderIcon(matrices, mouseX - 16, mouseY - 16, this.focusedAchievement);
            }
        }
    }

    private String getConnectionInfo(String type) {
        PlayerConnections.Connection connection = MCSRRankedClient.PLAYER_CONNECTIONS.getConnection(type);
        if (connection == null || connection.getName() == null) {
            return "";
        }
        StringBuilder censored = new StringBuilder();
        String name = connection.getName();
        for (int i = 0; i < name.length(); ++i) {
            if (i < 2 || i > name.length() - 2 || name.charAt(i) == ' ') {
                censored.append(name.charAt(i));
                continue;
            }
            censored.append("*");
        }
        return " (" + censored + ")";
    }

    private /* synthetic */ void lambda$initCurrentTab$21(class_4185 button, Supplier countryText, PlayerCountry country) {
        this.playerProfile.setCountryCode(country == null ? null : country.getCode());
        SocketInstance.getInstance().emit("p$country_update", country == null ? "" : country.getCode());
        button.method_25355((class_2561)countryText.get());
    }
}

