/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match;

import com.google.common.collect.Lists;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.match.TimelineUpdateListener;
import com.mcsrranked.client.gui.widget.MatchPlayerListSelectWidget;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.datafixers.util.Pair;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MatchSplitScreen<T extends BasePlayer>
extends RankedScreen
implements TimelineUpdateListener {
    private final List<MatchTimeline> timelines = Lists.newCopyOnWriteArrayList();
    private final List<T> players;
    private MatchPlayerListSelectWidget<T> playerListWidget;
    private Pair<T, T> playerPair = new Pair(null, null);
    private boolean latestWasLeft = false;

    public MatchSplitScreen(class_437 parent, List<MatchTimeline> initTimelines, List<T> players) {
        super(parent, (class_2561)new class_2588("projectelo.title.match_splits"));
        this.timelines.addAll(initTimelines.stream().sorted((t1, t2) -> Math.toIntExact(t2.getTime() - t1.getTime())).collect(Collectors.toList()));
        this.players = players;
    }

    @Override
    public void onAddNewTimeline(MatchTimeline timeline) {
        this.timelines.add(0, timeline);
    }

    private void onSelectedPlayer(T player) {
        this.playerListWidget.setVisible(false);
        this.playerPair = new Pair(this.latestWasLeft ? player : (BasePlayer)this.playerPair.getFirst(), !this.latestWasLeft ? player : (BasePlayer)this.playerPair.getSecond());
        for (class_339 button : this.field_22791) {
            button.field_22764 = true;
        }
    }

    private void startSelectPlayer(boolean left) {
        this.latestWasLeft = left;
        this.method_25429((class_364)this.playerListWidget);
        this.playerListWidget.selectPreviousEntry(left ? (BasePlayer)this.playerPair.getFirst() : (BasePlayer)this.playerPair.getSecond());
        this.playerListWidget.setVisible(true);
        for (class_339 button : this.field_22791) {
            button.field_22764 = false;
        }
    }

    protected void method_25426() {
        this.playerListWidget = new MatchPlayerListSelectWidget<BasePlayer>(this.field_22787, this.field_22789, this.field_22790, this.players, this::onSelectedPlayer, true);
        this.playerListWidget.setVisible(false);
        this.method_25411((class_339)new class_4185(this.field_22789 / 4 - 75, 40, 150, 20, (class_2561)new class_2588("projectelo.button.change_player", new Object[]{1}), button -> this.startSelectPlayer(true)));
        this.method_25411((class_339)new class_4185(this.field_22789 / 4 * 3 - 75, 40, 150, 20, (class_2561)new class_2588("projectelo.button.change_player", new Object[]{2}), button -> this.startSelectPlayer(false)));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean shouldRenderMatchHud() {
        return false;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25434(0);
        if (this.playerListWidget.isVisible()) {
            this.playerListWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, 16, 0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (!this.playerListWidget.isVisible()) {
            int nicknameX;
            BasePlayer firstPlayer = (BasePlayer)this.playerPair.getFirst();
            BasePlayer secondPlayer = (BasePlayer)this.playerPair.getSecond();
            if (firstPlayer != null) {
                nicknameX = this.field_22789 / 4 - (10 + BasePlayer.getNicknameWidth(firstPlayer)) / 2;
                RenderUtils.renderPlayerHead(firstPlayer.getUUID(), matrices, nicknameX, 64, 8, 8);
                BasePlayer.renderNickname(matrices, nicknameX + 10, 64, firstPlayer, this, mouseX, mouseY);
            } else {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)RankedScreenTexts.NONE.text(), this.field_22789 / 4, 64, 0xFFFFFF);
            }
            if (secondPlayer != null) {
                nicknameX = this.field_22789 / 4 * 3 - (10 + BasePlayer.getNicknameWidth(secondPlayer)) / 2;
                RenderUtils.renderPlayerHead(secondPlayer.getUUID(), matrices, nicknameX, 64, 8, 8);
                BasePlayer.renderNickname(matrices, nicknameX + 10, 64, secondPlayer, this, mouseX, mouseY);
            } else {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)RankedScreenTexts.NONE.text(), this.field_22789 / 4 * 3, 64, 0xFFFFFF);
            }
            int rowCount = 6;
            int margin = 16;
            int maxRowCount = 0;
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_nether"), "story.enter_the_nether", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_bastion"), "nether.find_bastion", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_fortress"), "nether.find_fortress", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.blinded"), "projectelo.timeline.blind_travel", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.eye_spy"), "story.follow_ender_eye", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_end"), "story.enter_the_end", this.field_22790 / 2 + 16 + (maxRowCount++ - 3) * 16);
            this.field_22786.remove(this.playerListWidget);
        }
    }

    private void renderSplitTexts(class_4587 matrices, class_5250 display, String advancementID, int y) {
        BasePlayer firstPlayer = (BasePlayer)this.playerPair.getFirst();
        BasePlayer secondPlayer = (BasePlayer)this.playerPair.getSecond();
        Long firstTime = null;
        Long secondTime = null;
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)display.method_27692(class_124.field_1075), this.field_22789 / 2, y, 0xFFFFFF);
        if (firstPlayer != null) {
            for (MatchTimeline timeline2 : this.timelines.stream().filter(timeline -> timeline.getUUID().equals(firstPlayer.getUUID())).collect(Collectors.toList())) {
                if (Objects.equals(timeline2.getType(), advancementID)) {
                    firstTime = timeline2.getTime();
                    break;
                }
                if (!timeline2.isReset()) continue;
                break;
            }
        }
        if (secondPlayer != null) {
            for (MatchTimeline timeline2 : this.timelines.stream().filter(timeline -> timeline.getUUID().equals(secondPlayer.getUUID())).collect(Collectors.toList())) {
                if (Objects.equals(timeline2.getType(), advancementID)) {
                    secondTime = timeline2.getTime();
                    break;
                }
                if (!timeline2.isReset()) continue;
                break;
            }
        }
        if (firstTime != null) {
            long differentTime = secondTime == null ? -1L : firstTime - secondTime;
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)firstTime)).method_10852((class_2561)(secondTime == null ? class_2585.field_24366 : new class_2585(" (" + (differentTime < 0L ? "-" : "+") + InGameTimerUtils.timeToStringFormat((long)Math.abs(differentTime)) + ")").method_27692(differentTime < 0L ? class_124.field_1060 : (differentTime > 0L ? class_124.field_1061 : class_124.field_1054)))), this.field_22789 / 4, y, 0xFFFFFF);
        }
        if (secondTime != null) {
            long differentTime = firstTime == null ? -1L : secondTime - firstTime;
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)secondTime)).method_10852((class_2561)(firstTime == null ? class_2585.field_24366 : new class_2585(" (" + (differentTime < 0L ? "-" : "+") + InGameTimerUtils.timeToStringFormat((long)Math.abs(differentTime)) + ")").method_27692(differentTime < 0L ? class_124.field_1060 : (differentTime > 0L ? class_124.field_1061 : class_124.field_1054)))), this.field_22789 / 4 * 3, y, 0xFFFFFF);
        }
    }
}

