/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match.replay;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.cinematic.CinematicCamera;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.ModOptionScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.options.OptionSliderWidget;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchSplitTime;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.PlayLog;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.datafixers.util.Pair;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.server.MinecraftServer;

public class LiveReplayTargetScreen
extends RankedScreen {
    private PlayersWidget playersWidget;
    private final Collection<Pair<BasePlayer, MatchSplitTime>> packages;

    public LiveReplayTargetScreen(class_437 parent, ReplayProcessor replayProcessor) {
        super(parent, (class_2561)new class_2588("projectelo.title.live_replay_settings"));
        ArrayList packageList = Lists.newArrayList();
        for (BasePlayer player : replayProcessor.getPlayers()) {
            if (!replayProcessor.getTracker(player.getUUID()).isPresent()) continue;
            OpponentPlayerTracker tracker = replayProcessor.getTracker(player.getUUID()).get();
            MatchSplitTime splitData = tracker.getMatchSplitData(replayProcessor.getCurrentTicks());
            packageList.add(new Pair((Object)player, (Object)splitData));
        }
        packageList.sort(Comparator.comparing(Pair::getSecond));
        this.packages = packageList;
    }

    public LiveReplayTargetScreen(class_437 parent, OnlineMatch onlineMatch) {
        super(parent, (class_2561)new class_2588("projectelo.title.live_replay_settings"));
        ArrayList packageList = Lists.newArrayList();
        for (OnlinePlayer onlinePlayer : onlineMatch.getPlayersExcludeSpectator()) {
            PlayLog playLog = onlineMatch.getPlayLog(onlinePlayer);
            MatchSplitTime split = playLog.getLastSplitData();
            packageList.add(new Pair((Object)onlinePlayer, (Object)split));
        }
        packageList.sort(Comparator.comparing(Pair::getSecond));
        this.packages = packageList;
    }

    protected void method_25426() {
        this.playersWidget = new PlayersWidget(this.field_22787, this.field_22789, this.field_22790, 0, this.field_22790, 22);
        this.playersWidget.updateSplits(this.packages);
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (camera instanceof CinematicCamera) {
            CinematicCamera cinematicCamera = (CinematicCamera)camera;
            Supplier<class_5250> cameraText = () -> new class_2588("projectelo.text.cinematic_camera").method_27693(": ").method_10852((class_2561)(cinematicCamera.ranked$isCinematicActivated() ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text()));
            this.method_25411((class_339)new class_4185(this.field_22789 - 170, this.field_22790 - 30, 150, 20, (class_2561)cameraText.get(), button -> {
                cinematicCamera.ranked$setCinematicActive(!cinematicCamera.ranked$isCinematicActivated());
                button.method_25355((class_2561)cameraText.get());
            }));
        }
        OptionSliderWidget ghostOpacity = (OptionSliderWidget)this.method_25411((class_339)new OptionSliderWidget(() -> new class_2588("projectelo.text.ghost_opacity").method_27693(": ").method_27693(String.format("%s%%", class_3532.method_15375((float)(((Float)SpeedRunOption.getOption(RankedOptions.GHOST_OPACITY)).floatValue() * 100.0f)))), value -> SpeedRunOption.setOption(RankedOptions.GHOST_OPACITY, (Object)Float.valueOf(value.floatValue())), ((Float)SpeedRunOption.getOption(RankedOptions.GHOST_OPACITY)).floatValue(), 0.0, 1.0));
        ghostOpacity.setDimension(this.field_22789 - 170, this.field_22790 - 54, 150);
        OptionSliderWidget replayGlow = (OptionSliderWidget)this.method_25411((class_339)new OptionSliderWidget(() -> new class_2588("projectelo.text.replay_glow_distance").method_27693(": ").method_27693(ModOptionScreen.getOffValueString((Number)SpeedRunOption.getOption(RankedOptions.REPLAY_GLOW_DISTANCE), "+ Blocks")), value -> SpeedRunOption.setOption(RankedOptions.REPLAY_GLOW_DISTANCE, (Object)value.intValue()), ((Integer)SpeedRunOption.getOption(RankedOptions.REPLAY_GLOW_DISTANCE)).intValue(), 0.0, 64.0));
        replayGlow.setDimension(this.field_22789 - 170, this.field_22790 - 78, 150);
        this.method_25429((class_364)this.playersWidget);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.playersWidget.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean shouldRenderMatchHud() {
        return false;
    }

    public static class PlayersWidget
    extends class_4265<Entry> {
        public PlayersWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight) {
            super(client, width, height, top, bottom, itemHeight);
        }

        public int method_25342() {
            return 10;
        }

        protected int method_25329() {
            return this.method_25342() + this.method_25322() + 10;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return super.method_25401(mouseX, mouseY, amount * 2.5);
        }

        public int method_25322() {
            int maxNicknameWidth = 0;
            int maxTimelineWidth = 0;
            for (Entry child : this.method_25396()) {
                maxNicknameWidth = Math.max(maxNicknameWidth, this.field_22740.field_1772.method_1727(child.player.getNickname()));
                maxTimelineWidth = Math.max(maxTimelineWidth, this.field_22740.field_1772.method_27525((class_5348)child.currentSplit.getText()));
            }
            return 46 + maxNicknameWidth + maxTimelineWidth;
        }

        public void updateSplits(Collection<Pair<BasePlayer, MatchSplitTime>> packages) {
            this.method_25339();
            for (Pair<BasePlayer, MatchSplitTime> aPackage : packages) {
                if (!((MatchSplitTime)aPackage.getSecond()).getSplit().shouldDisplay()) continue;
                this.method_25321((class_350.class_351)new Entry((BasePlayer)aPackage.getFirst(), ((MatchSplitTime)aPackage.getSecond()).getSplit()));
            }
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int k = this.method_25342();
            int l = this.field_19085 + 4 - (int)this.method_25341();
            class_332.method_25294((class_4587)matrices, (int)this.field_19088, (int)this.field_19085, (int)this.method_25329(), (int)this.field_19086, (int)0x66000000);
            this.field_22742 = this.method_25329();
            this.method_25311(matrices, k, l, mouseX, mouseY, delta);
        }

        public class Entry
        extends class_4265.class_4266<Entry> {
            private final BasePlayer player;
            private final MatchSplit currentSplit;
            private final List<class_4185> buttonWidgets = Lists.newArrayList();
            private final class_4185 toggleButton;

            public Entry(BasePlayer player, MatchSplit currentSplit) {
                this.player = player;
                this.currentSplit = currentSplit;
                this.toggleButton = new class_4185(0, 0, 20, 20, class_2561.method_30163((String)""), button -> {
                    class_1132 server = null;
                    if (PlayersWidget.this.field_22740 != null) {
                        server = PlayersWidget.this.field_22740.method_1576();
                    }
                    if (server != null && MCSRRankedClient.getReplayProcessor().isPresent()) {
                        MCSRRankedClient.getReplayProcessor().get().setFocusedTracker(this.player.getUUID(), (MinecraftServer)server);
                    }
                });
                this.method_25396().add(this.toggleButton);
            }

            public void updateToggleButton() {
                boolean isToggle = MCSRRankedClient.getReplayProcessor().flatMap(processor -> processor.getTracker(this.player.getUUID()).map(OpponentPlayerTracker::isActive)).orElse(false);
                class_2585 text = new class_2585("\u2600");
                if (!isToggle) {
                    text = text.method_27695(new class_124[]{class_124.field_1061, class_124.field_1055});
                }
                this.toggleButton.method_25355((class_2561)text);
            }

            public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.player == null) {
                    return;
                }
                class_327 textRenderer = class_310.method_1551().field_1772;
                Objects.requireNonNull(textRenderer);
                int textY = y + (entryHeight - 9) / 2;
                RenderUtils.renderPlayerHead(this.player.getUUID(), matrices, x, textY, 8, 8);
                textRenderer.method_27517(matrices, (class_5348)new class_2585(this.player.getNickname()), (float)(x + 11), (float)textY, 0xFFFFFF);
                class_5250 splitText = this.currentSplit.getText().method_27692(class_124.field_1075);
                textRenderer.method_27517(matrices, (class_5348)splitText, (float)(x + entryWidth - textRenderer.method_27525((class_5348)splitText) - 26), (float)textY, 0xFFFFFF);
                this.toggleButton.field_22760 = x + entryWidth - 20;
                this.toggleButton.field_22761 = y + (entryHeight - this.toggleButton.method_25364()) / 2;
                this.updateToggleButton();
                this.toggleButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            }

            public List<class_4185> method_25396() {
                return this.buttonWidgets;
            }
        }
    }
}

