/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match.replay;

import com.mcsrranked.client.anticheat.mixin.replay.MouseAccessor;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.match.replay.LiveReplayTargetScreen;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.mcsrranked.client.world.WorldCreator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.Map;
import net.minecraft.class_1132;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class LiveReplayTimeOffsetScreen
extends RankedScreen {
    private static final class_2960 REPLAY_GUI_IDENTIFIER = new class_2960("mcsrranked", "textures/gui/replay_button.png");
    private final ReplayProcessor processor;
    private TimeSliderWidget timeSliderWidget;

    public LiveReplayTimeOffsetScreen(ReplayProcessor processor) {
        super(null, (class_2561)new class_2585(""));
        this.processor = processor;
    }

    protected void method_25426() {
        this.method_25411((class_339)new PauseResumeButton(40, this.field_22790 - 50, 20, 20));
        this.timeSliderWidget = (TimeSliderWidget)this.method_25411(new TimeSliderWidget(64, this.field_22790 - 52, this.field_22789 - 104));
        this.method_25411((class_339)new class_4185(40, this.field_22790 - 26, 150, 20, (class_2561)new class_2588("projectelo.title.live_replay_settings"), button -> this.openScreen(new LiveReplayTargetScreen((class_437)this, this.processor))));
        this.method_25411((class_339)new class_4185(this.field_22789 - 120, this.field_22790 - 26, 80, 20, (class_2561)RankedScreenTexts.GAME_MENU.text(), button -> this.openScreen((class_437)new class_433(true))));
        this.method_25411((class_339)new class_4185(this.field_22789 - 204, this.field_22790 - 26, 80, 20, (class_2561)new class_2588("projectelo.button.exit_replay"), button -> {
            WorldCreator.getInstance().stopWorld();
            this.openScreen(ReplayManager.LAST_REPLAY_SCREEN);
        }));
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean shouldRenderMatchHud() {
        return false;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.timeSliderWidget.method_25405(mouseX, mouseY)) {
            String time = InGameTimerUtils.timeToStringFormat((long)((long)this.timeSliderWidget.getFocusedTick(mouseX) * 50L));
            this.setTooltip(new class_2585(time));
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.timeSliderWidget.tick();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.processor.setPaused(!this.processor.isPaused());
        }
        if (!(keyCode != 263 && keyCode != 262 || this.processor.getActiveTrackers().isEmpty())) {
            class_1132 server = class_310.method_1551().method_1576();
            int targetTick = class_3532.method_15340((int)(this.processor.getCurrentTicks() + (keyCode == 263 ? -100 : 100)), (int)0, (int)this.processor.getMaxTrackerTick());
            if (server != null) {
                this.processor.moveToTick((MinecraftServer)server, targetTick, () -> this.timeSliderWidget.updateValue());
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    class PauseResumeButton
    extends class_4185 {
        public PauseResumeButton(int x, int y, int width, int height) {
            super(x, y, width, height, class_2585.field_24366, button -> {});
        }

        public void method_25306() {
            LiveReplayTimeOffsetScreen.this.processor.setPaused(!LiveReplayTimeOffsetScreen.this.processor.isPaused());
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            minecraftClient.method_1531().method_22813(REPLAY_GUI_IDENTIFIER);
            RenderSystem.enableDepthTest();
            PauseResumeButton.method_25290((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (float)(LiveReplayTimeOffsetScreen.this.processor.isPaused() ? 20.0f : 0.0f), (float)(this.method_25367() ? 20.0f : 0.0f), (int)this.field_22758, (int)this.field_22759, (int)64, (int)64);
        }
    }

    class TimeSliderWidget
    extends class_339 {
        private double value;
        private int dragCooldown;
        private boolean dragging;
        private boolean wasPaused;

        public TimeSliderWidget(int x, int y, int width) {
            super(x, y, width, 24, class_2585.field_24366);
            this.value = 0.0;
            this.dragCooldown = 4;
        }

        protected int method_25356(boolean isHovered) {
            return 0;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            int nw;
            class_310 minecraftClient = class_310.method_1551();
            minecraftClient.method_1531().method_22813(REPLAY_GUI_IDENTIFIER);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            TimeSliderWidget.method_25290((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (float)0.0f, (float)40.0f, (int)7, (int)this.field_22759, (int)64, (int)64);
            TimeSliderWidget.method_25290((class_4587)matrices, (int)(this.field_22760 + this.field_22758 - 7), (int)this.field_22761, (float)49.0f, (float)40.0f, (int)7, (int)this.field_22759, (int)64, (int)64);
            for (int w = 0; w < this.field_22758 - 14; w += nw) {
                nw = Math.min(this.field_22758 - 14 - w, 42);
                TimeSliderWidget.method_25290((class_4587)matrices, (int)(this.field_22760 + 7 + w), (int)this.field_22761, (float)7.0f, (float)40.0f, (int)nw, (int)this.field_22759, (int)64, (int)64);
            }
            RenderSystem.pushMatrix();
            RenderUtils.enableScissor(this.field_22760, this.field_22761, this.field_22758, this.field_22759);
            TimeSliderWidget.method_25290((class_4587)matrices, (int)(this.field_22760 + (int)(this.value * (double)(this.field_22758 - 9)) - 1), (int)this.field_22761, (float)40.0f, (float)0.0f, (int)11, (int)7, (int)64, (int)64);
            RenderUtils.disableScissor();
            RenderSystem.popMatrix();
            if (LiveReplayTimeOffsetScreen.this.processor.getFocusedTracker().isPresent()) {
                Map<Integer, WorldTypes> dimensionCache = ((LiveReplayTimeOffsetScreen)LiveReplayTimeOffsetScreen.this).processor.getFocusedTracker().get().playerDimensionCache;
                Map.Entry<Integer, WorldTypes> lastEntry = null;
                for (Map.Entry<Integer, WorldTypes> entry : dimensionCache.entrySet()) {
                    if (lastEntry == null) {
                        lastEntry = entry;
                        continue;
                    }
                    this.renderDimensionMarker(matrices, lastEntry, entry);
                    lastEntry = entry;
                }
                if (lastEntry != null) {
                    this.renderDimensionMarker(matrices, lastEntry, null);
                }
                Map<Integer, Boolean> deaths = ((LiveReplayTimeOffsetScreen)LiveReplayTimeOffsetScreen.this).processor.getFocusedTracker().get().deathTickMap;
                minecraftClient.method_1531().method_22813(TextureUtils.DEFAULT_GUI_TEXTURE);
                for (Map.Entry<Integer, Boolean> entry : deaths.entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    int offset = (int)(this.getValueFromTick(entry.getKey()) * (double)(this.field_22758 - 8));
                    TimeSliderWidget.method_25293((class_4587)matrices, (int)(this.field_22760 + 4 + offset - 4), (int)(this.field_22761 + this.field_22759 - 15), (int)8, (int)8, (float)64.0f, (float)0.0f, (int)8, (int)8, (int)128, (int)128);
                }
            }
        }

        private void renderDimensionMarker(class_4587 matrices, Map.Entry<Integer, WorldTypes> targetEntry, @Nullable Map.Entry<Integer, WorldTypes> nextEntry) {
            int startOffset = (int)(this.getValueFromTick(targetEntry.getKey()) * (double)(this.field_22758 - 8));
            int endOffset = (int)((nextEntry == null ? 1.0 : this.getValueFromTick(nextEntry.getKey())) * (double)(this.field_22758 - 8)) + 1;
            TimeSliderWidget.method_25294((class_4587)matrices, (int)(this.field_22760 + 4 + startOffset), (int)(this.field_22761 + this.field_22759 - 11), (int)(this.field_22760 + 4 + endOffset - 1), (int)(this.field_22761 + this.field_22759 - 4), (int)targetEntry.getValue().getColor());
        }

        public void method_25348(double mouseX, double mouseY) {
            this.setValueFromMouse(mouseX);
            this.applyValue();
        }

        public int getFocusedTick(double mouseX) {
            double targetValue = class_3532.method_15350((double)this.getValueFromMouse(mouseX), (double)0.0, (double)1.0);
            return (int)((double)LiveReplayTimeOffsetScreen.this.processor.getMaxTrackerTick() * targetValue);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                float f = bl ? -1.0f : 1.0f;
                this.setValue(this.value + (double)(f / (float)(this.field_22758 - 8)));
                this.applyValue();
            }
            return false;
        }

        private double getValueFromMouse(double mouseX) {
            return (mouseX - (double)(this.field_22760 + 4)) / (double)(this.field_22758 - 8);
        }

        private double getValueFromTick(int tick) {
            return (double)tick / ((double)LiveReplayTimeOffsetScreen.this.processor.getMaxTrackerTick() * 1.0);
        }

        private void setValueFromMouse(double mouseX) {
            this.setValue(this.getValueFromMouse(mouseX));
        }

        private void setValue(double mouseX) {
            if (LiveReplayTimeOffsetScreen.this.processor.isLoading()) {
                return;
            }
            this.value = class_3532.method_15350((double)mouseX, (double)0.0, (double)1.0);
        }

        private void tick() {
            if (!this.dragging) {
                this.updateValue();
            } else if (LiveReplayTimeOffsetScreen.this.field_22787 != null && ((MouseAccessor)((LiveReplayTimeOffsetScreen)LiveReplayTimeOffsetScreen.this).field_22787.field_1729).getActiveButton() == -1) {
                this.method_25357(((LiveReplayTimeOffsetScreen)LiveReplayTimeOffsetScreen.this).field_22787.field_1729.method_1603(), ((LiveReplayTimeOffsetScreen)LiveReplayTimeOffsetScreen.this).field_22787.field_1729.method_1604());
            }
        }

        private void updateValue() {
            this.value = this.getValueFromTick(LiveReplayTimeOffsetScreen.this.processor.getCurrentTicks());
        }

        public void method_25354(class_1144 soundManager) {
        }

        protected boolean method_25361(double mouseX, double mouseY) {
            if (super.method_25361(mouseX, mouseY)) {
                this.wasPaused = LiveReplayTimeOffsetScreen.this.processor.isPaused();
                return true;
            }
            return false;
        }

        protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
            this.dragging = true;
            LiveReplayTimeOffsetScreen.this.processor.setPaused(true);
            this.setValueFromMouse(mouseX);
            if (--this.dragCooldown <= 0) {
                this.applyValue();
                this.dragCooldown = 4;
            }
            super.method_25349(mouseX, mouseY, deltaX, deltaY);
        }

        public void method_25357(double mouseX, double mouseY) {
            if (LiveReplayTimeOffsetScreen.this.processor.isLoading()) {
                return;
            }
            this.dragging = false;
            this.applyValue();
            LiveReplayTimeOffsetScreen.this.processor.setPaused(this.wasPaused);
            super.method_25354(class_310.method_1551().method_1483());
        }

        private void applyValue() {
            if (LiveReplayTimeOffsetScreen.this.processor.isLoading()) {
                return;
            }
            int targetTick = (int)((double)LiveReplayTimeOffsetScreen.this.processor.getMaxTrackerTick() * this.value);
            if (!LiveReplayTimeOffsetScreen.this.processor.getActiveTrackers().isEmpty()) {
                class_1132 server = class_310.method_1551().method_1576();
                if (server != null) {
                    LiveReplayTimeOffsetScreen.this.processor.moveToTick((MinecraftServer)server, targetTick);
                }
            } else {
                LiveReplayTimeOffsetScreen.this.processor.setCurrentTicks(targetTick);
            }
        }
    }
}

