/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.race;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedMainScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.match.NoticeMessageScreen;
import com.mcsrranked.client.gui.screen.match.replay.ReplayLoadingScreen;
import com.mcsrranked.client.gui.screen.race.RaceIDScreen;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.race.WeeklyRace;
import com.mcsrranked.client.info.race.WeeklyRaceRecord;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.world.WorldCreatorBuilder;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class RaceInfoScreen
extends RankedScreen {
    private static int maxRaceId = 0;
    private static final class_2960 TRIAL_ICON = new class_2960("realms", "textures/gui/realms/trial_icon.png");
    private final int weekId;
    private boolean hasInit = false;
    private WeeklyRace raceInfo = null;
    private RaceRecordWidget raceRecordWidget = null;
    private FreeSizeButtonWidget ownRecordButton = null;
    private FreeSizeButtonWidget watchReplayButton = null;
    private FreeSizeButtonWidget deselectButton = null;
    private class_4185 loadingCancelButton = null;
    private FreeSizeButtonWidget playButton = null;

    public RaceInfoScreen(class_437 parent, int weekId) {
        super(parent, (class_2561)new class_2588("projectelo.title.weekly_race"));
        this.weekId = weekId;
    }

    public RaceInfoScreen(class_437 parent) {
        this(parent, 0);
    }

    public RaceInfoScreen() {
        this(RankedMainScreen.create());
    }

    @Override
    public void method_25423(class_310 client, int width, int height) {
        super.method_25423(client, width, height);
        if (!this.hasInit) {
            this.loadRaceInfo();
            this.hasInit = true;
        }
    }

    public void loadRaceInfo() {
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            JsonElement result = ClientUtils.getApiResponse("weekly-race/" + this.weekId + "?uuid=" + MCSRRankedClient.LOCAL_PLAYER.getUUIDString());
            if (result == null) {
                return;
            }
            JsonObject jsonObject = result.getAsJsonObject();
            ArrayList leaderboard = Lists.newArrayList();
            for (JsonElement record : jsonObject.getAsJsonArray("leaderboard")) {
                leaderboard.add((WeeklyRaceRecord)MCSRRankedClient.GSON.fromJson(record, WeeklyRaceRecord.class));
            }
            this.raceInfo = new WeeklyRace(jsonObject.get("id").getAsInt(), (WeeklyRace.SeedPair)MCSRRankedClient.GSON.fromJson(jsonObject.get("seed"), WeeklyRace.SeedPair.class), jsonObject.get("endsAt").getAsInt(), leaderboard, (WeeklyRaceRecord)MCSRRankedClient.GSON.fromJson(jsonObject.get("user"), WeeklyRaceRecord.class));
            maxRaceId = Math.max(this.raceInfo.getID(), maxRaceId);
        });
    }

    private int getBoardCenterX() {
        return (int)((float)this.field_22789 / 1.75f + ((float)this.field_22789 - (float)this.field_22789 / 1.75f) / 2.0f);
    }

    public void initWidgets() {
        this.method_25396().clear();
        if (this.loadingCancelButton != null) {
            this.loadingCancelButton.field_22764 = false;
        }
        this.raceRecordWidget = new RaceRecordWidget(this);
        this.raceRecordWidget.method_25314(this.raceInfo.getLeaderboard().stream().map(record -> {
            RaceRecordWidget.Entry entry = new RaceRecordWidget.Entry(this.raceRecordWidget, (WeeklyRaceRecord)record);
            class_3545 pair = (class_3545)SpeedRunOption.getOption(RankedOptions.LAST_SELECT_RACE_GHOST);
            if (pair != null && this.raceInfo.getID() == ((Integer)pair.method_15442()).intValue() && entry.record.getPlayer().getUUID().equals(pair.method_15441())) {
                this.raceInfo.setGhost(entry.record);
            }
            return entry;
        }).collect(Collectors.toList()));
        this.method_25429((class_364)this.raceRecordWidget);
        class_4185 prevRaceButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 160, 12, 20, 20, class_2561.method_30163((String)"<"), button -> this.openScreen(class_437.method_25442() ? new RaceIDScreen(this, maxRaceId) : new RaceInfoScreen(this.getParent(), this.raceInfo.getID() - 1)), (button, matrices, mouseX, mouseY) -> this.setTooltipWithWrap(new class_2588("projectelo.text.hold_shift_to_insert_id"), 180)));
        prevRaceButton.field_22763 = this.raceInfo.getID() > 1;
        class_4185 nextRaceButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 140, 12, 20, 20, class_2561.method_30163((String)">"), button -> this.openScreen(class_437.method_25442() ? new RaceIDScreen(this, maxRaceId) : new RaceInfoScreen(this.getParent(), this.raceInfo.getID() + 1)), (button, matrices, mouseX, mouseY) -> this.setTooltipWithWrap(new class_2588("projectelo.text.hold_shift_to_insert_id"), 180)));
        nextRaceButton.field_22763 = this.raceInfo.getEndDate().getTime() < new Date().getTime();
        this.watchReplayButton = (FreeSizeButtonWidget)this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() - 75, 138, 86, 20, (class_2561)new class_2588("projectelo.button.watch_replay"), button -> {
            if (this.field_22787 == null || this.raceInfo.getGhost() == null) {
                return;
            }
            this.field_22787.method_1507((class_437)new ReplayLoadingScreen(this));
            new Thread(() -> {
                File replayFile = ReplayManager.downloadReplayFile(this.raceInfo, this.raceInfo.getGhost());
                if (replayFile != null) {
                    try {
                        ReplayRecordFile replay = ReplayManager.convertReplayFile(replayFile);
                        ReplayManager.playReplayProcessor(this, replay);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new NoticeMessageScreen(this, "projectelo.text.downloading_replay_failed", new Object[0])));
            }).start();
        }));
        this.watchReplayButton.field_22764 = false;
        this.deselectButton = (FreeSizeButtonWidget)this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() + 15, 138, 60, 20, (class_2561)new class_2588("projectelo.title.deselect"), button -> {
            this.raceInfo.setGhost(null);
            this.raceRecordWidget.setSelected(null);
            SpeedRunOption.setOption(RankedOptions.LAST_SELECT_RACE_GHOST, null);
        }));
        this.deselectButton.field_22764 = false;
        this.ownRecordButton = (FreeSizeButtonWidget)this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() - 75, 80, 150, 20, (class_2561)new class_2588("projectelo.button.select_my_record"), button -> {
            if (this.raceInfo.getUser() != null) {
                this.raceInfo.setGhost(this.raceInfo.getUser());
                this.raceRecordWidget.setSelected(null);
                SpeedRunOption.setOption(RankedOptions.LAST_SELECT_RACE_GHOST, (Object)new class_3545((Object)this.raceInfo.getID(), (Object)this.raceInfo.getUser().getPlayer().getUUID()));
            }
        }));
        this.ownRecordButton.field_22764 = false;
        this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() - 75, this.field_22790 - 34, 150, 24, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
        this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() - 75, this.field_22790 - 62, 60, 26, (class_2561)new class_2588("projectelo.button.practice"), button -> {
            class_435 progressScreen = new class_435();
            progressScreen.method_15412((class_2561)new class_2585("Loading Replay..."));
            assert (this.field_22787 != null);
            this.field_22787.method_29970((class_437)progressScreen);
            InGameTimer.getInstance().setCategory(RunCategories.ANY, false);
            MCSRRankedClient.setCurrentRace(this.raceInfo);
            this.raceInfo.setRunning(false);
            this.raceInfo.setPracticing(true);
            this.raceInfo.initReplay(false);
            new WorldCreatorBuilder(this.raceInfo.getOverworldSeed(), this.raceInfo.getNetherSeed()).setTheEndSeed(this.raceInfo.getTheEndSeed()).setRNGSeed(this.raceInfo.getRNGSeed()).setAllowCommands(true).setDefaultGameMode(class_437.method_25442() ? class_1934.field_9220 : class_1934.field_9215).setBeforeLeave(() -> {
                this.raceInfo.resetReplay();
                if (this.raceInfo.getReplayProcessor() != null) {
                    this.raceInfo.getReplayProcessor().setActive(false);
                }
            }).setBeforeReset(() -> this.raceInfo.setPracticing(true)).setTimerConsumer((timer, serverInfo) -> this.raceInfo.resetTimer()).addGameRulesConsumer(this.raceInfo.getGameRuleConsumer()).setQueueSettings((Integer)SpeedRunOption.getOption(RankedOptions.WORLD_QUEUE_SIZE_RACE), (Integer)SpeedRunOption.getOption(RankedOptions.WORLD_QUEUE_PRIORITY_RACE)).build().start();
        }, (button, matrices, mouseX, mouseY) -> this.setTooltipWithWrap(new class_2588("projectelo.text.hold_shift_to_creative"), 150)));
        this.playButton = (FreeSizeButtonWidget)this.method_25411((class_339)new FreeSizeButtonWidget(this.getBoardCenterX() - 13, this.field_22790 - 62, 88, 26, (class_2561)new class_2588("projectelo.button.start"), button -> {
            class_435 progressScreen = new class_435();
            progressScreen.method_15412((class_2561)new class_2585("Loading Replay..."));
            assert (this.field_22787 != null);
            this.field_22787.method_29970((class_437)progressScreen);
            InGameTimer.getInstance().setCategory(RunCategories.ANY, false);
            MCSRRankedClient.setCurrentRace(this.raceInfo);
            this.raceInfo.setRunning(true);
            this.raceInfo.setPracticing(false);
            this.raceInfo.initReplay(true);
            new WorldCreatorBuilder(this.raceInfo.getOverworldSeed(), this.raceInfo.getNetherSeed()).setTheEndSeed(this.raceInfo.getTheEndSeed()).setRNGSeed(this.raceInfo.getRNGSeed()).setBeforeLeave(() -> {
                this.raceInfo.resetReplay();
                if (this.raceInfo.getReplayProcessor() != null) {
                    this.raceInfo.getReplayProcessor().setActive(false);
                }
            }).setBeforeReset(() -> {
                if (this.raceInfo.getEndDate().getTime() < new Date().getTime()) {
                    this.field_22787.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.race_outdated_warning", (Object[])new Object[0]), true));
                }
                this.raceInfo.setRunning(true);
            }).setTimerConsumer((timer, serverInfo) -> this.raceInfo.resetTimer()).addGameRulesConsumer(this.raceInfo.getGameRuleConsumer()).setQueueSettings((Integer)SpeedRunOption.getOption(RankedOptions.WORLD_QUEUE_SIZE_RACE), (Integer)SpeedRunOption.getOption(RankedOptions.WORLD_QUEUE_PRIORITY_RACE)).build().start();
        }));
        this.playButton.field_22763 = this.raceInfo.getEndDate().getTime() >= new Date().getTime();
    }

    protected void method_25426() {
        this.raceRecordWidget = null;
        this.loadingCancelButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.raceRecordWidget == null && this.raceInfo != null) {
            this.initWidgets();
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        if (this.raceRecordWidget != null) {
            this.raceRecordWidget.method_25394(matrices, mouseX, mouseY, delta);
            if (this.raceRecordWidget.isActiveSpecialBackground()) {
                class_332.method_25294((class_4587)matrices, (int)this.raceRecordWidget.getRenderWidth(), (int)0, (int)this.field_22789, (int)this.field_22790, (int)Integer.MIN_VALUE);
            }
            this.deselectButton.field_22764 = this.raceInfo.getGhost() != null;
            this.watchReplayButton.field_22764 = this.deselectButton.field_22764;
            this.watchReplayButton.field_22763 = this.raceInfo.getGhost() != null && this.raceInfo.getGhost().isReplayExist();
            this.ownRecordButton.field_22764 = !this.deselectButton.field_22764 && this.raceInfo.getUser() != null;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.raceInfo != null && this.raceRecordWidget != null) {
            matrices.method_22903();
            matrices.method_22905(1.5f, 1.5f, 1.0f);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.week").method_10852((class_2561)new class_2585(" - #" + this.raceInfo.getID()).method_27692(class_124.field_1068)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), this.field_22789 / 3, 6, 0xFFFFFF);
            matrices.method_22909();
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.race_ends").method_27693(": " + ClientUtils.getDateFormat(this.raceInfo.getEndDate(), false)), this.field_22789 / 2, 26, 0xFFFFFF);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.my_race_record").method_27692(class_124.field_1075), this.getBoardCenterX(), 44, 0xFFFFFF);
            matrices.method_22903();
            matrices.method_22905(1.5f, 1.5f, 1.0f);
            if (this.raceInfo.getUser() != null) {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)this.raceInfo.getUser().getTime())).method_10852((class_2561)new class_2585(String.format(" (#%s)", this.raceInfo.getUser().getRank())).method_27692(class_124.field_1054)), (int)((float)this.getBoardCenterX() / 1.5f), 40, 0xFFFFFF);
            } else {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585("-").method_27692(class_124.field_1061), (int)((float)this.getBoardCenterX() / 1.5f), 40, 0xFFFFFF);
            }
            matrices.method_22909();
            WeeklyRaceRecord ghost = this.raceInfo.getGhost();
            if (ghost != null) {
                int nicknameWidth = BasePlayer.renderNickname(matrices, this.getBoardCenterX(), -100, ghost.getPlayer());
                BasePlayer.renderNickname(matrices, this.getBoardCenterX() - nicknameWidth / 2, 104, ghost.getPlayer(), this, mouseX, mouseY);
                matrices.method_22903();
                matrices.method_22905(1.5f, 1.5f, 1.0f);
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585("VS").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), (int)((float)this.getBoardCenterX() / 1.5f), 55, 0xFFFFFF);
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)ghost.getTime())).method_10852((class_2561)new class_2585(String.format(" (#%s)", ghost.getRank())).method_27692(class_124.field_1054)), (int)((float)this.getBoardCenterX() / 1.5f), 78, 0xFFFFFF);
                matrices.method_22909();
            }
            if (this.playButton.method_25405(mouseX, mouseY) && !this.playButton.field_22763) {
                this.setTooltip(new class_2588("projectelo.text.weekly_race_unavailable"));
            }
        } else {
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 - 10);
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.loading_server"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        }
    }

    private static class RaceRecordWidget
    extends class_4280<Entry>
    implements RankedEntryListWidget {
        private final RaceInfoScreen parent;

        public RaceRecordWidget(RaceInfoScreen parent) {
            class_310 class_3102 = parent.field_22787;
            int n = (int)((float)parent.field_22789 / 1.75f);
            int n2 = parent.field_22790;
            int n3 = parent.field_22790 - 10;
            Objects.requireNonNull(parent.field_22793);
            super(class_3102, n, n2, 42, n3, 9 + 2);
            this.parent = parent;
        }

        public int getRenderWidth() {
            return this.field_19088 + this.field_22742;
        }

        public void setSelected(@Nullable Entry entry) {
            super.method_25313((class_350.class_351)entry);
            if (entry != null) {
                this.parent.raceInfo.setGhost(entry.record);
                SpeedRunOption.setOption(RankedOptions.LAST_SELECT_RACE_GHOST, (Object)new class_3545((Object)this.parent.raceInfo.getID(), (Object)entry.record.getPlayer().getUUID()));
            }
        }

        protected int method_25329() {
            return super.method_25329() - 10;
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            return super.method_25401(mouseX, mouseY, amount * 2.5);
        }

        protected void method_25314(Collection<Entry> newEntries) {
            super.method_25314(newEntries);
        }

        private static class Entry
        extends class_4280.class_4281<Entry> {
            private final RaceRecordWidget widget;
            private final WeeklyRaceRecord record;

            private Entry(RaceRecordWidget widget, WeeklyRaceRecord record) {
                this.record = record;
                this.widget = widget;
            }

            public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                class_327 textRenderer = class_310.method_1551().field_1772;
                textRenderer.method_27517(matrices, (class_5348)BasePlayer.getTextFromEloRank(this.record.getRank()), (float)x, (float)y, 0xFFFFFF);
                BasePlayer.renderNickname(matrices, x + 32, y, this.record.getPlayer(), this.widget.parent, mouseX, mouseY);
                class_2561 timeText = class_2561.method_30163((String)InGameTimerUtils.timeToStringFormat((long)this.record.getTime()));
                textRenderer.method_27517(matrices, (class_5348)timeText, (float)(x + entryWidth - textRenderer.method_27525((class_5348)timeText) - 4), (float)y, 0xFFFFFF);
                if (this.record.getPlayer().isMe()) {
                    class_310.method_1551().method_1531().method_22813(TRIAL_ICON);
                    int o = (class_156.method_658() / 800L & 1L) == 1L ? 8 : 0;
                    class_332.method_25293((class_4587)matrices, (int)(x - 12), (int)y, (int)8, (int)8, (float)0.0f, (float)o, (int)8, (int)8, (int)8, (int)16);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    this.widget.setSelected(this);
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        }
    }
}

