/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.socket.SocketInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class MatchChatWidget
extends class_342 {
    private static final long CHAT_COOLDOWN = 20000L;
    public static long LATEST_CHAT_UPDATE = 0L;
    public static long LATEST_CHAT_EDIT = 0L;
    public static String CHAT_CONTEXT = "";
    public static boolean CHAT_CONTEXT_WIDGET = false;
    private static final CopyOnWriteArrayList<class_3545<class_2561, Long>> PLAYER_CHAT_LIST = new CopyOnWriteArrayList();
    private final class_327 textRenderer;

    public static class_2561 getChatTextFromString(OnlinePlayer onlinePlayer, String message) {
        return new class_2588("chat.type.text", new Object[]{onlinePlayer.getNickname(), message}).method_27692(onlinePlayer.isSpectator() ? class_124.field_1054 : class_124.field_1068);
    }

    public MatchChatWidget(class_327 textRenderer, int x, int y, int width, class_437 screen) {
        super(textRenderer, x, y, width, 15, class_2585.field_24366);
        this.method_1880(256);
        this.textRenderer = textRenderer;
        this.method_1863(s -> {
            CHAT_CONTEXT = s;
            CHAT_CONTEXT_WIDGET = true;
        });
        if (!CHAT_CONTEXT_WIDGET || screen instanceof RankedScreen) {
            this.method_1852(CHAT_CONTEXT);
        }
    }

    public static void addSystemChat(class_2561 text, boolean clientUpdate) {
        MatchChatWidget.addChat(class_2556.field_11735, text, class_156.field_25140, clientUpdate);
    }

    public static void addPlayerChat(OnlinePlayer onlinePlayer, String message, boolean clientUpdate) {
        if (!onlinePlayer.isMe()) {
            LATEST_CHAT_UPDATE = 0L;
        }
        MatchChatWidget.addChat(class_2556.field_11737, MatchChatWidget.getChatTextFromString(onlinePlayer, message), onlinePlayer.getDisplayUUID(), clientUpdate);
    }

    private static void addChat(class_2556 type, class_2561 text, UUID uuid, boolean clientUpdate) {
        if (PLAYER_CHAT_LIST.size() > 12) {
            PLAYER_CHAT_LIST.remove(12);
        }
        PLAYER_CHAT_LIST.add(0, (class_3545<class_2561, Long>)new class_3545((Object)text, (Object)(System.currentTimeMillis() + 20000L)));
        if (clientUpdate) {
            class_310.method_1551().field_1705.method_1755(type, text, uuid);
        }
    }

    public static void clearChat() {
        PLAYER_CHAT_LIST.clear();
        CHAT_CONTEXT = "";
        LATEST_CHAT_UPDATE = 0L;
        LATEST_CHAT_EDIT = 0L;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return false;
        }
        if (System.currentTimeMillis() - LATEST_CHAT_EDIT > 3000L) {
            LATEST_CHAT_EDIT = System.currentTimeMillis();
            SocketInstance.getInstance().emit("p$writing", new Object[0]);
        }
        if (keyCode == 257 || keyCode == 335) {
            String message = this.method_1882().trim();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                if (!message.isEmpty() && this.method_25370()) {
                    for (OnlinePlayer player : onlineMatch.getPlayers()) {
                        if (!player.isMe()) continue;
                        MatchChatWidget.addPlayerChat(player, message, true);
                        SocketInstance.getInstance().emit("p$chat", message);
                    }
                    this.method_1852("");
                } else if (!this.method_25370()) {
                    this.method_25365(true);
                }
            });
        }
        return false;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        int chatHeight = 0;
        ArrayList totalTextList = Lists.newArrayList();
        for (class_3545<class_2561, Long> textLongPair : PLAYER_CHAT_LIST) {
            List texts = this.textRenderer.method_1728((class_5348)textLongPair.method_15442(), this.method_1859());
            for (int i = texts.size() - 1; i >= 0; --i) {
                class_5348 text = (class_5348)texts.get(i);
                chatHeight += 11;
                totalTextList.add(text);
            }
        }
        if (chatHeight > 0) {
            int i;
            class_332.method_25294((class_4587)matrices, (int)this.field_22760, (int)(this.field_22761 - chatHeight), (int)(this.field_22760 + this.method_25368()), (int)(this.field_22761 - 1), (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
            for (i = PLAYER_CHAT_LIST.size() - 1; i >= 0; --i) {
                if ((Long)PLAYER_CHAT_LIST.get(i).method_15441() >= System.currentTimeMillis()) continue;
                PLAYER_CHAT_LIST.remove(i);
            }
            for (i = 0; i < totalTextList.size(); ++i) {
                class_5348 text = (class_5348)totalTextList.get(i);
                this.method_27535(matrices, this.textRenderer, text, this.field_22760 + 3, this.field_22761 - (i + 1) * 11 + 1, 0xFFFFFF);
            }
        }
        long time = System.currentTimeMillis();
        if (this.method_1882().trim().isEmpty() && time - LATEST_CHAT_UPDATE < 5000L) {
            int alpha = (int)((float)Math.abs(time % 1000L - 500L) / 500.0f * 120.0f) + 10;
            this.method_27535(matrices, this.textRenderer, (class_5348)new class_2585("\u270e ").method_27693(class_1074.method_4662((String)"projectelo.text.opponent_typing", (Object[])new Object[0])).method_27693("..."), this.field_22760 + 3, this.field_22761 + 3, class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255));
        }
    }
}

