/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.match.MatchPreset;
import com.mcsrranked.client.info.match.online.MatchOption;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_368;
import net.minecraft.class_4239;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class MatchPresetListWidget
extends class_4280<MatchPresetEntry>
implements RankedEntryListWidget {
    private static final Path PRESETS_PATH = MCSRRankedClient.GLOBAL_PATH.resolve("presets");
    private final RankedScreen screen;

    public MatchPresetListWidget(class_310 client, RankedScreen screen) {
        super(client, screen.field_22789 - 80, screen.field_22790, 24, screen.field_22790 - 40, 20);
        this.screen = screen;
        this.method_25333(80);
        File presetDir = PRESETS_PATH.toFile();
        presetDir.mkdir();
        for (File file : Objects.requireNonNull(presetDir.listFiles())) {
            try {
                MatchPreset preset = MatchPreset.fromJsonLatest(FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()));
                this.method_25321((class_350.class_351)new MatchPresetEntry(preset, file.toPath()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected int method_25329() {
        return super.method_25329() + 80;
    }

    public void tryImport() {
        new Thread(() -> {
            MemoryStack stack = MemoryStack.stackPush();
            PointerBuffer filters = stack.mallocPointer(1);
            filters.put(stack.UTF8((CharSequence)"*.rsp"));
            filters.flip();
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Import Private Room Settings Preset", (CharSequence)PRESETS_PATH.toString(), (PointerBuffer)filters, (CharSequence)"Preset File (*.rsp)", (boolean)false);
            if (string != null) {
                Path path = Paths.get(string, new String[0]);
                try {
                    String nextName;
                    String data = FileUtils.readFileToString((File)path.toFile(), (Charset)Charset.defaultCharset());
                    String originalName = nextName = path.toFile().getName();
                    int dupIndex = 0;
                    while (PRESETS_PATH.resolve(nextName).toFile().exists()) {
                        String newBaseName = FilenameUtils.getBaseName((String)originalName) + "_" + ++dupIndex;
                        nextName = (newBaseName.length() > 200 ? newBaseName.substring(0, 200) : newBaseName) + "." + FilenameUtils.getExtension((String)originalName);
                    }
                    FileUtils.writeStringToFile((File)PRESETS_PATH.resolve(nextName).toFile(), (String)data, (Charset)Charset.defaultCharset());
                    MatchPreset preset = MatchPreset.fromJsonLatest(data);
                    this.method_25321((class_350.class_351)new MatchPresetEntry(preset, PRESETS_PATH.resolve(nextName)));
                    this.field_22740.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.preset_load_success", (Object[])new Object[0])));
                }
                catch (Exception e) {
                    this.field_22740.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.preset_load_fail", (Object[])new Object[0])));
                    e.printStackTrace();
                }
            }
            stack.close();
        }).start();
    }

    public void tryExport(String name) {
        Path finalPath = this.checkName(name);
        if (finalPath != null) {
            MatchPreset preset = new MatchPreset(MCSRRankedClient.LOCAL_PLAYER.getNickname(), name, MCSRRankedClient.getOnlineMatch().map(OnlineMatch::getOption).orElse(null));
            String json = MCSRRankedClient.GSON.toJson((Object)preset);
            try {
                FileUtils.writeStringToFile((File)finalPath.toFile(), (String)json, (Charset)Charset.defaultCharset());
                this.field_22740.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.preset_export_success", (Object[])new Object[0])));
                this.method_25321((class_350.class_351)new MatchPresetEntry(preset, finalPath));
                if (class_156.method_668() == class_156.class_158.field_1133) {
                    String windowsDirectory = System.getenv("WINDIR");
                    String explorerFilePath = windowsDirectory + "\\explorer.exe";
                    ProcessBuilder builder = new ProcessBuilder(explorerFilePath, "/select,", finalPath.toString());
                    try {
                        builder.start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    class_156.method_668().method_672(PRESETS_PATH.toFile());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.field_22740.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.preset_export_fail", (Object[])new Object[0])));
            }
        }
    }

    public Path checkName(String name) {
        String finalName;
        Path finalPath;
        if (!name.trim().isEmpty() && class_4239.method_20201((Path)(finalPath = PRESETS_PATH.resolve((finalName = name.trim()) + ".rsp"))) && class_4239.method_20200((Path)finalPath) && !finalPath.toFile().exists()) {
            return finalPath;
        }
        return null;
    }

    public void deleteFromPresets() {
        MatchPresetEntry selected = (MatchPresetEntry)this.method_25334();
        if (selected != null) {
            try {
                FileUtils.forceDelete((File)selected.getPath().toFile());
                this.method_25330((class_350.class_351)selected);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void apply() {
        MatchPresetEntry selected = (MatchPresetEntry)this.method_25334();
        if (selected != null) {
            MatchOption prevOption = MCSRRankedClient.getOnlineMatch().map(OnlineMatch::getOption).orElse(new MatchOption());
            MatchOption option = selected.getPreset().getOption().copy();
            option.getSeedType().setFlagValue(prevOption.getSeedType().getFlagValue());
            MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.setOption(option));
            this.field_22740.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.preset_applied_success", (Object[])new Object[0])));
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.method_25396().isEmpty()) {
            List texts = this.field_22740.field_1772.method_1728((class_5348)new class_2588("projectelo.text.preset_none"), this.method_25322());
            int index = -1;
            for (class_5348 text : texts) {
                class_327 class_3272 = this.field_22740.field_1772;
                int n = (this.screen.field_22789 + this.field_19088) / 2;
                int n2 = this.field_22743 / 2;
                int n3 = -(texts.size() / 2) + index++;
                Objects.requireNonNull(this.field_22740.field_1772);
                this.method_27534(matrices, class_3272, text, n, n2 + n3 * (9 + 1), 0xFFFFFF);
            }
        }
    }

    public class MatchPresetEntry
    extends class_4280.class_4281<MatchPresetEntry> {
        private final MatchPreset preset;
        private final Path path;

        public MatchPresetEntry(MatchPreset preset, Path path) {
            this.preset = preset;
            this.path = path;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            assert (MatchPresetListWidget.this.field_22740 != null);
            assert (((MatchPresetListWidget)MatchPresetListWidget.this).field_22740.field_1755 != null);
            class_327 textRenderer = ((MatchPresetListWidget)MatchPresetListWidget.this).field_22740.field_1772;
            RankedScreen rankedScreen = MatchPresetListWidget.this.screen;
            class_2585 class_25852 = new class_2585(this.getPreset().getName());
            Objects.requireNonNull(textRenderer);
            rankedScreen.method_27535(matrices, textRenderer, (class_5348)class_25852, x + 2, y + (entryHeight - 9) / 2, 0xFFFFFF);
            if (this.method_25405(mouseX, mouseY)) {
                MatchPresetListWidget.this.screen.setTooltipWithWrap(new class_2585(this.getPreset().getName() + " by " + this.getPreset().getAuthor()), 200);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                MatchPresetListWidget.this.method_25313((class_350.class_351)this);
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public MatchPreset getPreset() {
            return this.preset;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

