/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.EloLeaderboardScreen;
import com.mcsrranked.client.gui.screen.info.UserProfileScreen;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.LeaderboardPlayer;
import com.mcsrranked.client.info.player.PlayerCountry;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class UserLeaderboardWidget
extends class_4265<UserEntry>
implements RankedEntryListWidget {
    private static final class_2960 TRIAL_ICON = new class_2960("realms", "textures/gui/realms/trial_icon.png");
    private final RankedScreen currentScreen;
    private final boolean phaseMode;
    private boolean displayIndex = false;

    public UserLeaderboardWidget(class_310 minecraftClient, RankedScreen currentScreen, boolean phaseMode) {
        super(minecraftClient, currentScreen.field_22789, currentScreen.field_22790, 36, currentScreen.field_22790 - 40, 11);
        this.currentScreen = currentScreen;
        this.phaseMode = phaseMode;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount * 2.5);
    }

    public void updatePlayerList(CopyOnWriteArrayList<LeaderboardPlayer> matchResults, Double prevScroll, boolean displayIndex) {
        this.displayIndex = displayIndex;
        CopyOnWriteArrayList<UserEntry> newEntries = new CopyOnWriteArrayList<UserEntry>();
        for (LeaderboardPlayer player : matchResults) {
            newEntries.add(new UserEntry(player));
        }
        this.method_25314(newEntries);
        if (prevScroll != null) {
            this.method_25307(prevScroll);
        } else {
            for (int i = 0; i < this.method_25396().size(); ++i) {
                UserEntry entry = (UserEntry)this.method_25326(i);
                if (!entry.player.isMe()) continue;
                this.method_25307(this.field_22741 * class_3532.method_15340((int)(i - 6), (int)0, (int)138));
                return;
            }
            this.method_25307(0.0);
        }
    }

    public class UserEntry
    extends class_4265.class_4266<UserEntry> {
        private final ArrayList<? extends class_364> children = Lists.newArrayList();
        private final LeaderboardPlayer player;
        private class_238 flagBox = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

        public UserEntry(LeaderboardPlayer player) {
            this.player = player;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            String scoreText;
            class_327 textRenderer = class_310.method_1551().field_1772;
            textRenderer.method_27517(matrices, (class_5348)BasePlayer.getTextFromEloRank(UserLeaderboardWidget.this.phaseMode || UserLeaderboardWidget.this.displayIndex ? index + 1 : this.player.getSeasonResult().getEloRank()), (float)x, (float)y, 0xFFFFFF);
            int xOffset = x + 32;
            class_2338 flagPos = new class_2338(xOffset, y + 1, 0);
            if (!((Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_FLAGS_FROM_LEADERBOARD)).booleanValue() && PlayerCountry.renderCountryFlag(this.player.getCountry(), matrices, flagPos.method_10263(), flagPos.method_10264(), 9, 6, UserLeaderboardWidget.this.currentScreen, mouseX, mouseY)) {
                this.flagBox = new class_238(flagPos, flagPos.method_10069(9, 6, 1));
                xOffset += 12;
            }
            BasePlayer.renderNickname(matrices, xOffset, y, this.player, UserLeaderboardWidget.this.currentScreen, mouseX, mouseY);
            if (UserLeaderboardWidget.this.phaseMode) {
                scoreText = String.valueOf(this.player.getSeasonResult().getPhasePoint());
                textRenderer.method_1720(matrices, scoreText, (float)(x + entryWidth - textRenderer.method_1727(scoreText)), (float)y, 0xFFFFFF);
                TextureUtils.renderPhasePointIcon(matrices, x + entryWidth - textRenderer.method_1727(scoreText) - 10, y, 8);
            } else {
                scoreText = BasePlayer.getTextFromEloRate(this.player.getSeasonResult().getEloRate());
                textRenderer.method_27517(matrices, (class_5348)scoreText, (float)(x + entryWidth - textRenderer.method_27525((class_5348)scoreText)), (float)y, 0xFFFFFF);
            }
            if (this.player.isMe()) {
                class_310.method_1551().method_1531().method_22813(TRIAL_ICON);
                int o = (class_156.method_658() / 800L & 1L) == 1L ? 8 : 0;
                class_332.method_25293((class_4587)matrices, (int)(x - 12), (int)y, (int)8, (int)8, (float)0.0f, (float)o, (int)8, (int)8, (int)8, (int)16);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean isClicked = super.method_25402(mouseX, mouseY, button);
            ClientUtils.playSound(class_3417.field_15015, 1.0f, 0.25f);
            if (this.flagBox.method_1008(mouseX, mouseY, 0.0)) {
                class_310.method_1551().method_1507((class_437)new EloLeaderboardScreen(UserLeaderboardWidget.this.currentScreen.getParent(), this.player.getCountry()));
            } else {
                class_310.method_1551().method_1507((class_437)new UserProfileScreen(this.player.getUUIDString(), UserLeaderboardWidget.this.currentScreen));
            }
            return isClicked;
        }
    }
}

