/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.UserMatchInfoScreen;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.match.server.BaseMatchData;
import com.mcsrranked.client.info.match.server.EloChange;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.ClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UserMatchListWidget
extends class_4265<MatchEntry>
implements RankedEntryListWidget {
    private final RankedScreen screen;
    private final BasePlayer playerProfile;

    public UserMatchListWidget(class_310 minecraftClient, RankedScreen currentScreen, BasePlayer playerProfile) {
        super(minecraftClient, currentScreen.field_22789, currentScreen.field_22790, 36, currentScreen.field_22790 - 60, 11);
        this.screen = currentScreen;
        this.playerProfile = playerProfile;
    }

    public int method_25322() {
        return super.method_25322() + 80;
    }

    protected int method_25329() {
        return super.method_25329() + 40;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        MatchEntry matchEntry = (MatchEntry)this.method_25308(mouseX, mouseY);
        if (matchEntry != null && this.method_25405(mouseX, mouseY)) {
            ArrayList texts = Lists.newArrayList();
            if (!matchEntry.matchData.isDecayed()) {
                BasePlayer player = matchEntry.matchData.getResult().getWinner(matchEntry.matchData);
                texts.add(new class_2588("projectelo.text.match.winner").method_27693(": ").method_10852((class_2561)(player != null ? new class_2585(player.getNickname()).method_27692(class_124.field_1054) : new class_2588("projectelo.text.match.draw").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))));
                texts.add(new class_2588("projectelo.text.match.final_time").method_27693(": ").method_10852((class_2561)new class_2585(InGameTimerUtils.timeToStringFormat((long)matchEntry.matchData.getResult().getTime())).method_27692(class_124.field_1075)));
                texts.add(class_2585.field_24366);
                texts.add(new class_2588("projectelo.text.match.match_players").method_27693(":"));
            } else {
                texts.add(new class_2588("projectelo.tooltip.elo_decay").method_27692(class_124.field_1080));
            }
            int players = 0;
            for (BasePlayer player : matchEntry.matchData.getPlayers()) {
                if (players >= 8) {
                    texts.add(new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.tooltip.and_more_players", new Object[]{String.valueOf(matchEntry.matchData.getPlayers().size() - players)}).method_27692(class_124.field_1056)));
                    break;
                }
                ++players;
                class_2585 playerText = new class_2585("- " + player.getNickname() + " ");
                EloChange eloChange = matchEntry.matchData.getEloChangeByUUID(player.getUUID());
                if (eloChange != null && eloChange.getEloRate() != null) {
                    int score = eloChange.getChange();
                    class_5250 scoreText = new class_2585("(" + (score < 0 ? "-" : (score > 0 ? "+" : "")) + Math.abs(score) + " from " + eloChange.getEloRate() + ")").method_27692(score < 0 ? class_124.field_1061 : class_124.field_1060);
                    playerText = playerText.method_10852((class_2561)scoreText);
                }
                texts.add(playerText);
            }
            if (matchEntry.canOpen()) {
                texts.add(class_2585.field_24366);
                texts.add(new class_2585("(").method_10852((class_2561)new class_2588("projectelo.tooltip.click_to_open_match_info")).method_27693(")").method_27692(class_124.field_1054));
            }
            this.screen.method_25417(matrices, texts, mouseX, mouseY);
        }
    }

    public void updateMatchList(List<BaseMatchData> matchResults) {
        this.method_25314(matchResults.stream().map(x$0 -> new MatchEntry((BaseMatchData)x$0)).collect(Collectors.toList()));
    }

    public class MatchEntry
    extends class_4265.class_4266<MatchEntry> {
        private final List<? extends class_364> elements = Lists.newArrayList();
        private final BaseMatchData matchData;
        private final class_310 client;
        private final class_437 screen;

        public MatchEntry(BaseMatchData matchData) {
            this.matchData = matchData;
            this.client = UserMatchListWidget.this.field_22740;
            this.screen = UserMatchListWidget.this.screen;
        }

        public List<? extends class_364> method_25396() {
            return this.elements;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.screen.method_27535(matrices, this.client.field_1772, (class_5348)new class_2588(this.matchData.getType().getKey()).method_27693(" - ").method_10852((class_2561)(this.matchData.isDecayed() ? new class_2588("projectelo.text.match.decay").method_27692(class_124.field_1080) : (this.matchData.getResult().getWinner() == null ? new class_2588("projectelo.text.match.draw").method_27692(class_124.field_1080) : (this.matchData.getResult().getWinner().equals(UserMatchListWidget.this.playerProfile.getUUID()) ? new class_2588("projectelo.text.match.win").method_27692(class_124.field_1060) : new class_2588("projectelo.text.match.lose").method_27692(class_124.field_1061))))), x, y, 0xFFFFFF);
            class_5250 finalTimeText = this.matchData.isForfeited() ? new class_2588("projectelo.text.match.forfeited").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}) : (!Objects.equals(this.matchData.getResult().getWinner(), UserMatchListWidget.this.playerProfile.getUUID()) ? new class_2585(" - ").method_27692(class_124.field_1080) : new class_2585(InGameTimerUtils.timeToStringFormat((long)this.matchData.getResult().getTime())).method_27692(class_124.field_1075));
            int timeTextWidth = this.client.field_1772.method_27525((class_5348)finalTimeText);
            int timeOffsetX = x + (entryWidth - timeTextWidth) / 2;
            this.screen.method_27535(matrices, this.client.field_1772, (class_5348)finalTimeText, timeOffsetX, y, 0xFFFFFF);
            this.matchData.getSeedType().renderIcon(matrices, timeOffsetX + timeTextWidth + 3, y, 8, 8);
            class_2585 dateTimeFormat = new class_2585(ClientUtils.timeToDurationFormat(this.matchData.getDate().getTime()));
            this.screen.method_27535(matrices, this.client.field_1772, (class_5348)dateTimeFormat, x + entryWidth - this.client.field_1772.method_27525((class_5348)dateTimeFormat), y, 0xFFFFFF);
        }

        public boolean canOpen() {
            return !this.matchData.isDecayed() && !this.matchData.getPlayers().isEmpty();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            super.method_25402(mouseX, mouseY, button);
            if (this.canOpen()) {
                ClientUtils.playSound(class_3417.field_15015, 1.0f, 0.25f);
                this.client.method_1507((class_437)new UserMatchInfoScreen(this.screen, this.matchData.getID()));
            }
            return false;
        }
    }
}

