/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class OptionSliderWidget
extends class_357 {
    private final Supplier<class_2561> messageUpdater;
    private final Consumer<Double> updateValue;
    private final double minValue;
    private final double maxValue;
    private final Supplier<List<? extends class_5348>> tooltipSupplier;
    private Double steps = null;

    public OptionSliderWidget(Supplier<class_2561> messageUpdater, Consumer<Double> updateValue, double optionValue, double minValue, double maxValue) {
        this(messageUpdater, updateValue, optionValue, minValue, maxValue, ImmutableList::of);
    }

    public OptionSliderWidget(Supplier<class_2561> messageUpdater, Consumer<Double> updateValue, double optionValue, double minValue, double maxValue, class_2561 text) {
        this(messageUpdater, updateValue, optionValue, minValue, maxValue, () -> Lists.newArrayList((Object[])new class_2561[]{text}));
    }

    public OptionSliderWidget(Supplier<class_2561> messageUpdater, Consumer<Double> updateValue, double optionValue, double minValue, double maxValue, Supplier<List<? extends class_5348>> tooltipSupplier) {
        super(0, 0, 0, 20, messageUpdater.get(), class_3532.method_15350((double)((optionValue - minValue) / (maxValue - minValue)), (double)0.0, (double)1.0));
        this.messageUpdater = messageUpdater;
        this.updateValue = updateValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.tooltipSupplier = tooltipSupplier;
    }

    public OptionSliderWidget setDimension(int x, int y, int width) {
        this.field_22760 = x;
        this.field_22761 = y;
        this.field_22758 = width;
        return this;
    }

    public OptionSliderWidget setSteps(double steps) {
        this.steps = steps;
        return this;
    }

    protected void method_25346() {
        this.method_25355(this.messageUpdater.get());
    }

    protected void method_25344() {
        double resultValue = this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
        this.updateValue.accept(this.steps != null ? (double)Math.round(resultValue / this.steps) * this.steps : resultValue);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.field_22760 && mouseY >= (double)this.field_22761 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
        List<? extends class_5348> supplierList = this.tooltipSupplier.get();
        if (supplierList.isEmpty()) {
            return;
        }
        ArrayList toolTipList = Lists.newArrayList();
        class_310 client = class_310.method_1551();
        for (class_5348 class_53482 : supplierList) {
            toolTipList.addAll(client.field_1772.method_1728(class_53482, (int)((float)client.method_22683().method_4486() * 0.7f)));
        }
        if (client.field_1755 != null) {
            client.field_1755.method_25417(matrices, (List)toolTipList, mouseX, mouseY);
        }
    }
}

