/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match;

import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.player.BasePlayer;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public enum MatchSplit {
    COMPLETE_MATCH("projectelo.timeline.complete", 48, 48, false),
    FORFEIT_MATCH("projectelo.timeline.forfeit", -1, -1, false),
    LEAVE_MATCH("projectelo.timeline.leave", -1, -1, false),
    ENTER_END("story.enter_the_end", 32, 48, true),
    EYE_SPY("story.follow_ender_eye", 16, 48, true),
    BLINDED("projectelo.timeline.blind_travel", 0, 48, true),
    ENTER_FORTRESS("nether.find_fortress", 48, 32, true),
    ENTER_BASTION("nether.find_bastion", 32, 32, true),
    ENTER_NETHER("story.enter_the_nether", 16, 32, true),
    RESET_WORLD("projectelo.timeline.reset", 0, 32, true),
    SCOUTING("projectelo.timeline.scout", -1, -1, true),
    STARTED("projectelo.timeline.started", 0, 32, true);

    private final String type;
    private final int u;
    private final int v;
    private final boolean display;

    private MatchSplit(String type, int u, int v, boolean display) {
        this.type = type;
        this.u = u;
        this.v = v;
        this.display = display;
    }

    @Nullable
    public static MatchSplit fromTimeline(MatchTimeline timeline) {
        for (MatchSplit value : MatchSplit.values()) {
            if (!Objects.equals(value.type, timeline.getType())) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static MatchSplit fromString(String string) {
        for (MatchSplit value : MatchSplit.values()) {
            if (!Objects.equals(value.type, string)) continue;
            return value;
        }
        return null;
    }

    public static MatchSplit getSplit(Collection<MatchTimeline> timelineList, BasePlayer player) {
        MatchSplit split = STARTED;
        for (MatchTimeline matchTimeline : timelineList) {
            MatchSplit newSplit;
            if (!matchTimeline.getUUID().equals(player.getUUID()) || (newSplit = MatchSplit.fromTimeline(matchTimeline)) == null) continue;
            split = newSplit;
        }
        return split;
    }

    public class_2588 getText() {
        return new class_2588("projectelo.player.status." + this.name().toLowerCase(Locale.ROOT));
    }

    public String getTeleportText() {
        return class_1074.method_4662((String)("projectelo.player.teleport." + this.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
    }

    public String getType() {
        return this.type;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public boolean shouldDisplay() {
        return this.display;
    }
}

