/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.utils.UUIDUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class MatchTimeline {
    private final String uuid;
    private final String type;
    private final long time;
    private final List<String> data = Lists.newArrayList();
    private final boolean shown;

    public MatchTimeline(SocketEvent payload) {
        this.uuid = payload.getNextString();
        this.type = payload.getNextString();
        this.time = payload.getNextLong();
        for (JsonElement jsonElement : payload.getNextJsonArray()) {
            this.data.add(jsonElement.isJsonNull() ? null : jsonElement.getAsString());
        }
        this.shown = payload.getNextBoolean();
    }

    public UUID getUUID() {
        return UUIDUtils.fromString(this.uuid);
    }

    public long getTime() {
        return this.time;
    }

    public int getTick() {
        return class_3532.method_15386((float)((float)this.getTime() / 50.0f));
    }

    public String getType() {
        return this.type;
    }

    public List<String> getData() {
        return this.data;
    }

    public boolean isShown() {
        return this.shown;
    }

    public boolean isReset() {
        return Objects.equals(this.getType(), "projectelo.timeline.reset");
    }

    public boolean isComplete() {
        return Objects.equals(this.getType(), "projectelo.timeline.complete");
    }

    public boolean isEliminate() {
        return Objects.equals(this.getType(), "projectelo.timeline.eliminate");
    }

    public boolean isAdvancement() {
        return !this.getType().startsWith("projectelo");
    }

    public boolean isAdvancementRoot() {
        return this.isAdvancement() && this.getType().endsWith(".root");
    }

    public class_5250 getText(String nickname) {
        if (this.isComplete()) {
            return new class_2588(this.getType(), new Object[]{nickname, this.getData().get(0), InGameTimerUtils.timeToStringFormat((long)Long.parseLong(this.getData().get(1)))}).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
        }
        if (!this.isAdvancement()) {
            return new class_2588(this.getType(), new Object[]{nickname}).method_27692(class_124.field_1080);
        }
        return new class_2588("chat.type.advancement.task", new Object[]{nickname, new class_2585("[" + class_1074.method_4662((String)("advancements." + this.getType() + ".title"), (Object[])new Object[0]) + "]").method_27692(class_124.field_1056)}).method_27692(class_124.field_1080);
    }

    public class_5250 getCompactText(String nickname) {
        if (this.isComplete()) {
            return new class_2588(this.getType() + ".compact", new Object[]{nickname, this.getData().get(0), InGameTimerUtils.timeToStringFormat((long)Long.parseLong(this.getData().get(1)))}).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
        }
        if (!this.isAdvancement()) {
            return new class_2588(this.getType() + ".compact", new Object[]{nickname}).method_27692(class_124.field_1080);
        }
        return new class_2585(nickname + " - Complete: ").method_10852((class_2561)new class_2588("advancements." + this.getType() + ".title").method_27692(class_124.field_1056)).method_27692(class_124.field_1080);
    }
}

