/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.online;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.gamemode.DefaultGameMode;
import com.mcsrranked.client.info.match.online.gamemode.GameMode;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.utils.EasyBitFlag;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.Nullable;

public class MatchOption {
    @Nullable
    private String overworldSeed = null;
    @Nullable
    private String netherSeed = null;
    @Nullable
    private String theEndSeed = null;
    @Nullable
    private String rngSeed = null;
    private final MatchFlag flag = new MatchFlag(0);
    private String category = RunCategories.ANY.getID();
    @Nullable
    private String command = null;
    @Nullable
    private String roomName = null;
    @Nullable
    private String waitingImageUrl = null;
    private boolean availableFakePlayer = false;
    private int fakePlayerLevel = 0;
    private int completions = 0;
    private int timeLimit = 0;
    private int timeAttack = 0;
    private final EasyBitFlag seedType = new EasyBitFlag(0);
    private GameMode gameMode = new DefaultGameMode();

    public MatchOption(SocketEvent payload) {
        String seed = payload.getNextString();
        this.overworldSeed = seed == null || seed.isEmpty() ? null : new String(Base64.getDecoder().decode(seed), StandardCharsets.UTF_8);
        seed = payload.getNextString();
        this.netherSeed = seed == null || seed.isEmpty() ? null : new String(Base64.getDecoder().decode(seed), StandardCharsets.UTF_8);
        seed = payload.getNextString();
        this.theEndSeed = seed == null || seed.isEmpty() ? null : new String(Base64.getDecoder().decode(seed), StandardCharsets.UTF_8);
        seed = payload.getNextString();
        this.rngSeed = seed == null || seed.isEmpty() ? null : new String(Base64.getDecoder().decode(seed), StandardCharsets.UTF_8);
        this.availableFakePlayer = payload.getNextBoolean();
        this.fakePlayerLevel = payload.getNextInteger();
        this.flag.setFlagValue(payload.getNextInteger());
        this.category = payload.getNextString();
        this.command = payload.getNextString();
        this.roomName = payload.getNextString();
        this.waitingImageUrl = payload.getNextString();
        this.completions = payload.getNextInteger();
        this.timeLimit = payload.getNextInteger();
        this.timeAttack = payload.getNextInteger();
        this.seedType.setFlagValue(payload.getNextInteger());
        this.gameMode = GameMode.getFromPayload(payload);
    }

    public MatchOption() {
    }

    @Nullable
    public String getOverworldSeed() {
        if (this.overworldSeed == null || this.overworldSeed.trim().isEmpty()) {
            return null;
        }
        return this.overworldSeed;
    }

    public void setOverworldSeed(@Nullable String overworldSeed) {
        this.overworldSeed = overworldSeed;
    }

    @Nullable
    public String getNetherSeed() {
        if (this.netherSeed == null || this.netherSeed.trim().isEmpty()) {
            return null;
        }
        return this.netherSeed;
    }

    public void setNetherSeed(@Nullable String netherSeed) {
        this.netherSeed = netherSeed;
    }

    @Nullable
    public String getTheEndSeed() {
        if (this.theEndSeed == null || this.theEndSeed.trim().isEmpty()) {
            return null;
        }
        return this.theEndSeed;
    }

    public void setTheEndSeed(@Nullable String theEndSeed) {
        this.theEndSeed = theEndSeed;
    }

    @Nullable
    public String getRNGSeed() {
        if (this.rngSeed == null || this.rngSeed.trim().isEmpty()) {
            return null;
        }
        return this.rngSeed;
    }

    public void setRNGSeed(@Nullable String rngSeed) {
        this.rngSeed = rngSeed;
    }

    public boolean isSetSeed() {
        return this.getOverworldSeed() != null || this.getNetherSeed() != null || this.getTheEndSeed() != null;
    }

    public MatchFlag getFlag() {
        return this.flag;
    }

    public EasyBitFlag getSeedType() {
        return this.seedType;
    }

    public RunCategory getCategory() {
        RunCategory result = RunCategory.getCategory((String)this.category);
        if (result == RunCategories.ERROR_CATEGORY) {
            return RunCategories.ANY;
        }
        return result;
    }

    public void setCategory(RunCategory category) {
        this.category = category.getID();
    }

    @Nullable
    public String getCommand() {
        if (this.command == null || this.command.isEmpty()) {
            return null;
        }
        return this.command;
    }

    public void setCommand(@Nullable String command) {
        this.command = command;
    }

    @Nullable
    public String getRoomName() {
        if (this.roomName == null || this.roomName.isEmpty()) {
            return null;
        }
        return this.roomName;
    }

    public void setRoomName(@Nullable String roomName) {
        this.roomName = roomName;
    }

    public int getCompletions() {
        return this.completions;
    }

    public void setCompletions(int completions) {
        this.completions = completions;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeAttack() {
        return this.timeAttack;
    }

    public void setTimeAttack(int timeAttack) {
        this.timeAttack = timeAttack;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public boolean canActiveFakePlayer() {
        return this.getFlag().isEnableFlag(MatchFlag.Type.FILTERED_SEED) && !this.isSetSeed() && this.getCategory() == RunCategories.ANY && this.getGameMode() instanceof DefaultGameMode;
    }

    public boolean isAvailableFakePlayer() {
        return this.availableFakePlayer;
    }

    public void setAvailableFakePlayer(boolean availableFakePlayer) {
        this.availableFakePlayer = availableFakePlayer;
    }

    public int getFakePlayerLevel() {
        return this.fakePlayerLevel;
    }

    public void setFakePlayerLevel(int fakePlayerLevel) {
        this.fakePlayerLevel = fakePlayerLevel;
    }

    @Nullable
    public String getWaitingImageUrl() {
        return this.waitingImageUrl;
    }

    public void setWaitingImageUrl(@Nullable String waitingImageUrl) {
        this.waitingImageUrl = waitingImageUrl;
    }

    public MatchOption copy() {
        return (MatchOption)MCSRRankedClient.GSON.fromJson(MCSRRankedClient.GSON.toJson((Object)this), MatchOption.class);
    }
}

