/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.online;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.Replay;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.info.RunTimer;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.LocalData;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.MatchOption;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineMatchResult;
import com.mcsrranked.client.info.match.online.PlayLog;
import com.mcsrranked.client.info.match.online.gamemode.ScoutRouteGameMode;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerPermission;
import com.mcsrranked.client.info.player.PlayerStatus;
import com.mcsrranked.client.remote.ReplayRemoteFrame;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class OnlineMatch {
    private static ReplayRemoteFrame REPLAY_REMOTE_FRAME = null;
    private final MatchType matchType;
    @Nullable
    private final String code;
    private final List<OnlinePlayer> players = Lists.newCopyOnWriteArrayList();
    @Nullable
    private final OnlinePlayer host;
    private final Set<OnlinePlayer> coHostList = Sets.newCopyOnWriteArraySet();
    private final int maxPlayers;
    @Nullable
    private final PlayerPermission permission;
    private final Set<OnlinePlayer> pendingPlayers = Sets.newCopyOnWriteArraySet();
    private Replay replay;
    private MatchOption matchOption;
    private boolean chatDisabled = false;
    private boolean readyToStart = false;
    private boolean joinRequest = false;
    private MatchStatus status = MatchStatus.IDLE;
    private FileOutputStream replayStream = null;
    private CompletableFuture<Void> replayFuture = null;
    private final Map<MatchStatus, Long> eachSystemTime = Maps.newConcurrentMap();
    private final Map<OnlinePlayer, PlayLog> playLogMap = Maps.newConcurrentMap();
    private final List<MatchTimeline> timelines = Lists.newCopyOnWriteArrayList();
    private long startTime = 0L;
    private int currentVoteType = -1;
    private boolean canSeedChange = true;
    private boolean clickedVote = false;
    private boolean voting = false;
    private boolean blockBehaviors = false;
    private OnlineMatchResult matchResult = null;
    private boolean updateMark = false;
    private Long forfeitTimer = null;
    private int drawVoteTime = 270;
    private LocalData localData = new LocalData();
    private RunTimer runTimer = new RunTimer();

    public static Optional<ReplayRemoteFrame> getRemoteFrame() {
        return Optional.ofNullable(REPLAY_REMOTE_FRAME);
    }

    public static void init() {
        if (REPLAY_REMOTE_FRAME == null && class_156.method_668() == class_156.class_158.field_1133 && !GraphicsEnvironment.isHeadless()) {
            REPLAY_REMOTE_FRAME = new ReplayRemoteFrame();
        }
    }

    public OnlineMatch(MatchType matchType, @Nullable String code, List<OnlinePlayer> players, @Nullable OnlinePlayer host, Set<OnlinePlayer> coHostList, String replaySignedKey, int maxPlayers, @Nullable PlayerPermission permission, MatchOption matchOption) {
        this.matchType = matchType;
        this.code = code;
        this.host = host;
        this.replay = new Replay(replaySignedKey);
        this.maxPlayers = maxPlayers;
        this.permission = permission;
        this.matchOption = matchOption;
        this.coHostList.addAll(coHostList);
        for (OnlinePlayer player : players) {
            this.addPlayer(player);
        }
    }

    public MatchType getType() {
        return this.matchType;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    public List<OnlinePlayer> getPlayers() {
        return this.players;
    }

    public List<OnlinePlayer> getPlayersExcludeSpectator() {
        ArrayList nonSpectators = Lists.newArrayList();
        for (OnlinePlayer player : this.getPlayers()) {
            if (player.isSpectator()) continue;
            nonSpectators.add(player);
        }
        return nonSpectators;
    }

    public Set<OnlinePlayer> getPendingPlayers() {
        return this.pendingPlayers;
    }

    public List<OnlinePlayer> getSpectators() {
        ArrayList spectators = Lists.newArrayList();
        for (OnlinePlayer player : this.getPlayers()) {
            if (!player.isSpectator()) continue;
            spectators.add(player);
        }
        return spectators;
    }

    public void addPlayer(OnlinePlayer player) {
        this.players.add(player);
        if (!player.isSpectator()) {
            this.getReplay().addOpponentPlayer(player);
        }
        if (this.getType() == MatchType.RANKED && (player.isAnonymous() || SpeedRunOption.getOption(RankedOptions.HIDE_OPPONENT_PROFILE) != RankedOptions.HideProfileType.NEVER) && !player.isMe()) {
            player.setHideOnClient(true);
        }
        this.playLogMap.put(player, new PlayLog());
    }

    public void removePlayer(OnlinePlayer player) {
        this.players.remove(player);
        this.coHostList.remove(player);
        this.getReplay().removeOpponentPlayer(player);
        this.playLogMap.remove(player);
    }

    @Nullable
    public OnlinePlayer getHost() {
        return this.host;
    }

    public Set<OnlinePlayer> getCoHostList() {
        return this.coHostList;
    }

    public <T> T checkPermission(Function<PlayerPermission, T> function, T defValue) {
        return this.permission != null ? function.apply(this.permission) : defValue;
    }

    public Replay getReplay() {
        return this.replay;
    }

    public boolean canSeedChange() {
        return this.canSeedChange;
    }

    public void setCanSeedChange(boolean canSeedChange) {
        this.canSeedChange = canSeedChange;
    }

    public boolean isVoting() {
        return this.voting;
    }

    public void setVoting(boolean voting) {
        this.voting = voting;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setOption(MatchOption matchOption) {
        this.matchOption = matchOption;
    }

    public MatchOption getOption() {
        return this.matchOption;
    }

    public MatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(MatchStatus status) {
        this.status = status;
        if (REPLAY_REMOTE_FRAME != null) {
            SwingUtilities.invokeLater(() -> {
                if (MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
                    if (status == MatchStatus.START_GEN && REPLAY_REMOTE_FRAME != null && !REPLAY_REMOTE_FRAME.isVisible()) {
                        REPLAY_REMOTE_FRAME.setVisible(true);
                        REPLAY_REMOTE_FRAME.setAlwaysOnTop(true);
                        REPLAY_REMOTE_FRAME.syncReplay(this, this.replay.getReplayProcessor());
                    }
                    if (status == MatchStatus.END && REPLAY_REMOTE_FRAME != null) {
                        REPLAY_REMOTE_FRAME.setAlwaysOnTop(false);
                        REPLAY_REMOTE_FRAME.toBack();
                        REPLAY_REMOTE_FRAME.reset();
                    }
                }
            });
        }
    }

    public boolean isChatDisabled() {
        return this.chatDisabled;
    }

    public void setChatDisabled(boolean chatDisabled) {
        this.chatDisabled = chatDisabled;
    }

    public boolean isJoinRequest() {
        return this.joinRequest;
    }

    public void setJoinRequest(boolean joinRequest) {
        this.joinRequest = joinRequest;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    public void setReadyToStart(boolean readyToStart) {
        this.readyToStart = readyToStart;
    }

    public Long getEachTime(MatchStatus status) {
        return this.eachSystemTime.getOrDefault((Object)status, null);
    }

    public void setEachTime(MatchStatus status, long time) {
        this.eachSystemTime.put(status, time);
    }

    public boolean isHost(OnlinePlayer player) {
        return player.equals(this.host);
    }

    public boolean isHost() {
        return this.isHost(MCSRRankedClient.LOCAL_PLAYER);
    }

    public boolean canManage() {
        return this.canManage(MCSRRankedClient.LOCAL_PLAYER);
    }

    public boolean canManage(OnlinePlayer player) {
        return this.isHost(player) || this.isCoHost(player);
    }

    public boolean isCoHost(OnlinePlayer player) {
        return this.coHostList.contains(player);
    }

    public void addCoHost(OnlinePlayer player) {
        this.coHostList.add(player);
    }

    public void removeCoHost(OnlinePlayer player) {
        this.coHostList.remove(player);
    }

    public class_2561 getDisplayName() {
        String name = this.getOption().getRoomName();
        if (name == null) {
            if (this.getType() == MatchType.EVENT && MCSRRankedClient.CURRENT_EVENT != null) {
                return class_2561.method_30163((String)MCSRRankedClient.CURRENT_EVENT.getName());
            }
            return new class_2588(this.getType().getKey());
        }
        return class_2561.method_30163((String)name);
    }

    public void updateWorldGenProgress(OnlinePlayer player, int value) {
        this.getPlayLog(player).setWorldGenProgress(value);
    }

    public int getWorldGeneratingPlayer(OnlinePlayer player) {
        return this.getPlayLog(player).getWorldGenProgress();
    }

    public List<Map.Entry<OnlinePlayer, PlayLog>> getWorldGeneratingPlayers() {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<OnlinePlayer, PlayLog> entry : this.playLogMap.entrySet()) {
            if (entry.getValue().getWorldGenProgress() == 100 || entry.getKey().isMe()) continue;
            entries.add(entry);
        }
        return entries;
    }

    public List<MatchTimeline> getTimelines() {
        return this.timelines;
    }

    public void addTimeline(MatchTimeline timeline) {
        this.timelines.add(timeline);
    }

    public PlayLog getPlayLog(OnlinePlayer player) {
        if (!this.playLogMap.containsKey(player)) {
            this.playLogMap.put(player, new PlayLog());
        }
        return this.playLogMap.getOrDefault(player, new PlayLog());
    }

    public void updateSplit(OnlinePlayer player, MatchSplit split, long time) {
        this.getPlayLog(player).updateSplit(split, time);
        if (split == MatchSplit.COMPLETE_MATCH) {
            this.getLocalData().setFirstCompletionTime(time);
        }
        this.getRunTimer().setSessionTimeLimit(this.getTimeLimit());
    }

    public boolean markAsUpdate() {
        return this.updateMark;
    }

    public void markAsUpdate(boolean updateMark) {
        this.updateMark = updateMark;
    }

    public void updateInventory(OnlinePlayer player, String data) {
        this.getPlayLog(player).updateInventory(data);
    }

    public void updateReplay(byte[] data) throws Exception {
        if (this.replayStream == null) {
            this.replayStream = new FileOutputStream(MCSRRankedClient.TEMP_REPLAY_FILE);
        }
        Runnable updateRunnable = () -> {
            if (ClientUtils.hasEnoughSpaceForReplay()) {
                try {
                    byte[] lengthBytes = new byte[]{(byte)(data.length >>> 24), (byte)(data.length >>> 16), (byte)(data.length >>> 8), (byte)data.length};
                    this.replayStream.write(lengthBytes);
                    this.replayStream.write(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.replayFuture = this.replayFuture == null || this.replayFuture.isDone() ? CompletableFuture.runAsync(updateRunnable) : this.replayFuture.thenRun(updateRunnable);
        ByteBuffer buffer = ReplayManager.decryptByteBuffer(this.getReplay().getSecretKey(), data, true);
        UUID uuid = new UUID(buffer.getLong(), buffer.getLong());
        Optional<OpponentPlayerTracker> tracker = this.getReplay().getOpponentPlayerTracker(uuid);
        if (tracker.isPresent()) {
            tracker.get().receiveOpponentTimeLine(buffer);
        }
    }

    public int getVoteType() {
        if (this.getType() == MatchType.PRIVATE && !this.canManage()) {
            return -1;
        }
        if (!this.canManage() && this.getLocalData().hasForfeit()) {
            return -1;
        }
        if (this.getOption().isSetSeed()) {
            return -1;
        }
        if (this.shouldBlockBehaviors()) {
            return -1;
        }
        if (this.currentVoteType == -1) {
            long time = System.currentTimeMillis() - this.getStartTime();
            return (time >= 1000L * (long)this.getDrawVoteTime() || !this.getOption().getGameMode().enableSeedChange()) && !this.canManage() ? 1 : (!this.canSeedChange() ? -1 : 0);
        }
        return this.currentVoteType;
    }

    public void setVoteType(int currentVoteType) {
        this.currentVoteType = currentVoteType;
    }

    public boolean isClickedVote() {
        return this.clickedVote;
    }

    public void setClickedVote(boolean clickedVote) {
        this.clickedVote = clickedVote;
    }

    public boolean shouldBlockBehaviors() {
        return this.blockBehaviors;
    }

    public boolean isGameplayInteractable() {
        if (this.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            return !((ScoutRouteGameMode)this.getOption().getGameMode()).isScouting();
        }
        return true;
    }

    public boolean canResetWorld() {
        boolean basicCheck;
        boolean bl = basicCheck = !this.shouldBlockBehaviors() && !this.getLocalData().hasForfeit() && !this.getOption().getFlag().isEnableFlag(MatchFlag.Type.DISABLE_RESET);
        if (this.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            return basicCheck && (((ScoutRouteGameMode)this.getOption().getGameMode()).isAllowMultipleCompletions() || !this.getLocalData().hasCompleted());
        }
        return basicCheck && !this.getLocalData().hasCompleted();
    }

    public void setForfeitTimer(int seconds) {
        this.forfeitTimer = System.currentTimeMillis() + (long)seconds * 1000L;
    }

    public Long getForfeitTimer() {
        return this.forfeitTimer;
    }

    public void setDrawVoteTimer(int seconds) {
        this.drawVoteTime = seconds;
    }

    public int getDrawVoteTime() {
        return this.drawVoteTime;
    }

    public void setBlockBehaviors(boolean blockBehaviors) {
        this.blockBehaviors = blockBehaviors;
    }

    public void setResult(OnlineMatchResult matchResult) {
        this.matchResult = matchResult;
    }

    public OnlineMatchResult getResult() {
        return this.matchResult;
    }

    public LocalData getLocalData() {
        return this.localData;
    }

    public RunTimer getRunTimer() {
        return this.runTimer;
    }

    public long getTimeLimit() {
        long afterCompletion;
        long timeLimit = (long)this.getOption().getTimeLimit() * 1000L;
        if (this.getLocalData().getFirstCompletionTime() != null && this.getOption().getTimeAttack() > 0 && timeLimit > (afterCompletion = this.getLocalData().getFirstCompletionTime() + (long)this.getOption().getTimeAttack() * 1000L)) {
            return afterCompletion;
        }
        return timeLimit;
    }

    public void onComplete() {
        boolean netherite = false;
        boolean egap = false;
        boolean ironHoe = false;
        int level = 0;
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer != null) {
            ArrayList itemStacks = Lists.newArrayList();
            itemStacks.addAll(clientPlayer.field_7514.field_7548);
            itemStacks.addAll(clientPlayer.field_7514.field_7547);
            itemStacks.addAll(clientPlayer.field_7514.field_7544);
            for (class_1799 itemStack : itemStacks) {
                class_1792 item = itemStack.method_7909();
                if (item instanceof class_1738 && ((class_1738)item).method_7686() == class_1740.field_21977) {
                    netherite = true;
                }
                if (item == class_1802.field_22020) {
                    netherite = true;
                }
                if (item == class_1802.field_8367) {
                    egap = true;
                }
                if (item != class_1802.field_8609) continue;
                ironHoe = true;
            }
            level = clientPlayer.field_7520;
        }
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            ClientUtils.changeSpectate();
            ClientUtils.closeScreen();
        });
        this.getReplay().getPersonalPlayerTracker().stopTracking();
        this.getLocalData().setCompleted(true);
        SocketInstance.getInstance().emit("p$complete", this.getRunTimer().getIGT(), this.getLocalData().getMaxDragonDamage(), level, this.getLocalData().hasEquipArmor(), netherite, egap, ironHoe);
    }

    public CompletableFuture<Void> closeReplayStream() {
        Runnable close = () -> {
            try {
                Thread.sleep(10000L);
                if (this.replayStream != null) {
                    this.replayStream.close();
                }
                this.replayStream = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        return this.replayFuture == null ? CompletableFuture.runAsync(close) : this.replayFuture.thenRun(close);
    }

    public void reset() {
        this.eachSystemTime.clear();
        this.timelines.clear();
        for (OnlinePlayer player : this.getPlayers()) {
            this.updateWorldGenProgress(player, 0);
            this.playLogMap.put(player, new PlayLog());
            if (player.getStatus() == PlayerStatus.LEAVE) continue;
            player.setStatus(PlayerStatus.ONLINE);
        }
        this.setReadyToStart(false);
        this.setBlockBehaviors(false);
        this.setClickedVote(false);
        this.setVoting(false);
        this.setVoteType(-1);
        this.setResult(null);
        this.replay = new Replay(this.replay);
        this.localData = new LocalData();
        this.runTimer = new RunTimer();
        this.startTime = 0L;
        if (this.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ScoutRouteGameMode scout = (ScoutRouteGameMode)this.getOption().getGameMode();
            MatchSplit targetSplit = scout.isEnableFreeScout() || scout.isScouting() ? MatchSplit.SCOUTING : MatchSplit.STARTED;
            for (OnlinePlayer onlinePlayer : this.getPlayersExcludeSpectator()) {
                this.getPlayLog(onlinePlayer).updateSplit(targetSplit, 0L);
            }
        }
    }

    public void cleanUp() {
        this.removePlayer(OnlinePlayer.BOT_PLAYER);
        ArrayList offlinePlayers = Lists.newArrayList();
        for (OnlinePlayer player : this.getPlayers()) {
            if (!player.getStatus().isOnline()) {
                offlinePlayers.add(player);
            }
            player.setStatus(PlayerStatus.ONLINE);
        }
        for (OnlinePlayer offlinePlayer : offlinePlayers) {
            this.removePlayer(offlinePlayer);
        }
    }

    public void writeFile() {
        JsonObject matchJson = new JsonObject();
        matchJson.addProperty("matchType", this.getType().name());
        matchJson.addProperty("category", this.getOption().getCategory().getID());
        matchJson.addProperty("gameMode", this.getOption().getGameMode().getType());
        matchJson.addProperty("startTime", (Number)this.getStartTime());
        JsonArray playersJson = new JsonArray();
        ArrayList completes = Lists.newArrayList();
        JsonArray completesJson = new JsonArray();
        JsonObject inventoryJson = new JsonObject();
        for (OnlinePlayer player : this.getPlayers()) {
            playersJson.add(MCSRRankedClient.GSON.toJsonTree((Object)player, BasePlayer.class));
            if (this.getPlayLog(player).getCompletion() != 0L) {
                JsonObject finalTimeJson = new JsonObject();
                finalTimeJson.addProperty("player", player.getUUIDString());
                finalTimeJson.addProperty("time", (Number)this.getPlayLog(player).getCompletion());
                completes.add(finalTimeJson);
            }
            JsonObject playerJson = new JsonObject();
            for (Map.Entry<class_1792, Integer> entry : this.getPlayLog(player).getInventory().entrySet()) {
                playerJson.addProperty(class_2378.field_11142.method_10221((Object)entry.getKey()).method_12832(), (Number)entry.getValue());
            }
            inventoryJson.add(player.getUUIDString(), (JsonElement)playerJson);
        }
        matchJson.add("players", (JsonElement)playersJson);
        completes.sort(Comparator.comparingInt(o -> o.get("time").getAsInt()));
        for (JsonObject jsonObject : completes) {
            completesJson.add((JsonElement)jsonObject);
        }
        matchJson.add("completes", (JsonElement)completesJson);
        matchJson.add("inventories", (JsonElement)inventoryJson);
        JsonArray timelinesJson = new JsonArray();
        for (MatchTimeline timeline : this.getTimelines()) {
            timelinesJson.add(MCSRRankedClient.GSON.toJsonTree((Object)timeline));
        }
        matchJson.add("timelines", (JsonElement)timelinesJson);
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            try {
                FileUtils.writeStringToFile((File)MCSRRankedClient.GLOBAL_PATH.resolve("spectate_match.json").toFile(), (String)MCSRRankedClient.GSON.toJson((JsonElement)matchJson), (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }
}

