/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.online.gamemode;

import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.gamemode.DefaultGameMode;
import com.mcsrranked.client.info.match.online.gamemode.MostPercentGameMode;
import com.mcsrranked.client.info.match.online.gamemode.ScoutRouteGameMode;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.utils.RuntimeTypeAdapterFactory;
import com.mcsrranked.client.world.WorldCreator;
import com.redlimerl.speedrunigt.timer.InGameTimer;

public abstract class GameMode {
    public static final RuntimeTypeAdapterFactory<GameMode> GSON_ADAPTER = RuntimeTypeAdapterFactory.of(GameMode.class, "type").registerSubtype(ScoutRouteGameMode.class, "scout").registerSubtype(MostPercentGameMode.class, "most").registerSubtype(DefaultGameMode.class, "default");
    private final String type;

    public static GameMode getFromPayload(SocketEvent payload) {
        switch (payload.getNextString()) {
            case "most": {
                return new MostPercentGameMode(payload);
            }
            case "scout": {
                return new ScoutRouteGameMode(payload);
            }
        }
        return new DefaultGameMode();
    }

    public static GameMode nextGameMode(GameMode gameMode) {
        if (gameMode instanceof DefaultGameMode) {
            return new ScoutRouteGameMode();
        }
        if (gameMode instanceof ScoutRouteGameMode) {
            return new MostPercentGameMode();
        }
        return new DefaultGameMode();
    }

    public GameMode(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract String toDataString();

    public boolean enableSeedChange() {
        return true;
    }

    public void onTimerInitialize(InGameTimer timer, OnlineMatch match) {
        timer.setCategory(match.getOption().getCategory(), false);
        timer.setRTAMode(true);
        timer.setPause(true, "start the timer for elo");
        timer.setStartTime(match.getStartTime());
        match.getRunTimer().setStartTime(match.getStartTime());
        match.getRunTimer().setSessionTimeLimit(match.getTimeLimit());
        if (match.getOption().getFlag().isEnableFlag(MatchFlag.Type.IGT_MODE)) {
            match.getRunTimer().setAvailableFreePause(true);
        }
    }

    public void onAddTimeline(OnlineMatch onlineMatch, OnlinePlayer player) {
    }

    public void onBeforeJoinWorld(WorldCreator creator) {
    }
}

