/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.online.gamemode;

import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.gamemode.GameMode;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.utils.EasyBitFlag;
import java.util.HashSet;

public class MostPercentGameMode
extends GameMode {
    private int eliminationTime = 720;
    private int eliminationPlayers = 1;
    private boolean enableResetScore = true;
    private boolean enableDisplayScore = true;

    public MostPercentGameMode() {
        super("most");
    }

    public MostPercentGameMode(SocketEvent payload) {
        this();
        this.setEliminationTime(payload.getNextInteger());
        this.setEliminationPlayers(payload.getNextInteger());
        EasyBitFlag flags = new EasyBitFlag(payload.getNextInteger());
        this.setEnableResetScore(flags.includeValue(0));
        this.setEnableDisplayScore(flags.includeValue(1));
    }

    public int getEliminationTime() {
        return this.eliminationTime;
    }

    public int getEliminationPlayers() {
        return this.eliminationPlayers;
    }

    public void setEliminationTime(int eliminationTime) {
        this.eliminationTime = eliminationTime;
    }

    public void setEliminationPlayers(int eliminationPlayers) {
        this.eliminationPlayers = eliminationPlayers;
    }

    public void setEnableDisplayScore(boolean enableDisplayScore) {
        this.enableDisplayScore = enableDisplayScore;
    }

    public void setEnableResetScore(boolean enableResetScore) {
        this.enableResetScore = enableResetScore;
    }

    public boolean isEnableDisplayScore() {
        return this.enableDisplayScore;
    }

    public boolean isEnableResetScore() {
        return this.enableResetScore;
    }

    @Override
    public String toDataString() {
        return String.format("%s:%s:%s", this.getEliminationTime(), this.getEliminationPlayers(), EasyBitFlag.of(this.isEnableResetScore(), this.isEnableDisplayScore()).getFlagValue());
    }

    @Override
    public void onAddTimeline(OnlineMatch onlineMatch, OnlinePlayer player) {
        super.onAddTimeline(onlineMatch, player);
        HashSet<String> advancements = new HashSet<String>();
        for (MatchTimeline timeline : onlineMatch.getTimelines()) {
            if (!timeline.getUUID().equals(player.getUUID())) continue;
            if (timeline.isAdvancement()) {
                advancements.add(timeline.getType());
                continue;
            }
            if (!timeline.isReset() || !this.isEnableResetScore()) continue;
            advancements.clear();
        }
        onlineMatch.getPlayLog(player).setScore(advancements.size());
    }
}

