/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.server;

import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.OverworldSeedType;
import com.mcsrranked.client.info.match.server.EloChange;
import com.mcsrranked.client.info.match.server.MatchResult;
import com.mcsrranked.client.info.player.BasePlayer;
import com.redlimerl.speedrunigt.timer.category.RunCategory;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class BaseMatchData {
    private final int id;
    private final int type;
    private final int season;
    private final String category;
    private final int date;
    private final List<BasePlayer> players;
    private final List<BasePlayer> spectators;
    private final MatchResult result;
    private final boolean forfeited;
    private final boolean decayed;
    private final List<EloChange> changes;
    private final String seedType;

    public BaseMatchData(int id, int type, int season, String category, int date, List<BasePlayer> players, List<BasePlayer> spectators, MatchResult result, boolean forfeited, boolean decayed, List<EloChange> changes, String seedType) {
        this.id = id;
        this.type = type;
        this.season = season;
        this.category = category;
        this.date = date;
        this.players = players;
        this.spectators = spectators;
        this.result = result;
        this.forfeited = forfeited;
        this.decayed = decayed;
        this.changes = changes;
        this.seedType = seedType;
    }

    public int getID() {
        return this.id;
    }

    public OverworldSeedType getSeedType() {
        return OverworldSeedType.fromString(this.seedType);
    }

    public List<EloChange> getEloChanges() {
        return this.changes;
    }

    public EloChange getEloChangeByUUID(UUID uuid) {
        for (EloChange eloChange : this.getEloChanges()) {
            if (!eloChange.getUUID().equals(uuid)) continue;
            return eloChange;
        }
        return null;
    }

    public boolean isDecayed() {
        return this.decayed;
    }

    public boolean isForfeited() {
        return this.forfeited;
    }

    public MatchResult getResult() {
        return this.result;
    }

    public List<BasePlayer> getSpectators() {
        return this.spectators;
    }

    public List<BasePlayer> getPlayers() {
        return this.players;
    }

    public Date getDate() {
        return new Date((long)this.date * 1000L);
    }

    public RunCategory getCategory() {
        return RunCategory.getCategory((String)this.category);
    }

    public int getSeason() {
        return this.season;
    }

    public MatchType getType() {
        return MatchType.byID(this.type);
    }
}

