/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerCountry;
import com.mcsrranked.client.info.player.PlayerTier;
import com.mcsrranked.client.utils.TextureUtils;
import com.mcsrranked.client.utils.UUIDUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class BasePlayer {
    public static final class_2960 ROLE_ICONS = new class_2960("mcsrranked", "textures/gui/role_icons.png");
    private static final Map<Integer, Integer> ANIMATE_RANDOM_MAP = new HashMap<Integer, Integer>();
    private final String uuid;
    private transient String cleanUUID;
    private transient UUID strictUUID;
    private final String nickname;
    private final int roleType;
    @Nullable
    private Integer eloRate;
    @Nullable
    private final Integer eloRank;
    @Nullable
    private String country;

    protected BasePlayer(String uuid, String nickname, int roleType, @Nullable Integer eloRate, @Nullable Integer eloRank, @Nullable String country) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.roleType = roleType;
        this.eloRate = eloRate;
        this.eloRank = eloRank;
        this.country = country;
    }

    public String toString() {
        return MCSRRankedClient.GSON.toJson((Object)this, BasePlayer.class);
    }

    public UUID getUUID() {
        if (this.strictUUID == null) {
            this.strictUUID = UUIDUtils.fromString(this.getUUIDString());
        }
        return this.strictUUID;
    }

    public String getUUIDString() {
        if (this.cleanUUID == null) {
            this.cleanUUID = this.uuid.replaceAll("-", "");
        }
        return this.cleanUUID;
    }

    public String getNickname() {
        return this.nickname;
    }

    @Nullable
    public Integer getEloRate() {
        return this.eloRate;
    }

    public void setEloRate(@Nullable Integer eloRate) {
        this.eloRate = eloRate;
    }

    @Nullable
    public Integer getEloRank() {
        return this.eloRank;
    }

    public int getRoleType() {
        return this.roleType;
    }

    @Nullable
    public PlayerCountry getCountry() {
        return this.country == null ? null : PlayerCountry.of(this.country);
    }

    public void setCountryCode(@Nullable String country) {
        this.country = country;
    }

    public int getMaxAchievements() {
        int type = this.getRoleType();
        if (type == 2) {
            return 4;
        }
        if (type == 3) {
            return 5;
        }
        return 3;
    }

    public boolean isMe() {
        if (MCSRRankedClient.LOCAL_PLAYER == null) {
            return false;
        }
        return Objects.equals(this, MCSRRankedClient.LOCAL_PLAYER);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasePlayer) {
            return Objects.equals(this.getUUID(), ((BasePlayer)obj).getUUID());
        }
        return false;
    }

    public static class_5250 getTextFromEloRank(Integer eloRank) {
        if (eloRank == null) {
            return new class_2585("");
        }
        class_2585 text = new class_2585("#" + eloRank);
        if (eloRank == 1) {
            text.method_27692(class_124.field_1054);
        } else if (eloRank == 2) {
            text.method_27692(class_124.field_1080);
        } else if (eloRank == 3) {
            text.method_27692(class_124.field_1065);
        } else if (eloRank <= 10) {
            text.method_27692(class_124.field_1075);
        } else if (eloRank <= 25) {
            text.method_27692(class_124.field_1060);
        } else if (eloRank <= 50) {
            text.method_27692(class_124.field_1078);
        } else {
            text.method_27692(class_124.field_1068);
        }
        return text;
    }

    public static class_5250 getTextFromEloRate(Integer eloRate) {
        PlayerTier tier = PlayerTier.fromScore(eloRate);
        class_2585 text = new class_2585(eloRate == null ? "???" : String.valueOf(eloRate));
        return text.method_27692(tier.getFormatting());
    }

    public static int renderEloText(class_4587 matrixStack, int x, int y, Integer eloRate, Integer eloRank) {
        return BasePlayer.renderEloText(matrixStack, x, y, eloRate, eloRank, false);
    }

    public static int renderEloText(class_4587 matrixStack, int x, int y, Integer eloRate, Integer eloRank, boolean colored) {
        class_310 client = class_310.method_1551();
        RenderSystem.enableBlend();
        PlayerTier tier = PlayerTier.fromScore(eloRate);
        tier.renderBadge(matrixStack, x, y, 8, 8);
        int totalWidth = 10;
        class_5250 text = tier.getText();
        if (eloRate != null) {
            text = text.method_27693(" [").method_10852((class_2561)(colored ? BasePlayer.getTextFromEloRate(eloRate).method_27692(class_124.field_1054) : BasePlayer.getTextFromEloRate(eloRate))).method_27693("]");
        }
        if (eloRank != null) {
            text = text.method_27693(" ").method_10852((class_2561)BasePlayer.getTextFromEloRank(eloRank));
        }
        client.field_1772.method_27517(matrixStack, (class_5348)text, (float)(x + totalWidth), (float)y, 0xFFFFFF);
        RenderSystem.disableBlend();
        return totalWidth += client.field_1772.method_27525((class_5348)text);
    }

    public static int getEloTextWidth(Integer eloRate, Integer eloRank) {
        return BasePlayer.renderEloText(new class_4587(), -100, -100, eloRate, eloRank);
    }

    public static int renderNickname(class_4587 matrixStack, int x, int y, BasePlayer player) {
        return BasePlayer.renderNickname(matrixStack, x, y, player, -1);
    }

    public static int renderNickname(class_4587 matrixStack, int x, int y, BasePlayer player, int color) {
        return BasePlayer.renderNickname(matrixStack, x, y, player, color, null, 0, 0);
    }

    public static int renderNickname(class_4587 matrixStack, int x, int y, BasePlayer player, RankedScreen screen, int mouseX, int mouseY) {
        return BasePlayer.renderNickname(matrixStack, x, y, player, -1, screen, mouseX, mouseY);
    }

    public static int renderNickname(class_4587 matrixStack, int x, int y, BasePlayer player, int color, RankedScreen screen, int mouseX, int mouseY) {
        boolean mouseOvered;
        int width = 0;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_310.method_1551().method_1531().method_22813(ROLE_ICONS);
        boolean bl = mouseOvered = mouseX >= x && mouseX < x + 8 && mouseY >= y && mouseY < y + 8 && screen != null;
        if (player instanceof OnlinePlayer && ((OnlinePlayer)player).isSpectator()) {
            class_332.method_25290((class_4587)matrixStack, (int)(x * 2), (int)(y * 2), (float)0.0f, (float)48.0f, (int)16, (int)16, (int)128, (int)128);
            color = class_5253.class_5254.method_27763((int)color, (int)class_5253.class_5254.method_27764((int)255, (int)0, (int)255, (int)255));
            width = 10;
            if (mouseOvered) {
                screen.setTooltip(new class_2588("projectelo.tooltip.spectator_account"));
            }
        } else {
            int offset;
            ANIMATE_RANDOM_MAP.putIfAbsent(player.getUUIDString().hashCode(), new Random().nextInt(6000));
            int[] pattern = new int[]{1, 2, 3, 1, 5, 6, 7, 5};
            long elapsed = (System.currentTimeMillis() + (long)ANIMATE_RANDOM_MAP.get(player.getUUIDString().hashCode()).intValue()) % 6000L;
            int n = elapsed >= 5400L ? pattern[(int)((elapsed - 5400L) / 150L) + 4] : (offset = elapsed < 2400L || elapsed >= 3000L ? 0 : pattern[(int)((elapsed - 2400L) / 150L)]);
            if (player.getRoleType() == 1) {
                class_332.method_25290((class_4587)matrixStack, (int)(x * 2), (int)(y * 2), (float)(offset * 16), (float)32.0f, (int)16, (int)16, (int)128, (int)128);
                width = 10;
                if (mouseOvered) {
                    screen.setTooltip(new class_2585("Stone Pickaxe (Special Tier)"));
                }
            }
            if (player.getRoleType() == 2) {
                class_332.method_25290((class_4587)matrixStack, (int)(x * 2), (int)(y * 2), (float)(offset * 16), (float)16.0f, (int)16, (int)16, (int)128, (int)128);
                width = 10;
                if (mouseOvered) {
                    screen.setTooltip(new class_2585("Iron Pickaxe (Special Tier)"));
                }
            }
            if (player.getRoleType() == 3) {
                class_332.method_25290((class_4587)matrixStack, (int)(x * 2), (int)(y * 2), (float)(offset * 16), (float)0.0f, (int)16, (int)16, (int)128, (int)128);
                double timeDelta = (double)Math.abs(System.currentTimeMillis() % 4000L - 2000L) / 2000.0;
                color = class_5253.class_5254.method_27763((int)color, (int)class_5253.class_5254.method_27764((int)255, (int)255, (int)((int)(timeDelta * 55.0) + 200), (int)((int)(timeDelta * 255.0))));
                width = 10;
                if (mouseOvered) {
                    screen.setTooltip(new class_2585("Diamond Pickaxe (Special Tier)"));
                }
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        class_2585 text = new class_2585(player.getNickname());
        class_310.method_1551().field_1772.method_27517(matrixStack, (class_5348)text, (float)(x + width), (float)y, color);
        width += class_310.method_1551().field_1772.method_27525((class_5348)text);
        if (player instanceof OnlinePlayer && ((OnlinePlayer)player).isChatDisabled()) {
            TextureUtils.renderChatDisabledIcon(matrixStack, x + (width += 3), y, 8, alpha);
            width += 8;
        }
        RenderSystem.popMatrix();
        return width;
    }

    public static int getNicknameWidth(BasePlayer player) {
        int width = 0;
        if (player.getRoleType() != 0 || player instanceof OnlinePlayer && ((OnlinePlayer)player).isSpectator()) {
            width += 10;
        }
        if (player instanceof OnlinePlayer && ((OnlinePlayer)player).isChatDisabled()) {
            width += 11;
        }
        return width += class_310.method_1551().field_1772.method_1727(player.getNickname());
    }
}

