/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.PlayerStatus;
import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.interaction.PlayerMuteManager;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class OnlinePlayer
extends BasePlayer {
    public static final OnlinePlayer BOT_PLAYER = new OnlinePlayer("606e2ff0ed7748429d6ce1d3321c7838", "[Ranked Bot]", 0, null, null, null, false, (List)Lists.newArrayList(), true, true){

        @Override
        @Nullable
        public Integer getEloRank() {
            return null;
        }

        @Override
        @Nullable
        public Integer getEloRate() {
            return null;
        }

        @Override
        public boolean isInteractable() {
            return false;
        }
    };
    public static final OnlinePlayer ANONYMOUS_PLAYER = new OnlinePlayer("606e2ff0ed7748429d6ce1d3321c7838", "[Opponent]", 0, null, null, null, false, (List)Lists.newArrayList(), false, false){

        @Override
        @Nullable
        public Integer getEloRank() {
            return null;
        }

        @Override
        @Nullable
        public Integer getEloRate() {
            return null;
        }
    };
    public static final OnlinePlayer ANONYMOUS_PLAYER_2 = new OnlinePlayer("d3c47f6fae3a45c1ad7ce2c762b03ae6", "[Opponent2]", 0, null, null, null, false, (List)Lists.newArrayList(), false, false){

        @Override
        @Nullable
        public Integer getEloRank() {
            return null;
        }

        @Override
        @Nullable
        public Integer getEloRate() {
            return null;
        }
    };
    public static final OnlinePlayer DUMMY_PLAYER = new OnlinePlayer("606e2ff0ed7748429d6ce1d3321c7838", "???", 0, null, null, null, false, Lists.newArrayList(), false, false);
    private final boolean spectator;
    private final List<PlayerAchievement> achievements;
    private final boolean chatDisabled;
    private final boolean anonymous;
    private boolean hideOnClient = false;
    private PlayerStatus status = PlayerStatus.ONLINE;
    private String twitchId = null;

    protected OnlinePlayer(String uuid, String nickname, int roleType, @Nullable Integer eloRate, @Nullable Integer eloRank, @Nullable String country, boolean spectator, List<PlayerAchievement> achievements, boolean chatDisabled, boolean anonymous) {
        super(uuid, nickname, roleType, eloRate, eloRank, country);
        this.spectator = spectator;
        this.achievements = achievements;
        this.chatDisabled = chatDisabled;
        this.anonymous = anonymous;
    }

    public static OnlinePlayer of(String json) {
        JsonArray dataArray = (JsonArray)MCSRRankedClient.GSON.fromJson(json, JsonArray.class);
        OnlinePlayer result = new OnlinePlayer(dataArray.get(0).getAsString(), dataArray.get(1).getAsString(), dataArray.get(2).getAsInt(), dataArray.get(3).isJsonNull() ? null : Integer.valueOf(dataArray.get(3).getAsInt()), dataArray.get(4).isJsonNull() ? null : Integer.valueOf(dataArray.get(4).getAsInt()), dataArray.get(5).isJsonNull() ? null : dataArray.get(5).getAsString(), dataArray.get(6).getAsInt() != 0, (List)MCSRRankedClient.GSON.fromJson(dataArray.get(7).toString(), PlayerAchievement.LIST_TYPE_TOKEN), dataArray.get(8).getAsInt() != 0, dataArray.get(9).getAsInt() != 0);
        if (MCSRRankedClient.LOCAL_PLAYER != null && MCSRRankedClient.LOCAL_PLAYER.equals(result)) {
            MCSRRankedClient.LOCAL_PLAYER = result;
        }
        result.setStatus(PlayerStatus.ONLINE);
        return result;
    }

    public UUID getDisplayUUID() {
        return this.isHideOnClient() ? ANONYMOUS_PLAYER.getUUID() : this.getUUID();
    }

    @Override
    public String getNickname() {
        return this.isHideOnClient() ? ANONYMOUS_PLAYER.getNickname() : super.getNickname();
    }

    @Override
    @Nullable
    public Integer getEloRank() {
        return this.isHideOnClient() || (Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_ELO_SCORE) != false ? ANONYMOUS_PLAYER.getEloRank() : super.getEloRank();
    }

    @Override
    @Nullable
    public Integer getEloRate() {
        return this.isHideOnClient() || (Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_ELO_SCORE) != false ? ANONYMOUS_PLAYER.getEloRate() : super.getEloRate();
    }

    @Override
    public int getRoleType() {
        return this.isHideOnClient() ? ANONYMOUS_PLAYER.getRoleType() : super.getRoleType();
    }

    public List<PlayerAchievement> getAchievements() {
        return this.achievements;
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    public boolean isChatDisabled() {
        return this.chatDisabled || PlayerMuteManager.isMutedPlayer(this.getUUID());
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setHideOnClient(boolean hide) {
        this.hideOnClient = hide;
    }

    public boolean isHideOnClient() {
        return this.hideOnClient && this != ANONYMOUS_PLAYER;
    }

    public void setStatus(PlayerStatus status) {
        this.status = status;
    }

    public PlayerStatus getStatus() {
        return this.status;
    }

    public String getTwitchId() {
        return this.twitchId;
    }

    public void setTwitchId(String twitchId) {
        this.twitchId = twitchId;
    }

    public boolean isInteractable() {
        return true;
    }
}

