/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerConnections {
    private final ConcurrentHashMap<String, Connection> connectionMap = new ConcurrentHashMap();

    public static PlayerConnections of(String data) {
        PlayerConnections connections = new PlayerConnections();
        JsonObject jsonObject = new JsonParser().parse(data).getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            connections.setConnection((String)entry.getKey(), (Connection)MCSRRankedClient.GSON.fromJson((JsonElement)entry.getValue(), Connection.class));
        }
        return connections;
    }

    public Connection getConnection(String key) {
        if (this.connectionMap.containsKey(key)) {
            return this.connectionMap.get(key);
        }
        return null;
    }

    public void setConnection(String key, Connection connection) {
        if (connection == null) {
            this.connectionMap.remove(key);
        } else {
            this.connectionMap.put(key, connection);
        }
    }

    public static class Connection {
        private final String id;
        private final String name;
        private boolean visible;

        public Connection(String id, String name, boolean visible) {
            this.id = id;
            this.name = name;
            this.visible = visible;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }
}

