/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class PlayerCountry {
    private static final List<PlayerCountry> CUSTOM_COUNTRIES = Lists.newArrayList();
    private static final Set<String> RTL_LANGUAGE = Sets.newHashSet((Object[])new String[]{"ar", "he", "fa", "ur", "dv", "ps", "sd", "ug", "yi"});
    private static final Map<String, PlayerCountry> CACHED_COUNTRY = Maps.newHashMap();
    private final String code;
    private final String name;
    private final String localeName;
    private final Locale locale;

    public static Set<PlayerCountry> getAvailableCountries() {
        if (!CACHED_COUNTRY.isEmpty()) {
            return Sets.newHashSet(CACHED_COUNTRY.values());
        }
        HashMap codeToLang = Maps.newHashMap();
        try {
            class_3298 resource = class_310.method_1551().method_1478().method_14486(new class_2960("mcsrranked", "iso3166_lang.json"));
            JsonObject langObject = (JsonObject)MCSRRankedClient.GSON.fromJson((Reader)new InputStreamReader(resource.method_14482()), JsonObject.class);
            for (Map.Entry entry : langObject.entrySet()) {
                codeToLang.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet countries = Sets.newHashSet();
        for (String isoCode : Locale.getISOCountries()) {
            String localName;
            Locale locale = new Locale(codeToLang.getOrDefault(isoCode.toLowerCase(), "en"), isoCode);
            String englishName = locale.getDisplayCountry(Locale.ENGLISH);
            if (englishName.isEmpty() || (localName = locale.getDisplayCountry(locale)).isEmpty()) continue;
            if (RTL_LANGUAGE.contains(locale.getLanguage())) {
                try {
                    Bidi bidi = new Bidi(new ArabicShaping(8).shape(localName), 127);
                    bidi.setReorderingMode(0);
                    localName = bidi.writeReordered(10);
                }
                catch (ArabicShapingException bidi) {
                    // empty catch block
                }
            }
            PlayerCountry country = new PlayerCountry(isoCode.toLowerCase(), englishName, localName, locale);
            if (!class_310.method_1551().method_1478().method_18234(country.getFlagIdentifier())) continue;
            countries.add(country);
            CACHED_COUNTRY.putIfAbsent(country.getCode(), country);
        }
        countries.addAll(CUSTOM_COUNTRIES);
        return countries;
    }

    public static PlayerCountry of(String code) {
        if (CACHED_COUNTRY.isEmpty()) {
            PlayerCountry.getAvailableCountries();
        }
        return CACHED_COUNTRY.get(code);
    }

    public static boolean renderCountryFlag(@Nullable PlayerCountry country, class_4587 matrixStack, int x, int y, int width, int height, RankedScreen screen, int mouseX, int mouseY) {
        if (country == null) {
            return false;
        }
        if (!class_310.method_1551().method_1478().method_18234(country.getFlagIdentifier())) {
            return false;
        }
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_22813(country.getFlagIdentifier());
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)128, (int)85, (int)128, (int)85);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        if (mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height) {
            screen.setTooltip(new class_2585(country.getContext()));
        }
        return true;
    }

    public PlayerCountry(String code, String name, String localeName, Locale locale) {
        this.code = code;
        this.name = name;
        this.localeName = localeName;
        this.locale = locale;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlayerCountry) {
            return this.getCode().equals(((PlayerCountry)obj).getCode());
        }
        return false;
    }

    public String getContext() {
        return String.format("%s (%s)", this.getName(), this.getLocaleName());
    }

    public class_2960 getFlagIdentifier() {
        return this.getFlagIdentifier(true);
    }

    public class_2960 getFlagIdentifier(boolean rounded) {
        return new class_2960("mcsrranked", "textures/flags/" + (rounded ? "frame_" : "") + this.getCode() + ".png");
    }

    public boolean isSearchable(String name) {
        name = name.toLowerCase();
        if (this.getName().toLowerCase().contains(name)) {
            return true;
        }
        if (this.getLocaleName().toLowerCase().contains(name)) {
            return true;
        }
        if (this.getLocale().getCountry().toLowerCase().contains(name)) {
            return true;
        }
        if (this.getLocale().getISO3Country().toLowerCase().contains(name)) {
            return true;
        }
        return this.getName().replaceAll("[^A-Z]", "").toLowerCase().contains(name);
    }
}

