/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player;

import java.util.Collections;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public enum PlayerTier {
    UNRATED(0, class_124.field_1080, "???", -1, -1, 0),
    COAL_1(1, class_124.field_1080, "Coal", 0, 399, 1),
    COAL_2(1, class_124.field_1080, "Coal", 400, 499, 2),
    COAL_3(1, class_124.field_1080, "Coal", 500, 599, 3),
    IRON_1(3, class_124.field_1068, "Iron", 600, 699, 1),
    IRON_2(3, class_124.field_1068, "Iron", 700, 799, 2),
    IRON_3(3, class_124.field_1068, "Iron", 800, 899, 3),
    GOLD_1(4, class_124.field_1065, "Gold", 900, 999, 1),
    GOLD_2(4, class_124.field_1065, "Gold", 1000, 1099, 2),
    GOLD_3(4, class_124.field_1065, "Gold", 1100, 1199, 3),
    EMERALD_1(6, class_124.field_1060, "Emerald", 1200, 1299, 1),
    EMERALD_2(6, class_124.field_1060, "Emerald", 1300, 1399, 2),
    EMERALD_3(6, class_124.field_1060, "Emerald", 1400, 1499, 3),
    DIAMOND_1(5, class_124.field_1075, "Diamond", 1500, 1649, 1),
    DIAMOND_2(5, class_124.field_1075, "Diamond", 1650, 1799, 2),
    DIAMOND_3(5, class_124.field_1075, "Diamond", 1800, 1999, 3),
    NETHERITE(7, class_124.field_1054, "Netherite", 2000, Integer.MAX_VALUE, 0);

    public static final class_2960 TIER_BADGE;
    public static final int TIER_ICON_SIZE = 13;
    private final int offset;
    private final class_124 formatting;
    private final String name;
    private final int min;
    private final int max;
    private final int tier;

    private PlayerTier(int offset, class_124 formatting, String name, int min, int max, int tier) {
        this.offset = offset;
        this.formatting = formatting;
        this.name = name;
        this.min = min;
        this.max = max;
        this.tier = tier;
    }

    public static PlayerTier fromScore(Integer score) {
        if (score == null) {
            return UNRATED;
        }
        for (PlayerTier value : PlayerTier.values()) {
            if (value.getMaxScore() < score || value.getMinScore() > score) continue;
            return value;
        }
        return UNRATED;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getName() + (this.getTierString().isEmpty() ? "" : " " + this.getTierString());
    }

    public String getTierString() {
        return String.join((CharSequence)"", Collections.nCopies(this.getTier(), "I"));
    }

    public int getTier() {
        return this.tier;
    }

    public class_124 getFormatting() {
        return this.formatting;
    }

    public int getMinScore() {
        return this.min;
    }

    public int getMaxScore() {
        return this.max;
    }

    public class_5250 getText() {
        return new class_2585("").method_10852((class_2561)new class_2585(this.getFullName()).method_27692(this.getFormatting()));
    }

    public void renderBadge(class_4587 matrixStack, int x, int y, int width, int height) {
        class_310.method_1551().method_1531().method_22813(TIER_BADGE);
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)(this.offset * 13), (float)0.0f, (int)13, (int)13, (int)104, (int)26);
    }

    static {
        TIER_BADGE = new class_2960("mcsrranked", "textures/gui/rank_badge.png");
    }
}

