/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player.achievement;

import com.google.common.collect.Lists;
import com.mcsrranked.client.info.player.PlayerTier;
import com.mcsrranked.client.info.player.achievement.AchievementWorker;
import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.utils.ClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class AchievementManager {
    public static final AchievementWorker EMPTY = new AchievementWorker(achievement -> new class_2588("projectelo.text.empty_achievement_place"), (matrixStack, x, y, achievement) -> {
        class_310.method_1551().method_1531().method_22813(PlayerTier.TIER_BADGE);
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)13, (int)13, (int)104, (int)26);
    }, achievement -> Lists.newArrayList());
    private static final Map<Integer, Integer> bestTimeMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, -1);
            this.put(2, 30);
            this.put(3, 20);
            this.put(4, 15);
            this.put(5, 13);
            this.put(6, 12);
            this.put(7, 11);
            this.put(8, 10);
            this.put(9, 9);
            this.put(10, 8);
            this.put(11, 7);
            this.put(12, 6);
        }
    };
    private static final Map<Integer, Integer> seasonResultMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 12);
            this.put(2, 11);
            this.put(3, 10);
            this.put(4, 8);
            this.put(5, 6);
            this.put(6, 4);
            this.put(7, 2);
        }
    };
    private static final Map<Integer, Integer> weeklyRaceMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 12);
            this.put(2, 11);
            this.put(3, 9);
            this.put(4, 0);
        }
    };
    private static final Map<Integer, Integer> playtimeMap = new HashMap<Integer, Integer>(){
        {
            this.put(1, 1);
            this.put(2, 5);
            this.put(3, 10);
            this.put(4, 20);
            this.put(5, 50);
            this.put(6, 100);
            this.put(7, 200);
            this.put(8, 500);
            this.put(9, 1000);
            this.put(10, 2000);
            this.put(11, 5000);
            this.put(12, 10000);
        }
    };
    private static final Map<String, AchievementWorker> WORKERS = new HashMap<String, AchievementWorker>(){
        {
            this.put("seasonResult", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.season_top", new Object[]{achievement.getData()[0], achievement.getData()[1]}), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, (Integer)seasonResultMap.get(achievement.getLevel()));
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/season_" + achievement.getLevel() + ".png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 class_25612 = class_2561.method_30163((String)("#" + achievement.getData()[1]));
                int n = x + 32 - textRenderer.method_1727("#" + achievement.getData()[1]);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, class_25612, n, y + 32 - 9, 0xFFFFFF);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, class_2561.method_30163((String)("S" + achievement.getData()[0])), x, y, 0xFFFFFF);
            }, achievement -> Lists.newArrayList()));
            this.put("playoffsResult", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.playoffs_" + achievement.getLevel(), new Object[]{achievement.getData()[0]}), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/playoffs_" + achievement.getLevel() + ".png"));
                int size = achievement.getLevel() < 4 ? 32 : 24;
                int offset = size == 24 ? 4 : 0;
                class_332.method_25293((class_4587)matrixStack, (int)(x + offset), (int)(y + offset), (int)size, (int)size, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                class_327 textRenderer = class_310.method_1551().field_1772;
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, class_2561.method_30163((String)("S" + achievement.getData()[0])), x, y, 0xFFFFFF);
            }, achievement -> Lists.newArrayList()));
            this.put("bestTime", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.best_time").method_27693(" " + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, achievement.getLevel());
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/level/best_time.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                int subNumber = bestTimeMap.getOrDefault(achievement.getLevel(), -1);
                String text = subNumber == -1 ? "Any" : "Sub" + subNumber;
                class_2561 class_25612 = class_2561.method_30163((String)text);
                int n = x + 32 - textRenderer.method_1727(text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, class_25612, n, y + 30 - 9, 0xFFFFFF);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.best_time.description")}), InGameTimerUtils::timeToStringFormat, (class_2561)new class_2585("")));
            this.put("highestWinStreak", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.highest_win_streak").method_27693(" " + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, achievement.getLevel());
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/level/win_streak.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = class_2561.method_30163((String)("Lv." + achievement.getLevel()));
                int n = x + 32 - textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, text, n, y + 30 - 9, 0xFFFFFF);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.highest_win_streak.description")}), String::valueOf, (class_2561)new class_2585("Wins")));
            this.put("playedMatches", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.played_matches").method_27693(" " + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, achievement.getLevel());
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/level/match_played_" + ((achievement.getLevel() - 1) / 3 + 1) + ".png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = class_2561.method_30163((String)("Lv." + achievement.getLevel()));
                int n = x + 32 - textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, text, n, y + 30 - 9, 0xFFFFFF);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.played_matches.description")}), String::valueOf, (class_2561)new class_2585("Matches")));
            this.put("playtime", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.playtime").method_27693(" " + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, achievement.getLevel());
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/level/playtime.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                int playtimeHour = playtimeMap.getOrDefault(achievement.getLevel(), 1);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = class_2561.method_30163((String)(ClientUtils.getThousandFormat(playtimeHour) + "H+"));
                int n = x + 32 - textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, text, n, y + 30 - 9, 0xFFFFFF);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.playtime.description")}), x$0 -> AchievementManager.getPlaytimeHour(x$0), (class_2561)new class_2585("")));
            this.put("wins", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.wins").method_27693(" " + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, achievement.getLevel());
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/level/wins_2.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = class_2561.method_30163((String)("Lv." + achievement.getLevel()));
                int n = x + 32 - textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, text, n, y + 30 - 9, 0xFFFFFF);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.wins.description")}), String::valueOf, (class_2561)new class_2585("Wins")));
            this.put("weeklyRace", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.weekly_race_" + achievement.getLevel()), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, (Integer)weeklyRaceMap.get(achievement.getLevel()));
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/weekly_race_" + achievement.getLevel() + ".png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_327 textRenderer = class_310.method_1551().field_1772;
                class_2561 text = class_2561.method_30163((String)("x" + achievement.getData()[0]));
                int n = x + 32 - textRenderer.method_27525((class_5348)text);
                Objects.requireNonNull(textRenderer);
                ClientUtils.drawTextWithOutLine(textRenderer, matrixStack, text, n, y + 32 - 9, 0xFFFFFF);
            }, achievement -> class_310.method_1551().field_1772.method_1728((class_5348)new class_2588("projectelo.achievement.weekly_race_" + achievement.getLevel() + ".description", new Object[]{achievement.getData()[0]}), 220)));
            this.put("summonWither", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.summon_wither"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/summon_wither.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.summon_wither.description")})));
            this.put("highLevel", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.60xp"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/60xp.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.60xp.description")})));
            this.put("armorless", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.armorless"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/armorless.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/cross_overlay.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.armorless.description")})));
            this.put("classicRun", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.bastionless"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/bastionless.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/cross_overlay.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.bastionless.description")})));
            this.put("overtake", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.end_reset"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/end_reset.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.end_reset.description")})));
            this.put("foodless", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.foodless"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/foodless.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/cross_overlay.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.foodless.description")})));
            this.put("ironHoe", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.iron_hoe"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/iron_hoe.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.iron_hoe.description")})));
            this.put("ironPickless", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.iron_pickless"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/iron_pickless.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/cross_overlay.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.iron_pickless.description")})));
            this.put("netherite", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.netherite"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/netherite.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.netherite.description")})));
            this.put("oneshot", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.oneshot"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/oneshot.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.oneshot.description")})));
            this.put("egapHolder", new AchievementWorker(achievement -> new class_2588("projectelo.achievement.uneaten_god_apple"), (matrixStack, x, y, achievement) -> {
                AchievementManager.renderAchievementFrame(matrixStack, x, y, 0);
                class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/icon/onetime/uneaten_god_apple.png"));
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }, achievement -> Lists.newArrayList((Object[])new class_5348[]{new class_2588("projectelo.achievement.uneaten_god_apple.description")})));
            this.put("empty", EMPTY);
        }
    };

    private static void renderAchievementFrame(class_4587 matrixStack, int x, int y, int level) {
        class_310.method_1551().method_1531().method_22813(new class_2960("mcsrranked", "textures/achievements/base/" + (level == 0 ? "onetime" : Integer.valueOf(level)) + ".png"));
        class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)32, (int)32, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
    }

    private static String getPlaytimeHour(long time) {
        return Math.floor((double)time / 3600000.0 * 10.0) / 10.0 + "h";
    }

    public static AchievementWorker getWorker(PlayerAchievement achievement) {
        return WORKERS.get(achievement.getID());
    }
}

